/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.gds.DirectoryType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/GDS/;i=63")
public interface CertificateDirectoryType
extends DirectoryType {
    public static final String START_SIGNING_REQUEST = "StartSigningRequest";
    public static final String START_NEW_KEY_PAIR_REQUEST = "StartNewKeyPairRequest";
    public static final String FINISH_REQUEST = "FinishRequest";
    public static final String REVOKE_CERTIFICATE = "RevokeCertificate";
    public static final String GET_CERTIFICATE_GROUPS = "GetCertificateGroups";
    public static final String GET_TRUST_LIST = "GetTrustList";
    public static final String GET_CERTIFICATE_STATUS = "GetCertificateStatus";

    @Mandatory
    public UaMethod getStartSigningRequestNode();

    public NodeId startSigningRequest(NodeId var1, NodeId var2, NodeId var3, ByteString var4) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getStartNewKeyPairRequestNode();

    public NodeId startNewKeyPairRequest(NodeId var1, NodeId var2, NodeId var3, String var4, String[] var5, String var6, String var7) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getFinishRequestNode();

    public FinishRequestMethodOutputs finishRequest(NodeId var1, NodeId var2) throws StatusException, ServiceException;

    @Optional
    public UaMethod getRevokeCertificateNode();

    public void revokeCertificate(NodeId var1, ByteString var2) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getGetCertificateGroupsNode();

    public NodeId[] getCertificateGroups(NodeId var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getGetTrustListNode();

    public NodeId getTrustList(NodeId var1, NodeId var2) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getGetCertificateStatusNode();

    public Boolean getCertificateStatus(NodeId var1, NodeId var2, NodeId var3) throws StatusException, ServiceException;

    public static class FinishRequestMethodOutputs
    implements MethodOutputArguments {
        protected ByteString certificate;
        protected ByteString privateKey;
        protected ByteString[] issuerCertificates;

        public FinishRequestMethodOutputs(ByteString byteString, ByteString byteString2, ByteString[] byteStringArray) {
            this.certificate = byteString;
            this.privateKey = byteString2;
            this.issuerCertificates = byteStringArray;
        }

        public ByteString getCertificate() {
            return this.certificate;
        }

        public ByteString getPrivateKey() {
            return this.privateKey;
        }

        public ByteString[] getIssuerCertificates() {
            return this.issuerCertificates;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.certificate), new Variant(this.privateKey), new Variant(this.issuerCertificates)};
        }
    }
}

