/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.typedictionary.DynamicStructureSerializer;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.Arrays;

public class FieldSpecification {
    private final String name;
    private final Class<?> javaClass;
    private final boolean zj;
    private final DynamicStructureSerializer zk;
    private final EnumerationSpecification zl;
    private final UaNodeId zm;
    private final String description;
    private final int[] zn;
    private final int maxStringLength;
    private final int fC;

    public static Builder builder() {
        return new Builder();
    }

    private FieldSpecification(String string, Class<?> clazz, boolean bl, DynamicStructureSerializer dynamicStructureSerializer, EnumerationSpecification enumerationSpecification, UaNodeId uaNodeId, String string2, int[] nArray, int n2, int n3) {
        this.name = string;
        this.javaClass = clazz;
        this.zj = bl;
        this.zk = dynamicStructureSerializer;
        this.zl = enumerationSpecification;
        this.zm = uaNodeId;
        this.description = string2;
        this.zn = nArray;
        this.maxStringLength = n2;
        this.fC = n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FieldSpecification fieldSpecification = (FieldSpecification)object;
        if (!Arrays.equals(this.zn, fieldSpecification.zn)) {
            return false;
        }
        if (this.zm == null ? fieldSpecification.zm != null : !this.zm.equals(fieldSpecification.zm)) {
            return false;
        }
        if (this.description == null ? fieldSpecification.description != null : !this.description.equals(fieldSpecification.description)) {
            return false;
        }
        if (this.zj != fieldSpecification.zj) {
            return false;
        }
        if (this.maxStringLength != fieldSpecification.maxStringLength) {
            return false;
        }
        return !(this.name == null ? fieldSpecification.name != null : !this.name.equals(fieldSpecification.name));
    }

    public int[] getArrayDimensions() {
        if (this.zn == null || this.zn.length == 0) {
            return this.zn;
        }
        return (int[])this.zn.clone();
    }

    public UaNodeId getDataTypeId() {
        return this.zm;
    }

    public String getDescription() {
        return this.description;
    }

    public EnumerationSpecification getEnumerationSpecification() {
        return this.zl;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public String getName() {
        return this.name;
    }

    public DynamicStructureSerializer getSerializer() {
        return this.zk;
    }

    public int getValueRank() {
        return this.fC;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.zn);
        n3 = 31 * n3 + (this.zm == null ? 0 : this.zm.hashCode());
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.zj ? 1231 : 1237);
        n3 = 31 * n3 + this.maxStringLength;
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        return n3;
    }

    public boolean isArray() {
        return this.fC != -1;
    }

    public boolean isOptional() {
        return this.zj;
    }

    public Builder toBuilder() {
        Builder builder = FieldSpecification.builder();
        builder.setDataTypeId(this.zm);
        builder.setEnumerationSpecification(this.zl);
        builder.setJavaClass(this.javaClass);
        builder.setName(this.name);
        builder.setIsOptional(this.zj);
        builder.setSerializer(this.zk);
        builder.setDescription(this.description);
        builder.setValueRank(this.fC);
        builder.setArrayDimensions(this.zn);
        builder.setMaxStringLength(this.maxStringLength);
        return builder;
    }

    public String toString() {
        return "FieldSpecification [name=" + this.name + ", javaClass=" + this.javaClass + ", isOptional=" + this.zj + ", dataTypeId=" + this.zm + ", description=" + this.description + ", arrayDimensions=" + Arrays.toString(this.zn) + ", maxStringLength=" + this.maxStringLength + ", valueRank=" + this.fC + "]";
    }

    public static class Builder {
        private String name = null;
        private Class<?> javaClass = null;
        private boolean zj = false;
        private DynamicStructureSerializer zk = null;
        private int fC = -1;
        private EnumerationSpecification zl = null;
        private UaNodeId zm = null;
        private String description = null;
        private int[] zn = null;
        private int maxStringLength = 0;

        private Builder() {
        }

        public FieldSpecification build() {
            return new FieldSpecification(this.name, this.javaClass, this.zj, this.zk, this.zl, this.zm, this.description, this.zn, this.maxStringLength, this.fC);
        }

        public Builder setArrayDimensions(int ... nArray) {
            if (nArray == null || nArray.length == 0) {
                this.zn = nArray;
            } else {
                for (int n2 : nArray) {
                    if (n2 >= 0) continue;
                    throw new IllegalArgumentException("The given ArrayDimensions contains a negative value");
                }
                this.zn = (int[])nArray.clone();
            }
            return this;
        }

        public Builder setDataTypeId(UaNodeId uaNodeId) {
            this.zm = uaNodeId;
            return this;
        }

        public Builder setDescription(String string) {
            this.description = string;
            return this;
        }

        public Builder setEnumerationSpecification(EnumerationSpecification enumerationSpecification) {
            this.zl = enumerationSpecification;
            return this;
        }

        public Builder setIsOptional(boolean bl) {
            this.zj = bl;
            return this;
        }

        public Builder setJavaClass(Class<?> clazz) {
            this.javaClass = clazz;
            return this;
        }

        public Builder setMaxStringLength(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Given max String length cannot be negative");
            }
            this.maxStringLength = n2;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setSerializer(DynamicStructureSerializer dynamicStructureSerializer) {
            this.zk = dynamicStructureSerializer;
            return this;
        }

        public Builder setValueRank(int n2) {
            if (n2 < -1 || n2 == 0) {
                throw new IllegalArgumentException("The given ValueRank must be either -1 or 1 or larger)");
            }
            this.fC = n2;
            return this;
        }
    }
}

