/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumerationSpecification {
    private static final Logger logger = LoggerFactory.getLogger(EnumerationSpecification.class);
    private final UaNodeId ze;
    private final String name;
    private final Map<Integer, String> zf;
    private final Map<String, Integer> zg;
    private final EnumerationBuilderSupplier zh;

    public static Builder builder() {
        return new Builder();
    }

    private EnumerationSpecification(UaNodeId uaNodeId, String string, Map<Integer, String> map, Map<String, Integer> map2, EnumerationBuilderSupplier enumerationBuilderSupplier) {
        this.ze = uaNodeId;
        this.name = string;
        this.zf = map;
        this.zg = map2;
        this.zh = enumerationBuilderSupplier;
    }

    public DynamicEnumeration createEnumerationFromInteger(int n2) {
        return DynamicEnumeration.builder(this).setValue(n2).build();
    }

    public DynamicEnumeration createEnumerationFromString(String string) {
        Integer n2 = this.zg.get(string);
        if (n2 == null) {
            throw new IllegalArgumentException("This enumeration does not have value: " + string);
        }
        return DynamicEnumeration.builder(this).setValue(n2).build();
    }

    public Set<Integer> getAllIntegerValues() {
        return Collections.unmodifiableSet(this.zf.keySet());
    }

    public Set<String> getAllStringValues() {
        return Collections.unmodifiableSet(this.zg.keySet());
    }

    public Map<Integer, String> getIntToStringMappings() {
        return Collections.unmodifiableMap(this.zf);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Integer> getStringToIntMappings() {
        return Collections.unmodifiableMap(this.zg);
    }

    public UaNodeId getTypeId() {
        if (this.ze == null && "IdType".equals(this.name)) {
            return UaNodeId.from(NamespaceTable.OPCUA_NAMESPACE, Identifiers.IdType.getValue());
        }
        return this.ze;
    }

    public Builder toBuilder() {
        Builder builder = EnumerationSpecification.builder();
        builder.setTypeId(this.ze);
        builder.setName(this.name);
        builder.setMappings(this.zf);
        return builder;
    }

    public Enumeration.Builder toEnumerationBuilder() {
        if (this.zh == null) {
            return DynamicEnumeration.builder(this);
        }
        return this.zh.get();
    }

    public static interface EnumerationBuilderSupplier {
        public Enumeration.Builder get();
    }

    public static class Builder {
        private UaNodeId ze = null;
        private String name = null;
        private final Map<Integer, String> zf = new HashMap<Integer, String>();
        private final Map<String, Integer> zg = new HashMap<String, Integer>();
        private EnumerationBuilderSupplier zh = null;

        private Builder() {
        }

        public Builder addMapping(int n2, String string) {
            this.zf.put(n2, string);
            if (this.zg.put(string, n2) != null) {
                logger.warn("Duplicate String mapping '{}' for given Enumeration {} Integer value '{}'", new Object[]{string, this.name, n2});
            }
            return this;
        }

        public EnumerationSpecification build() {
            return new EnumerationSpecification(this.ze, this.name, this.zf, this.zg, this.zh);
        }

        public Builder setBuilderSupplier(EnumerationBuilderSupplier enumerationBuilderSupplier) {
            this.zh = enumerationBuilderSupplier;
            return this;
        }

        public Builder setMappings(Map<Integer, String> map) {
            this.zf.clear();
            this.zg.clear();
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                this.addMapping(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setTypeId(UaNodeId uaNodeId) {
            this.ze = uaNodeId;
            return this;
        }
    }
}

