/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicStructureSerializer
extends StructureSerializer
implements IEncodeableSerializer {
    private static final Logger logger = LoggerFactory.getLogger(DynamicStructureSerializer.class);
    private final IEncodeableSerializer zc;
    private final StructureSpecification zd;

    public DynamicStructureSerializer(IEncodeableSerializer iEncodeableSerializer, StructureSpecification structureSpecification) {
        super(DynamicStructure.class, structureSpecification.getBinaryEncodeId().asExpandedNodeId(), structureSpecification.getXmlEncodeId() == null ? null : structureSpecification.getXmlEncodeId().asExpandedNodeId());
        this.zc = iEncodeableSerializer;
        this.zd = structureSpecification;
    }

    @Override
    public void calcEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (DynamicStructure.class.equals(clazz)) {
            DynamicStructure dynamicStructure = (DynamicStructure)iEncodeable;
            if (StructureSpecification.StructureType.OPTIONAL == this.zd.getStructureType()) {
                iEncoder.putUInt32("EncodingMask", UnsignedInteger.ZERO);
            }
            if (StructureSpecification.StructureType.UNION == this.zd.getStructureType()) {
                if (dynamicStructure == null) {
                    iEncoder.putUInt32("SwitchField", UnsignedInteger.ZERO);
                    return;
                }
                long l2 = 0L;
                FieldSpecification fieldSpecification = null;
                for (FieldSpecification fieldSpecification2 : this.zd.getFields()) {
                    ++l2;
                    if (dynamicStructure.get(fieldSpecification2) == null) continue;
                    fieldSpecification = fieldSpecification2;
                    break;
                }
                if (fieldSpecification == null) {
                    iEncoder.putUInt32("SwitchField", UnsignedInteger.ZERO);
                    return;
                }
                iEncoder.putUInt32("SwitchField", UnsignedInteger.valueOf(l2));
                this.a(dynamicStructure.get(fieldSpecification), fieldSpecification, iEncoder, true, "Value");
                return;
            }
            for (FieldSpecification fieldSpecification : this.zd.getFields()) {
                this.a(dynamicStructure.get(fieldSpecification), fieldSpecification, iEncoder, true, null);
            }
        } else {
            this.zc.calcEncodeable(clazz, iEncodeable, iEncoder);
        }
    }

    @Override
    public void calcEncodeable(IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (iEncodeable == null) {
            throw new EncodingException("DynamicStructureSerializer cannot encode null encodeable");
        }
        this.calcEncodeable(iEncodeable.getClass(), iEncodeable, iEncoder);
    }

    @Override
    public Class<? extends IEncodeable> getClass(ExpandedNodeId expandedNodeId) {
        if (this.zd.isType(expandedNodeId)) {
            return DynamicStructure.class;
        }
        return this.zc.getClass(expandedNodeId);
    }

    @Override
    public IEncodeable getEncodeable(Class<? extends IEncodeable> clazz, IDecoder iDecoder) throws DecodingException {
        if (DynamicStructure.class.equals(clazz)) {
            DynamicStructure dynamicStructure = new DynamicStructure(this.zd);
            return this.a(iDecoder, dynamicStructure);
        }
        return this.zc.getEncodeable(clazz, iDecoder);
    }

    @Override
    public IEncodeable getEncodeable(IDecoder iDecoder) throws DecodingException {
        return this.getEncodeable(DynamicStructure.class, iDecoder);
    }

    @Override
    public void getEncodeable(IDecoder iDecoder, IEncodeable iEncodeable) throws DecodingException {
        super.getEncodeable(iDecoder, iEncodeable);
        DynamicStructure dynamicStructure = (DynamicStructure)iEncodeable;
        this.a(iDecoder, dynamicStructure);
    }

    @Override
    public ExpandedNodeId getNodeId(Class<? extends IEncodeable> clazz, EncodeType encodeType) {
        if (DynamicStructure.class.equals(clazz)) {
            if (EncodeType.Binary == encodeType) {
                return this.zd.getBinaryEncodeId().asExpandedNodeId();
            }
            if (EncodeType.Xml == encodeType && this.zd.getXmlEncodeId() != null) {
                return this.zd.getXmlEncodeId().asExpandedNodeId();
            }
            return null;
        }
        return this.zc.getNodeId(clazz, encodeType);
    }

    @Override
    public void getSupportedClasses(Collection<Class<? extends IEncodeable>> collection) {
        this.zc.getSupportedClasses(collection);
        collection.add(DynamicStructure.class);
    }

    @Override
    public void getSupportedNodeIds(Collection<ExpandedNodeId> collection) {
        this.zc.getSupportedNodeIds(collection);
        collection.add(this.zd.getTypeId().asExpandedNodeId());
        collection.add(this.zd.getBinaryEncodeId().asExpandedNodeId());
        if (this.zd.getXmlEncodeId() != null) {
            collection.add(this.zd.getXmlEncodeId().asExpandedNodeId());
        }
    }

    @Override
    public IEncodeable newEncodeable() {
        return new DynamicStructure(this.zd);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (DynamicStructure.class.equals(clazz)) {
            DynamicStructure dynamicStructure = (DynamicStructure)iEncodeable;
            if (StructureSpecification.StructureType.UNION == this.zd.getStructureType()) {
                if (dynamicStructure == null) {
                    iEncoder.putUInt32("SwitchField", UnsignedInteger.ZERO);
                    return;
                }
                long l2 = 0L;
                FieldSpecification fieldSpecification = null;
                for (FieldSpecification fieldSpecification2 : this.zd.getFields()) {
                    ++l2;
                    if (dynamicStructure.get(fieldSpecification2) == null) continue;
                    fieldSpecification = fieldSpecification2;
                    break;
                }
                if (fieldSpecification == null) {
                    iEncoder.putUInt32("SwitchField", UnsignedInteger.ZERO);
                    return;
                }
                iEncoder.putUInt32("SwitchField", UnsignedInteger.valueOf(l2));
                this.a(dynamicStructure.get(fieldSpecification), fieldSpecification, iEncoder, false, "Value");
                return;
            }
            if (StructureSpecification.StructureType.OPTIONAL == this.zd.getStructureType()) {
                void var6_16;
                int n2 = -1;
                UnsignedInteger unsignedInteger = UnsignedInteger.ZERO;
                for (FieldSpecification object2 : this.zd.getFields()) {
                    if (!object2.isOptional()) continue;
                    ++n2;
                    if (dynamicStructure == null || dynamicStructure.get(object2) == null) continue;
                    UnsignedInteger unsignedInteger2 = DynamicStructureSerializer.putBitOn((UnsignedInteger)var6_16, n2);
                }
                iEncoder.putUInt32("EncodingMask", (UnsignedInteger)var6_16);
            }
            for (FieldSpecification fieldSpecification : this.zd.getFields()) {
                Object object3 = dynamicStructure.get(fieldSpecification);
                if (object3 == null && !fieldSpecification.isArray() && DynamicStructure.class.equals(fieldSpecification.getJavaClass())) {
                    StructureSpecification structureSpecification = iEncoder.getEncoderContext().getStructureSpecification(fieldSpecification.getDataTypeId());
                    if (structureSpecification == null) {
                        throw new EncodingException("Cannot find StructureSpecification for field DataTypeId: " + fieldSpecification.getDataTypeId());
                    }
                    object3 = new DynamicStructure(structureSpecification);
                }
                this.a(object3, fieldSpecification, iEncoder, false, null);
            }
        } else {
            this.zc.putEncodeable(clazz, iEncodeable, iEncoder);
        }
    }

    @Override
    public void putEncodeable(IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (iEncodeable == null) {
            throw new EncodingException("DynamicStructureSerializer cannot encode null encodeable");
        }
        this.putEncodeable(iEncodeable.getClass(), iEncodeable, iEncoder);
    }

    private IEncodeable a(IDecoder iDecoder, DynamicStructure dynamicStructure) throws DecodingException {
        UnsignedInteger unsignedInteger = null;
        if (StructureSpecification.StructureType.OPTIONAL == this.zd.getStructureType()) {
            unsignedInteger = iDecoder.getUInt32("EncodingMask");
            logger.trace("EncodingMask: {}", (Object)unsignedInteger);
        }
        if (StructureSpecification.StructureType.UNION == this.zd.getStructureType()) {
            unsignedInteger = iDecoder.getUInt32("SwitchField");
            long l2 = unsignedInteger.longValue();
            logger.trace("SwitchField: {}", (Object)l2);
            if (l2 < 0L) {
                throw new DecodingException("Union SwitchField must be >= 0");
            }
            if (l2 == 0L) {
                return dynamicStructure;
            }
            long l3 = 0L;
            for (FieldSpecification fieldSpecification : this.zd.getFields()) {
                if (l2 != ++l3) continue;
                logger.trace("Decoded Union Field: {}, SwitchValue: {}", (Object)fieldSpecification, (Object)l3);
                dynamicStructure.set(fieldSpecification, this.a(fieldSpecification, iDecoder));
                return dynamicStructure;
            }
            throw new DecodingException("Union SwitchField overflow: " + ++l3);
        }
        int n2 = -1;
        for (FieldSpecification fieldSpecification : this.zd.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            if (fieldSpecification.isOptional()) {
                if (!DynamicStructureSerializer.isBitOn(unsignedInteger, ++n2)) continue;
                dynamicStructure.set(fieldSpecification, this.a(fieldSpecification, iDecoder));
                continue;
            }
            dynamicStructure.set(fieldSpecification, this.a(fieldSpecification, iDecoder));
        }
        return dynamicStructure;
    }

    /*
     * WARNING - void declaration
     */
    private Object a(FieldSpecification fieldSpecification, IDecoder iDecoder) throws DecodingException {
        Object object;
        DynamicStructureSerializer dynamicStructureSerializer = fieldSpecification.getSerializer();
        if (dynamicStructureSerializer == null && DynamicStructure.class.equals(MultiDimensionArrayUtils.getComponentType(fieldSpecification.getJavaClass())) && this.zc.getClass(fieldSpecification.getDataTypeId().asExpandedNodeId()) == null && (object = (Object)iDecoder.getEncoderContext().getStructureSpecification(fieldSpecification.getDataTypeId())) != null) {
            dynamicStructureSerializer = new DynamicStructureSerializer(this.zc, (StructureSpecification)object);
        }
        if (dynamicStructureSerializer == null) {
            return iDecoder.get(fieldSpecification.getName(), fieldSpecification.getJavaClass());
        }
        if (fieldSpecification.isArray()) {
            void var6_11;
            if (fieldSpecification.getValueRank() > 1) {
                object = iDecoder.getInt32Array_(null);
                int n2 = 1;
                int[] objectArray = object;
                int n3 = objectArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = objectArray[i2];
                    n2 *= n4;
                }
                DynamicStructure[] i3 = new DynamicStructure[n2];
                for (n3 = 0; n3 < i3.length; ++n3) {
                    i3[n3] = (DynamicStructure)dynamicStructureSerializer.getEncodeable(DynamicStructure.class, iDecoder);
                }
                return MultiDimensionArrayUtils.demuxArray(i3, object);
            }
            int n4 = iDecoder.getInt32(null);
            if (n4 < 0) {
                return null;
            }
            DynamicStructure[] dynamicStructureArray = new DynamicStructure[n4];
            boolean bl = false;
            while (var6_11 < n4) {
                dynamicStructureArray[var6_11] = (DynamicStructure)dynamicStructureSerializer.getEncodeable(DynamicStructure.class, iDecoder);
                ++var6_11;
            }
            return dynamicStructureArray;
        }
        return dynamicStructureSerializer.getEncodeable(DynamicStructure.class, iDecoder);
    }

    private void a(Object object, FieldSpecification fieldSpecification, IEncoder iEncoder, boolean bl, String string) throws EncodingException {
        Object object2;
        if (fieldSpecification.isOptional() && object == null) {
            return;
        }
        DynamicStructureSerializer dynamicStructureSerializer = fieldSpecification.getSerializer();
        if (dynamicStructureSerializer == null && DynamicStructure.class.equals(MultiDimensionArrayUtils.getComponentType(fieldSpecification.getJavaClass())) && this.zc.getClass(fieldSpecification.getDataTypeId().asExpandedNodeId()) == null && (object2 = iEncoder.getEncoderContext().getStructureSpecification(fieldSpecification.getDataTypeId())) != null) {
            dynamicStructureSerializer = new DynamicStructureSerializer(this.zc, (StructureSpecification)object2);
        }
        if (dynamicStructureSerializer != null) {
            if (fieldSpecification.isArray()) {
                if (fieldSpecification.getValueRank() > 1) {
                    if (object == null) {
                        iEncoder.putInt32Array((String)null, (int[])null);
                    } else {
                        object2 = MultiDimensionArrayUtils.getArrayLengths(object);
                        DynamicStructure[] dynamicStructureArray = (DynamicStructure[])MultiDimensionArrayUtils.muxArray(object);
                        iEncoder.putInt32Array((String)null, (int[])object2);
                        for (DynamicStructure dynamicStructure : dynamicStructureArray) {
                            if (bl) {
                                dynamicStructureSerializer.calcEncodeable(DynamicStructure.class, dynamicStructure, iEncoder);
                                continue;
                            }
                            dynamicStructureSerializer.putEncodeable(DynamicStructure.class, dynamicStructure, iEncoder);
                        }
                    }
                } else {
                    object2 = (DynamicStructure[])object;
                    if (object2 == null) {
                        iEncoder.putInt32((String)null, -1);
                    } else {
                        iEncoder.putInt32((String)null, ((DynamicStructure[])object2).length);
                        for (DynamicStructure dynamicStructure : object2) {
                            if (bl) {
                                dynamicStructureSerializer.calcEncodeable(DynamicStructure.class, dynamicStructure, iEncoder);
                                continue;
                            }
                            dynamicStructureSerializer.putEncodeable(DynamicStructure.class, dynamicStructure, iEncoder);
                        }
                    }
                }
            } else if (bl) {
                dynamicStructureSerializer.calcEncodeable(DynamicStructure.class, (DynamicStructure)object, iEncoder);
            } else {
                dynamicStructureSerializer.putEncodeable(DynamicStructure.class, (DynamicStructure)object, iEncoder);
            }
            return;
        }
        iEncoder.put(bl ? null : (string == null ? fieldSpecification.getName() : string), object, fieldSpecification.getJavaClass());
    }
}

