/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicStructure
extends AbstractStructure {
    private static final Logger logger = LoggerFactory.getLogger(DynamicStructure.class);
    private final StructureSpecification za;
    private Map<String, Object> cO = new HashMap<String, Object>();

    public static Builder builder(StructureSpecification structureSpecification) {
        return new Builder(new DynamicStructure(structureSpecification));
    }

    public DynamicStructure(StructureSpecification structureSpecification) {
        if (structureSpecification == null) {
            throw new IllegalArgumentException("Given specification cannot be null");
        }
        this.za = structureSpecification;
    }

    public void clear() {
        this.cO.clear();
    }

    @Override
    public DynamicStructure clone() {
        DynamicStructure dynamicStructure = (DynamicStructure)super.clone();
        dynamicStructure.cO = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.cO.entrySet()) {
            dynamicStructure.cO.put(entry.getKey(), StructureUtils.clone(entry.getValue()));
        }
        return dynamicStructure;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynamicStructure dynamicStructure = (DynamicStructure)object;
        if (!this.za.equals(dynamicStructure.za)) {
            return false;
        }
        if (!((Object)this.cO.keySet()).equals(dynamicStructure.cO.keySet())) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.cO.entrySet()) {
            if (StructureUtils.scalarOrArrayEquals(entry.getValue(), dynamicStructure.cO.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        this.a(fieldSpecification);
        return this.cO.get(fieldSpecification.getName());
    }

    public Object get(String string) {
        FieldSpecification fieldSpecification = this.A(string);
        return this.cO.get(fieldSpecification.getName());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        if (this.za.getBinaryEncodeId() == null) {
            logger.warn("DynamicStructure with Specification {} does not support binary encoding", (Object)this.za);
            return null;
        }
        return this.za.getBinaryEncodeId().asExpandedNodeId();
    }

    public List<String> getFieldNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FieldSpecification fieldSpecification : this.getFields()) {
            arrayList.add(fieldSpecification.getName());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<FieldSpecification> getFields() {
        return Collections.unmodifiableList(this.za.getFields());
    }

    public StructureSpecification getSpecification() {
        return this.za;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return this.za.getTypeId().asExpandedNodeId();
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        if (this.za.getXmlEncodeId() == null) {
            return null;
        }
        return this.za.getXmlEncodeId().asExpandedNodeId();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.za.hashCode();
        Object[] objectArray = this.cO.values().toArray();
        n3 = 31 * n3 + StructureUtils.hashCode(objectArray);
        return n3;
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object dynamicEnumerationArray) {
        this.a(fieldSpecification);
        this.a(fieldSpecification, dynamicEnumerationArray);
        if (StructureSpecification.StructureType.UNION == this.za.getStructureType()) {
            this.cO.clear();
        }
        if (fieldSpecification.getEnumerationSpecification() != null && dynamicEnumerationArray != null) {
            if (!fieldSpecification.isArray()) {
                DynamicEnumeration dynamicEnumeration = (DynamicEnumeration)dynamicEnumerationArray;
                dynamicEnumerationArray = fieldSpecification.getEnumerationSpecification().createEnumerationFromInteger(dynamicEnumeration.getValue());
            } else if (fieldSpecification.getValueRank() == 1) {
                DynamicEnumeration[] dynamicEnumerationArray2 = dynamicEnumerationArray;
                DynamicEnumeration[] dynamicEnumerationArray3 = new DynamicEnumeration[dynamicEnumerationArray2.length];
                for (int i2 = 0; i2 < dynamicEnumerationArray2.length; ++i2) {
                    dynamicEnumerationArray3[i2] = fieldSpecification.getEnumerationSpecification().createEnumerationFromInteger(dynamicEnumerationArray2[i2].getValue());
                    dynamicEnumerationArray = dynamicEnumerationArray3;
                }
            } else {
                int[] nArray = MultiDimensionArrayUtils.getArrayLengths(dynamicEnumerationArray);
                DynamicEnumeration[] dynamicEnumerationArray4 = (DynamicEnumeration[])MultiDimensionArrayUtils.muxArray((Object)dynamicEnumerationArray, nArray, DynamicEnumeration.class);
                DynamicEnumeration[] dynamicEnumerationArray5 = new DynamicEnumeration[dynamicEnumerationArray4.length];
                for (int i3 = 0; i3 < dynamicEnumerationArray4.length; ++i3) {
                    dynamicEnumerationArray5[i3] = fieldSpecification.getEnumerationSpecification().createEnumerationFromInteger(dynamicEnumerationArray4[i3].getValue());
                }
                dynamicEnumerationArray = MultiDimensionArrayUtils.demuxArray(dynamicEnumerationArray5, nArray);
            }
        }
        this.cO.put(fieldSpecification.getName(), dynamicEnumerationArray);
    }

    public void set(String string, Object object) {
        FieldSpecification fieldSpecification = this.A(string);
        this.set(fieldSpecification, object);
    }

    @Override
    public StructureSpecification specification() {
        return this.za;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.clone());
    }

    private void a(FieldSpecification fieldSpecification) {
        if (!this.getFields().contains(fieldSpecification)) {
            throw new IllegalArgumentException("This Structure does not contain field: " + fieldSpecification);
        }
    }

    private FieldSpecification A(String string) {
        for (FieldSpecification fieldSpecification : this.getFields()) {
            if (!fieldSpecification.getName().equals(string)) continue;
            return fieldSpecification;
        }
        throw new IllegalArgumentException("This Structure does not contain field named: " + string);
    }

    private void a(FieldSpecification fieldSpecification, Object object) {
        if (object == null) {
            return;
        }
        if (!fieldSpecification.getJavaClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("For field:" + fieldSpecification + ", the given value:" + object + ", does not have correct type:" + fieldSpecification.getJavaClass() + ", instead it is:" + object.getClass());
        }
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private final DynamicStructure zb;

        protected Builder(DynamicStructure dynamicStructure) {
            this.zb = dynamicStructure;
        }

        @Override
        public DynamicStructure build() {
            return this.zb.clone();
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            this.zb.set(fieldSpecification, object);
            return this;
        }
    }
}

