/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.TreeMap;

public class OrderedByteBufferInputStream
extends InputStream {
    ByteBuffer cur;
    int next = 0;
    int last = -1;
    int yQ = -1;
    TreeMap<Integer, ByteBuffer> yR = new TreeMap();

    @Override
    public synchronized int available() throws IOException {
        ByteBuffer byteBuffer;
        int n2 = 0;
        if (this.cur != null) {
            n2 += this.cur.remaining();
        }
        for (int i2 = this.next; i2 <= this.last && (byteBuffer = this.yR.get(i2)) != null; ++i2) {
            n2 += byteBuffer.remaining();
        }
        return n2;
    }

    @Override
    public void close() {
        this.close(this.last + 1);
    }

    public synchronized void close(int n2) {
        if (this.yQ >= 0) {
            return;
        }
        if (n2 < 0 || n2 <= this.last) {
            throw new IllegalArgumentException("sequence number illegal");
        }
        this.yQ = n2;
        this.notifyAll();
    }

    public synchronized void forceClose() {
        this.yQ = this.next;
        this.notifyAll();
    }

    public void offer(ByteBuffer byteBuffer) {
        this.offer(this.last + 1, byteBuffer);
    }

    public synchronized void offer(int n2, ByteBuffer byteBuffer) {
        if (n2 < 0 || this.yR.containsKey(n2) || n2 < this.next) {
            throw new IllegalArgumentException("sequence number");
        }
        if (this.yQ > 0 && n2 >= this.yQ) {
            throw new RuntimeException("Cannot put data at " + n2 + " because the stream was closed at " + this.yQ);
        }
        if (n2 > this.last) {
            this.last = n2;
        }
        this.yR.put(n2, byteBuffer);
        this.notify();
    }

    @Override
    public synchronized int read() throws IOException {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer == null) {
            return -1;
        }
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.getByteBuffer();
            if (byteBuffer == null) {
                return n4 > 0 ? n4 : -1;
            }
            int n5 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.put(byArray, n2, n5);
            n2 += n5;
            n4 += n5;
            n3 -= n5;
        }
        return n4;
    }

    private synchronized ByteBuffer getByteBuffer() throws InterruptedIOException {
        if (this.cur != null && this.cur.hasRemaining()) {
            return this.cur;
        }
        if (this.cur != null && !this.cur.hasRemaining()) {
            this.cur = null;
        }
        while (this.cur == null) {
            if (this.next >= this.yQ && this.yQ > 0) {
                return null;
            }
            this.cur = this.yR.remove(this.next);
            if (this.cur == null) {
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            ++this.next;
            if (this.cur.hasRemaining()) continue;
            this.cur = null;
        }
        return this.cur;
    }
}

