/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class InputStreamReadable
implements IBinaryReadable {
    ByteOrder yF = ByteOrder.nativeOrder();
    InputStream is;
    long limit;
    long yP;

    public InputStreamReadable(InputStream inputStream, long l2) {
        this.is = inputStream;
        this.limit = l2;
    }

    @Override
    public byte get() throws IOException {
        return (byte)this.aQk();
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.get(byArray, 0, byArray.length);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = this.is.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            this.yP += (long)n4;
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)this.aQk());
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) throws IOException {
        if (n2 < 256) {
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.put((byte)this.aQk());
            }
        } else {
            byte[] byArray = new byte[n2];
            this.get(byArray, 0, n2);
            byteBuffer.put(byArray);
        }
    }

    @Override
    public double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public int getInt() throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            return this.aQk() << 24 | this.aQk() << 16 | this.aQk() << 8 | this.aQk();
        }
        return this.aQk() | this.aQk() << 8 | this.aQk() << 16 | this.aQk() << 24;
    }

    @Override
    public long getLong() throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            return (long)this.aQk() << 56 | (long)this.aQk() << 48 | (long)this.aQk() << 40 | (long)this.aQk() << 32 | (long)this.aQk() << 24 | (long)this.aQk() << 16 | (long)this.aQk() << 8 | (long)this.aQk();
        }
        return (long)this.aQk() | (long)this.aQk() << 8 | (long)this.aQk() << 16 | (long)this.aQk() << 24 | (long)this.aQk() << 32 | (long)this.aQk() << 40 | (long)this.aQk() << 48 | (long)this.aQk() << 56;
    }

    @Override
    public short getShort() throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            return (short)(this.aQk() << 8 | this.aQk());
        }
        return (short)(this.aQk() | this.aQk() << 8);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public ByteOrder order() {
        return this.yF;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.yF = byteOrder;
    }

    @Override
    public long position() {
        return this.yP;
    }

    public void skip(long l2) throws IOException {
        this.is.skip(l2);
    }

    int aQk() throws IOException {
        int n2 = this.is.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        ++this.yP;
        return n2 & 0xFF;
    }
}

