/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferFactory;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.LinkedList;

public class ByteQueue {
    private static final ByteBuffer yH = ByteBuffer.allocate(0);
    private static final ByteBuffer[] yI = new ByteBuffer[0];
    ByteBufferFactory yJ = ByteBufferFactory.LITTLE_ENDIAN_HEAP_BYTEBUFFER_FACTORY;
    int chunkSize = 4096;
    long yK;
    long yL;
    long yM = Long.MAX_VALUE;
    ByteOrder yF = ByteOrder.nativeOrder();
    LinkedList<ByteBuffer> list = new LinkedList();
    ByteBuffer yN;
    ByteBuffer yO;

    private static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n2) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer2.limit();
        byteBuffer.limit(byteBuffer.position() + n2);
        byteBuffer2.limit(byteBuffer2.position() + n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer.limit(n3);
        byteBuffer2.limit(n4);
    }

    private static void copyRemaining(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
        ByteQueue.copy(byteBuffer, byteBuffer2, n2);
    }

    public ByteQueue() {
    }

    public ByteQueue(int n2) {
        this.chunkSize = n2;
    }

    public void clear() {
        this.yL = 0L;
        this.yK = 0L;
        this.list.clear();
        this.yN = null;
        this.yO = null;
    }

    public void get(byte[] byArray) throws BufferUnderflowException {
        this.get(byArray, 0, byArray.length);
    }

    public void get(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if ((long)n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            if (byteBuffer == null) {
                throw new BufferUnderflowException();
            }
            int n4 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void get(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.get(byteBuffer, byteBuffer.remaining());
    }

    public void get(ByteBuffer byteBuffer, int n2) throws BufferUnderflowException {
        if (n2 > byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer2 = this.getReadChunk();
            int n3 = Math.min(byteBuffer2.remaining(), n2);
            ByteQueue.copy(byteBuffer2, byteBuffer, n3);
            n2 -= n3;
        }
    }

    public ByteBuffer get(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return yH;
        }
        int n3 = this.s(n2);
        if (n3 == 1) {
            ByteBuffer byteBuffer = this.getChunks(n2)[0];
            return byteBuffer;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(this.yF);
        this.get(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void getAvailable(ByteBuffer byteBuffer) {
        this.get(byteBuffer, Math.min(byteBuffer.remaining(), (int)this.remaining()));
    }

    public ByteBufferFactory getByteBufferFactory() {
        return this.yJ;
    }

    public long getBytesRead() {
        return this.yK + (long)(this.yO == null ? 0 : this.yO.position());
    }

    public long getBytesWritten() {
        return this.yL + (long)(this.yN == null ? 0 : this.yN.position());
    }

    public ByteBuffer[] getChunks(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return yI;
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.s(n2)];
        int n3 = 0;
        ByteBuffer byteBuffer = this.getReadChunk();
        while (byteBuffer != null && n2 > 0) {
            if (n2 < byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = this.yO.slice();
                byteBuffer2.order(this.yF);
                this.yO.position(this.yO.position() + n2);
                byteBuffer2.limit(n2);
                byteBufferArray[n3++] = byteBuffer2;
                n2 = 0;
            } else {
                this.yK += (long)(byteBuffer.remaining() + byteBuffer.position());
                n2 -= byteBuffer.remaining();
                this.yO = null;
                byteBufferArray[n3++] = byteBuffer.slice().order(this.yF);
            }
            byteBuffer = this.getReadChunk();
        }
        return byteBufferArray;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public ByteBuffer getReadChunk() {
        if (this.yO != null && !this.yO.hasRemaining()) {
            this.yK += (long)this.yO.position();
            this.yO = null;
        }
        if (this.yO != null) {
            return this.yO;
        }
        if (this.list.isEmpty()) {
            this.aQj();
        }
        if (!this.list.isEmpty()) {
            this.yO = this.list.removeFirst();
            this.yK -= (long)this.yO.position();
            return this.yO;
        }
        return null;
    }

    public int getWriteableBytesRemaining() {
        return (int)Math.min(Integer.MAX_VALUE, this.yM - this.getBytesWritten());
    }

    public ByteBuffer getWriteChunk() {
        if (this.yN != null && !this.yN.hasRemaining()) {
            this.aQj();
        }
        if (this.yN != null) {
            return this.yN;
        }
        int n2 = Math.min(this.getWriteableBytesRemaining(), this.chunkSize);
        if (n2 == 0) {
            throw new BufferOverflowException();
        }
        this.yN = this.yJ.allocate(n2);
        this.yN.order(this.yF);
        return this.yN;
    }

    public long getWriteLimit() {
        return this.yM;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public boolean isEmpty() {
        return this.remaining() == 0L;
    }

    public void offer(ByteBuffer byteBuffer) throws BufferOverflowException {
        if (this.getWriteableBytesRemaining() < byteBuffer.remaining()) {
            throw new BufferOverflowException();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        this.aQj();
        this.yL += (long)byteBuffer.remaining();
        this.list.addLast(byteBuffer);
    }

    public void omitAll() {
        if (this.yN != null) {
            this.yL += (long)this.yN.position();
        }
        this.yK = this.yL;
        this.list.clear();
        this.yN = null;
        this.yO = null;
    }

    public ByteOrder order() {
        return this.yF;
    }

    public void order(ByteOrder byteOrder) {
        this.yF = byteOrder;
    }

    public void peek(byte[] byArray) throws BufferUnderflowException {
        this.peek(byArray, 0, byArray.length);
    }

    public void peek(byte[] byArray, int n2, int n3) throws BufferUnderflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if ((long)n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (this.yO != null) {
            int n4 = Math.min(this.yO.remaining(), n3);
            this.yO.mark();
            this.yO.get(byArray, n2, n4);
            this.yO.reset();
            n2 += n4;
            if ((n3 -= n4) == 0) {
                return;
            }
        }
        if (!this.list.isEmpty()) {
            Iterator iterator = this.list.iterator();
            while (n3 > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                int n5 = Math.min(byteBuffer.remaining(), n3);
                byteBuffer.mark();
                byteBuffer.get(byArray, n2, n5);
                byteBuffer.reset();
                n2 += n5;
                n3 -= n5;
            }
        }
        if (this.yN != null) {
            ByteBuffer byteBuffer = (ByteBuffer)this.yN.duplicate().flip();
            byteBuffer.order(this.yF);
            int n6 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n6);
            n2 += n6;
            n3 -= n6;
        }
    }

    public void peek(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.peekAvailable(byteBuffer);
    }

    public ByteBuffer peek(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return yH;
        }
        ByteBuffer[] byteBufferArray = this.peekChunks(n2);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(this.yF);
        this.peek(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void peekAvailable(ByteBuffer byteBuffer) {
        Object object;
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.yO != null) {
            this.yO.mark();
            ByteQueue.copyRemaining(this.yO, byteBuffer);
            this.yO.reset();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (!this.list.isEmpty()) {
            object = this.list.iterator();
            while (byteBuffer.hasRemaining() && object.hasNext()) {
                ByteBuffer byteBuffer2 = (ByteBuffer)object.next();
                byteBuffer2.mark();
                ByteQueue.copyRemaining(byteBuffer2, byteBuffer);
                byteBuffer2.reset();
            }
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.yN != null) {
            object = (ByteBuffer)this.yN.duplicate().flip();
            ((ByteBuffer)object).order(this.yF);
            ByteQueue.copyRemaining((ByteBuffer)object, byteBuffer);
        }
    }

    public ByteBuffer[] peekChunks(int n2) throws BufferUnderflowException {
        Object object;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return yI;
        }
        int n3 = n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.s(n2)];
        int n4 = 0;
        if (this.yO != null) {
            object = this.yO.slice();
            ((ByteBuffer)object).order(this.yF);
            if (n3 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n3);
                n3 = 0;
            } else {
                n3 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n4++] = object;
        }
        if (!this.list.isEmpty() && n3 > 0) {
            object = this.list.iterator();
            while (n3 > 0 && object.hasNext()) {
                ByteBuffer byteBuffer = ((ByteBuffer)object.next()).slice();
                byteBuffer.order(this.yF);
                if (n3 < byteBuffer.remaining()) {
                    byteBuffer.limit(n3);
                    n3 = 0;
                } else {
                    n3 -= byteBuffer.remaining();
                }
                byteBufferArray[n4++] = byteBuffer;
            }
        }
        if (n3 > 0 && this.yN != null) {
            object = (ByteBuffer)this.yN.duplicate().flip();
            ((ByteBuffer)object).order(this.yF);
            if (n3 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n3);
                n3 = 0;
            } else {
                n3 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n4++] = object;
        }
        return byteBufferArray;
    }

    public void put(byte by) {
        this.getWriteChunk().put(by);
    }

    public void put(byte[] byArray) throws BufferOverflowException {
        this.put(byArray, 0, byArray.length);
    }

    public void put(byte[] byArray, int n2, int n3) throws BufferOverflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.getWriteChunk();
            int n4 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void put(ByteBuffer byteBuffer) {
        this.put(byteBuffer, byteBuffer.remaining());
    }

    public void put(ByteBuffer byteBuffer, int n2) {
        while (n2 > 0) {
            ByteBuffer byteBuffer2 = this.getWriteChunk();
            int n3 = Math.min(byteBuffer2.remaining(), n2);
            ByteQueue.copy(byteBuffer, byteBuffer2, n3);
            n2 -= n3;
        }
    }

    public long remaining() {
        return this.getBytesWritten() - this.getBytesRead();
    }

    public void setByteBufferFactory(ByteBufferFactory byteBufferFactory) {
        this.yJ = byteBufferFactory;
    }

    public void setChunkSize(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("chunk size < 1");
        }
        this.chunkSize = n2;
    }

    public void setWriteLimit(long l2) {
        this.yM = l2;
    }

    public void skip(int n2) throws BufferOverflowException {
        if ((long)n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            int n3 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.position(byteBuffer.position() + n3);
            n2 -= n3;
        }
    }

    public String toString() {
        return "ByteQueue (read=" + this.getBytesRead() + ", written=" + this.getBytesWritten() + ")";
    }

    private int s(int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return n3;
        }
        if (this.yO != null) {
            n2 -= Math.min(this.yO.remaining(), n2);
            ++n3;
        }
        if (n2 == 0) {
            return n3;
        }
        if (!this.list.isEmpty()) {
            Iterator iterator = this.list.iterator();
            while (n2 > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                n2 -= Math.min(byteBuffer.remaining(), n2);
                ++n3;
            }
        }
        if (n2 == 0) {
            return n3;
        }
        if (this.yN != null) {
            ++n3;
        }
        return n3;
    }

    private void aQj() {
        if (this.yN == null) {
            return;
        }
        if (this.yN.position() == 0) {
            return;
        }
        if (!this.yN.hasRemaining()) {
            this.yL += (long)this.yN.position();
            this.yN.flip();
            this.list.addLast(this.yN);
            this.yN = null;
            return;
        }
        this.yL += (long)this.yN.position();
        ByteBuffer byteBuffer = this.yN;
        this.yN = this.yN.slice();
        this.yN.order(this.yF);
        byteBuffer.flip();
        this.list.addLast(byteBuffer);
    }
}

