/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayWriteable2
implements IBinaryWriteable {
    ByteBuffer[] yE;
    int i = 0;
    ByteBuffer cur;
    ByteOrder yF;
    ChunkListener yG;

    public ByteBufferArrayWriteable2(ByteBuffer[] byteBufferArray, ChunkListener chunkListener) {
        if (byteBufferArray == null || chunkListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.yE = byteBufferArray;
        this.yG = chunkListener;
        this.cur = byteBufferArray[0];
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.yF;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.yF = byteOrder;
        this.cur.order(byteOrder);
    }

    @Override
    public void put(byte by) throws IOException {
        this.aQi();
        this.cur.put(by);
        this.aQh();
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.put(byArray, 0, byArray.length);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            this.aQi();
            int n4 = Math.min(n3, this.cur.remaining());
            this.cur.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
            this.aQh();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            this.aQi();
            ByteBufferUtils.copyRemaining(byteBuffer, this.cur);
            this.aQh();
        }
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) throws IOException {
        while (n2 > 0) {
            this.aQi();
            int n3 = Math.min(n2, Math.min(byteBuffer.remaining(), this.cur.remaining()));
            ByteBufferUtils.copy(byteBuffer, this.cur, n3);
            n2 -= n3;
            this.aQh();
        }
    }

    @Override
    public void putDouble(double d2) throws IOException {
        this.putLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void putFloat(float f2) throws IOException {
        this.putInt(Float.floatToIntBits(f2));
    }

    @Override
    public void putInt(int n2) throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            this.r(n2 >> 24);
            this.r(n2 >> 16);
            this.r(n2 >> 8);
            this.r(n2);
        } else {
            this.r(n2);
            this.r(n2 >> 8);
            this.r(n2 >> 16);
            this.r(n2 >> 24);
        }
    }

    @Override
    public void putLong(long l2) throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            this.r((int)(l2 >> 56));
            this.r((int)(l2 >> 48));
            this.r((int)(l2 >> 40));
            this.r((int)(l2 >> 32));
            this.r((int)(l2 >> 24));
            this.r((int)(l2 >> 16));
            this.r((int)(l2 >> 8));
            this.r((int)l2);
        } else {
            this.r((int)l2);
            this.r((int)(l2 >> 8));
            this.r((int)(l2 >> 16));
            this.r((int)(l2 >> 24));
            this.r((int)(l2 >> 32));
            this.r((int)(l2 >> 40));
            this.r((int)(l2 >> 48));
            this.r((int)(l2 >> 56));
        }
    }

    @Override
    public void putShort(short s2) throws IOException {
        if (this.yF == ByteOrder.BIG_ENDIAN) {
            this.r(s2 >> 8);
            this.r(s2);
        } else {
            this.r(s2);
            this.r(s2 >> 8);
        }
    }

    private void aQh() {
        if (!this.cur.hasRemaining()) {
            this.fireChunkComplete(this.i);
        }
    }

    private void aQi() {
        while (!this.cur.hasRemaining()) {
            ++this.i;
            if (this.i >= this.yE.length) {
                throw new BufferOverflowException();
            }
            this.cur = this.yE[this.i];
            this.cur.order(this.yF);
        }
    }

    protected void fireChunkComplete(int n2) {
        if (this.yG != null) {
            this.yG.onChunkComplete(this.yE, n2);
        }
    }

    void r(int n2) throws IOException {
        this.aQi();
        this.cur.put((byte)n2);
        this.aQh();
    }

    public static interface ChunkListener {
        public void onChunkComplete(ByteBuffer[] var1, int var2);
    }
}

