/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferArrayReadable
implements IBinaryReadable {
    final ByteQueue yC;

    public ByteBufferArrayReadable(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.yC = new ByteQueue();
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.yC.offer(byteBuffer);
        }
    }

    public ByteBufferArrayReadable(ByteQueue byteQueue) {
        if (byteQueue == null) {
            throw new IllegalArgumentException("null");
        }
        this.yC = byteQueue;
    }

    @Override
    public byte get() throws IOException {
        return this.yC.getReadChunk().get();
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.yC.get(byArray);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) throws IOException {
        this.yC.get(byArray, n2, n3);
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        this.yC.get(byteBuffer);
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) throws IOException {
        this.yC.get(byteBuffer, n2);
    }

    public ByteQueue getByteQueue() {
        return this.yC;
    }

    @Override
    public double getDouble() throws IOException {
        if (this.yC.getReadChunk().remaining() >= 8) {
            return this.yC.getReadChunk().getDouble();
        }
        return this.yC.get(8).getDouble();
    }

    @Override
    public float getFloat() throws IOException {
        if (this.yC.getReadChunk().remaining() >= 4) {
            return this.yC.getReadChunk().getFloat();
        }
        return this.yC.get(4).getFloat();
    }

    @Override
    public int getInt() throws IOException {
        if (this.yC.getReadChunk().remaining() >= 4) {
            return this.yC.getReadChunk().getInt();
        }
        return this.yC.get(4).getInt();
    }

    @Override
    public long getLong() throws IOException {
        if (this.yC.getReadChunk().remaining() >= 8) {
            return this.yC.getReadChunk().getLong();
        }
        return this.yC.get(8).getLong();
    }

    @Override
    public short getShort() throws IOException {
        if (this.yC.getReadChunk().remaining() >= 2) {
            return this.yC.getReadChunk().getShort();
        }
        return this.yC.get(2).getShort();
    }

    @Override
    public long limit() {
        return this.yC.getBytesWritten();
    }

    @Override
    public ByteOrder order() {
        return this.yC.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.yC.order(byteOrder);
    }

    @Override
    public long position() {
        return this.yC.getBytesRead();
    }
}

