/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.CurrentThreadExecutor;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSelector;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenableSocketChannel {
    static Logger logger = LoggerFactory.getLogger(ListenableSocketChannel.class);
    Executor executor;
    SocketChannel channel;
    volatile ConnectionListener yo;
    volatile ReadableListener yp;
    volatile WriteableListener yq;
    AsyncSelector yg;
    boolean closed = false;
    boolean yj = false;
    AtomicBoolean yr = new AtomicBoolean(false);
    AtomicBoolean ys = new AtomicBoolean(false);
    AtomicBoolean yt = new AtomicBoolean(false);
    AsyncSelector.SelectListener yu = new AsyncSelector.SelectListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSelected(AsyncSelector asyncSelector, SelectableChannel selectableChannel, int n2, int n3) {
            try {
                if ((n2 & 8) != 0 && !ListenableSocketChannel.this.yt.get()) {
                    ListenableSocketChannel.this.yt.set(true);
                    ListenableSocketChannel.this.executor.execute(ListenableSocketChannel.this.yv);
                }
                if ((n2 & 1) != 0 && !ListenableSocketChannel.this.yr.get()) {
                    ListenableSocketChannel.this.yr.set(true);
                    ListenableSocketChannel.this.executor.execute(ListenableSocketChannel.this.yw);
                }
                if ((n2 & 4) != 0 && !ListenableSocketChannel.this.ys.get()) {
                    ListenableSocketChannel.this.ys.set(true);
                    ListenableSocketChannel.this.executor.execute(ListenableSocketChannel.this.yx);
                }
            }
            finally {
                asyncSelector.interestOps(selectableChannel, ListenableSocketChannel.this.getInterestOps());
            }
        }
    };
    Runnable yv = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                ConnectionListener connectionListener = ListenableSocketChannel.this.getConnectListener();
                boolean bl = false;
                try {
                    try {
                        boolean bl2 = ListenableSocketChannel.this.channel.finishConnect();
                        if (bl2) {
                            if (connectionListener != null) {
                                connectionListener.onConnected(ListenableSocketChannel.this);
                            }
                            break block9;
                        }
                        bl = true;
                    }
                    catch (IOException iOException) {
                        if (connectionListener != null) {
                            connectionListener.onConnectFailed(ListenableSocketChannel.this, iOException);
                        }
                    }
                }
                finally {
                    ListenableSocketChannel.this.yt.set(false);
                    if (bl) {
                        ListenableSocketChannel.this.p(8);
                    }
                }
            }
        }
    };
    Runnable yw = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReadableListener readableListener = ListenableSocketChannel.this.getReadListener();
            try {
                if (readableListener != null) {
                    readableListener.onDataReadable(ListenableSocketChannel.this);
                }
            }
            finally {
                ListenableSocketChannel.this.yr.set(false);
                if (ListenableSocketChannel.this.executor != CurrentThreadExecutor.INSTANCE) {
                    ListenableSocketChannel.this.p(1);
                }
            }
        }
    };
    Runnable yx = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WriteableListener writeableListener = ListenableSocketChannel.this.getWriteListener();
            try {
                if (writeableListener != null) {
                    writeableListener.onDataWriteable(ListenableSocketChannel.this);
                }
            }
            finally {
                ListenableSocketChannel.this.ys.set(false);
                if (ListenableSocketChannel.this.executor != CurrentThreadExecutor.INSTANCE) {
                    ListenableSocketChannel.this.p(4);
                }
            }
        }
    };

    public ListenableSocketChannel(Executor executor) throws IOException {
        this((SocketChannel)SocketChannel.open().configureBlocking(false), executor);
    }

    public ListenableSocketChannel(SocketChannel socketChannel, Executor executor) throws IOException {
        this(socketChannel, executor, new AsyncSelector());
        this.yj = true;
    }

    public ListenableSocketChannel(SocketChannel socketChannel, Executor executor, AsyncSelector asyncSelector) throws IOException {
        logger.debug("ListenableSocketChannel: channel={}", (Object)socketChannel);
        if (socketChannel == null || executor == null) {
            throw new IllegalArgumentException();
        }
        if (socketChannel.isBlocking()) {
            throw new IllegalArgumentException("channel arg must be in non-blocking mode. (SocketChannel.configureBlocking(false))");
        }
        this.channel = socketChannel;
        this.executor = executor;
        this.yg = asyncSelector;
        this.yg.register(socketChannel, 0, this.yu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean bl = this.channel.isRegistered();
        boolean bl2 = this.channel.isOpen();
        logger.debug("close: channel.isRegistered()={}", (Object)bl);
        if (bl) {
            this.yg.unregister(this.channel);
        }
        logger.debug("close: channel.isOpen()={}", (Object)bl2);
        if (bl2) {
            try {
                this.channel.close();
                logger.debug("closed");
            }
            catch (IOException iOException) {
                logger.error("close", (Throwable)iOException);
            }
        }
        logger.debug("close: ownsSelector={}", (Object)this.yj);
        if (this.yj) {
            try {
                this.yg.close();
            }
            catch (IOException iOException) {
                logger.error("close: selector.close", (Throwable)iOException);
            }
        }
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.p(8);
        this.channel.connect(socketAddress);
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public ConnectionListener getConnectListener() {
        return this.yo;
    }

    public ReadableListener getReadListener() {
        return this.yp;
    }

    public AsyncSelector getSelectorThread() {
        return this.yg;
    }

    public WriteableListener getWriteListener() {
        return this.yq;
    }

    public void setConnectListener(ConnectionListener connectionListener) {
        this.yo = connectionListener;
        this.p(8);
    }

    public void setReadListener(ReadableListener readableListener) {
        this.yp = readableListener;
        this.p(1);
    }

    public void setWriteListener(WriteableListener writeableListener) {
        this.yq = writeableListener;
        this.p(4);
    }

    public boolean syncConnect(SocketAddress socketAddress, long l2) throws IOException {
        final Semaphore semaphore = new Semaphore(0);
        final IOException[] iOExceptionArray = new IOException[1];
        this.setConnectListener(new ConnectionListener(){

            @Override
            public void onConnected(ListenableSocketChannel listenableSocketChannel) {
                semaphore.release();
            }

            @Override
            public void onConnectFailed(ListenableSocketChannel listenableSocketChannel, IOException iOException) {
                iOExceptionArray[0] = iOException;
                semaphore.release();
            }
        });
        this.connect(socketAddress);
        try {
            if (!semaphore.tryAcquire(l2, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    void p(int n2) {
        try {
            int n3 = this.q(n2);
            this.yg.interestOps(this.channel, n3);
        }
        catch (CancelledKeyException cancelledKeyException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    int getInterestOps() {
        if (!this.channel.isOpen() || !this.channel.isRegistered()) {
            return 0;
        }
        int n2 = 0;
        if (this.yp != null && !this.yr.get() && this.channel.isConnected()) {
            n2 |= 1;
        }
        if (this.yq != null && !this.ys.get() && this.channel.isConnected()) {
            n2 |= 4;
        }
        if (this.yo != null && !this.yt.get() && !this.channel.isConnected()) {
            n2 |= 8;
        }
        return n2;
    }

    int q(int n2) {
        switch (n2) {
            case 1: {
                if (this.yp != null && !this.yr.get() && this.channel.isConnected()) {
                    return 1;
                }
                return -2;
            }
            case 4: {
                if (this.yq != null && !this.ys.get() && this.channel.isConnected()) {
                    return 4;
                }
                return -5;
            }
            case 8: {
                if (this.yo != null && !this.yt.get() && !this.channel.isConnected()) {
                    return 8;
                }
                return -9;
            }
        }
        return 0;
    }

    public static interface WriteableListener {
        public void onDataWriteable(ListenableSocketChannel var1);
    }

    public static interface ReadableListener {
        public void onDataReadable(ListenableSocketChannel var1);
    }

    public static interface ConnectionListener {
        public void onConnected(ListenableSocketChannel var1);

        public void onConnectFailed(ListenableSocketChannel var1, IOException var2);
    }
}

