/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiDimensionArrayUtils {
    public static Class<?> arrayClassOf(Class<?> clazz, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("This method doesn't accept negative dimensions");
        }
        if (n2 == 0) {
            return clazz;
        }
        return MultiDimensionArrayUtils.arrayClassOf(Array.newInstance(clazz, 0).getClass(), n2 - 1);
    }

    public static <R> ArrayIterator<R> arrayIterator(Object object, int[] nArray) {
        return new ArrayIterator(object, nArray);
    }

    public static boolean checkValueAgainstInstrumentRange(Variant variant, Range range, NodeId nodeId) {
        Class<?> clazz = variant.getValue().getClass();
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(variant.getValue());
        Class<?> clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
        Object object = MultiDimensionArrayUtils.muxArray(variant.getValue(), nArray, clazz2);
        Object[] objectArray = (Object[])object;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Double d2 = MultiDimensionArrayUtils.a(objectArray[i2], nodeId);
            if (d2 == null || !(d2 < range.getLow()) && !(d2 > range.getHigh())) continue;
            return false;
        }
        return true;
    }

    public static Object clone(Object object) {
        Class<?> clazz = MultiDimensionArrayUtils.getComponentType(object.getClass());
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, clazz);
        return MultiDimensionArrayUtils.demuxArray((Object)objectArray, nArray, clazz);
    }

    public static Object[] createMultiDimArray(Class<?> clazz, int[] nArray) {
        return (Object[])Array.newInstance(clazz, nArray);
    }

    public static Object deepClone(Object object) {
        Class<?> clazz = MultiDimensionArrayUtils.getComponentType(object.getClass());
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, clazz);
        try {
            Object[] objectArray2 = new Object[]{};
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object2 = objectArray[i2];
                try {
                    if (object2 == null) continue;
                    Method method = object2.getClass().getMethod("clone", new Class[0]);
                    method.setAccessible(true);
                    objectArray[i2] = method.invoke(object2, objectArray2);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        return MultiDimensionArrayUtils.demuxArray((Object)objectArray, nArray, clazz);
    }

    public static Object demuxArray(Object object, int[] nArray) {
        return MultiDimensionArrayUtils.demuxArray(object, nArray, MultiDimensionArrayUtils.getComponentType(object.getClass()));
    }

    public static Object demuxArray(Object object, int[] nArray, Class<?> clazz) {
        Object object2 = null;
        if (clazz != Byte.TYPE) {
            object2 = Array.newInstance(clazz, nArray);
        } else {
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = 1;
            object2 = Array.newInstance(clazz, nArray2);
        }
        MultiDimensionArrayUtils.a(0, nArray, object, 0, object2);
        return object2;
    }

    public static void demuxArray(Object object, int[] nArray, Object object2) {
        if (Array.getLength(object) != MultiDimensionArrayUtils.getLength(nArray)) {
            throw new IllegalArgumentException("The length of src does not match the length of dst");
        }
        MultiDimensionArrayUtils.a(0, nArray, object, 0, object2);
    }

    public static int[] getArrayLengths(Object object) {
        int n2 = MultiDimensionArrayUtils.getDimension(object);
        int[] nArray = new int[n2];
        if (n2 == 0) {
            return nArray;
        }
        Object object2 = object;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2] = object2 == null ? 0 : Array.getLength(object2);
            if (nArray[i2] == 0) break;
            object2 = Array.get(object2, 0);
        }
        return nArray;
    }

    public static int getClassDimensions(Class<?> clazz) {
        int n2;
        String string = clazz.getName();
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == '['; ++n2) {
        }
        return n2;
    }

    public static Class<?> getComponentType(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2;
    }

    public static int getDimension(Object object) {
        Class<?> clazz = object.getClass();
        return MultiDimensionArrayUtils.getClassDimensions(clazz);
    }

    public static int getLength(int[] nArray) {
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            n2 *= nArray[i2];
        }
        return n2;
    }

    public static Object muxArray(Object object) {
        return MultiDimensionArrayUtils.muxArray(object, MultiDimensionArrayUtils.getArrayLengths(object), MultiDimensionArrayUtils.getComponentType(object.getClass()));
    }

    public static Object muxArray(Object object, int[] nArray) {
        return MultiDimensionArrayUtils.muxArray(object, nArray, MultiDimensionArrayUtils.getComponentType(object.getClass()));
    }

    public static Object muxArray(Object object, int[] nArray, Class<?> clazz) {
        int n2 = MultiDimensionArrayUtils.getLength(nArray);
        Object object2 = Array.newInstance(clazz, n2);
        MultiDimensionArrayUtils.muxArray(object, nArray, object2);
        return object2;
    }

    public static void muxArray(Object object, int[] nArray, Object object2) {
        int n2 = MultiDimensionArrayUtils.getLength(nArray);
        if (Array.getLength(object2) != n2) {
            throw new IllegalArgumentException("The length of src does not match the length of dst");
        }
        MultiDimensionArrayUtils.a(0, nArray, object, object2, 0);
    }

    public static void printArrayDeep(Object object, PrintStream printStream) {
        ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(object, MultiDimensionArrayUtils.getArrayLengths(object));
        while (arrayIterator.hasNext()) {
            System.out.println(Arrays.toString(arrayIterator.getIndices()) + " = " + arrayIterator.next());
        }
    }

    public static String toString(Object object) {
        return MultiDimensionArrayUtils.toString(object, null);
    }

    public static String toString(Object object, EncoderContext encoderContext) {
        if (object == null) {
            return "" + null;
        }
        if (!object.getClass().isArray()) {
            if (encoderContext != null && object instanceof ExtensionObject) {
                try {
                    object = ((ExtensionObject)object).decode(encoderContext);
                }
                catch (DecodingException decodingException) {
                    // empty catch block
                }
            }
            return object.toString();
        }
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        if (nArray.length == 1) {
            if (encoderContext != null && object instanceof ExtensionObject[]) {
                try {
                    Object[] objectArray = (Object[])encoderContext.decode((ExtensionObject[])object);
                    return Arrays.toString(objectArray);
                }
                catch (DecodingException decodingException) {
                    // empty catch block
                }
            }
            if (object instanceof Object[]) {
                return Arrays.toString((Object[])object);
            }
            if (object instanceof double[]) {
                return Arrays.toString((double[])object);
            }
            if (object instanceof boolean[]) {
                return Arrays.toString((boolean[])object);
            }
            if (object instanceof byte[]) {
                return Arrays.toString((byte[])object);
            }
            if (object instanceof char[]) {
                return Arrays.toString((char[])object);
            }
            if (object instanceof float[]) {
                return Arrays.toString((float[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            if (object instanceof long[]) {
                return Arrays.toString((long[])object);
            }
            if (object instanceof short[]) {
                return Arrays.toString((short[])object);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            stringBuilder.append(MultiDimensionArrayUtils.toString(Array.get(object, i2), encoderContext));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static int a(int n2, int[] nArray, Object object, int n3, Object object2) {
        if (n2 == nArray.length - 1) {
            int n4 = nArray[nArray.length - 1];
            System.arraycopy(object, n3, object2, 0, n4);
            return n3 + n4;
        }
        for (int i2 = 0; i2 < nArray[n2]; ++i2) {
            n3 = MultiDimensionArrayUtils.a(n2 + 1, nArray, object, n3, Array.get(object2, i2));
        }
        return n3;
    }

    private static int a(int n2, int[] nArray, Object object, Object object2, int n3) {
        if (n2 == nArray.length - 1) {
            int n4 = nArray[n2];
            System.arraycopy(object, 0, object2, n3, n4);
            return n3 + n4;
        }
        for (int i2 = 0; i2 < nArray[n2]; ++i2) {
            n3 = MultiDimensionArrayUtils.a(n2 + 1, nArray, Array.get(object, i2), object2, n3);
        }
        return n3;
    }

    private static Double a(Object object, NodeId nodeId) {
        Double d2;
        if (nodeId == null) {
            d2 = null;
        } else if (nodeId.equals(Identifiers.Double)) {
            d2 = (Double)object;
        } else if (nodeId.equals(Identifiers.Byte)) {
            UnsignedByte unsignedByte = (UnsignedByte)object;
            d2 = unsignedByte.doubleValue();
        } else if (nodeId.equals(Identifiers.Float)) {
            Float f2 = (Float)object;
            d2 = f2.doubleValue();
        } else if (nodeId.equals(Identifiers.Int16)) {
            Short s2 = (Short)object;
            d2 = s2.doubleValue();
        } else if (nodeId.equals(Identifiers.Int32)) {
            Integer n2 = (Integer)object;
            d2 = n2.doubleValue();
        } else if (nodeId.equals(Identifiers.Int64)) {
            Long l2 = (Long)object;
            d2 = l2.doubleValue();
        } else if (nodeId.equals(Identifiers.SByte)) {
            Byte by = (Byte)object;
            d2 = by.doubleValue();
        } else if (nodeId.equals(Identifiers.UInt16)) {
            UnsignedShort unsignedShort = (UnsignedShort)object;
            d2 = unsignedShort.doubleValue();
        } else if (nodeId.equals(Identifiers.UInt32)) {
            UnsignedInteger unsignedInteger = (UnsignedInteger)object;
            d2 = unsignedInteger.doubleValue();
        } else if (nodeId.equals(Identifiers.UInt64)) {
            UnsignedLong unsignedLong = (UnsignedLong)object;
            d2 = unsignedLong.doubleValue();
        } else {
            d2 = null;
        }
        return d2;
    }

    public static class ArrayIterator<T>
    implements Iterator<T> {
        Object val;
        int[] wX;
        int[] indices;
        Object[] wY;
        int lastIndex;
        int len;
        boolean wZ = true;

        ArrayIterator(Object object, int[] nArray) {
            int n2;
            this.val = object;
            this.wX = nArray;
            this.indices = new int[nArray.length];
            this.wY = new Object[nArray.length];
            this.lastIndex = nArray.length - 1;
            for (n2 = 0; n2 <= this.lastIndex; ++n2) {
                if (nArray[n2] != 0) continue;
                this.wZ = false;
            }
            this.wY[0] = this.val;
            for (n2 = 1; n2 < nArray.length; ++n2) {
                this.wY[n2] = ((Object[])this.wY[n2 - 1])[0];
            }
        }

        public int[] getIndices() {
            return this.indices;
        }

        @Override
        public boolean hasNext() {
            return this.wZ;
        }

        @Override
        public T next() {
            if (!this.wZ) {
                throw new NoSuchElementException();
            }
            Object object = Array.get(Array.get(this.wY, this.lastIndex), this.indices[this.lastIndex]);
            this.aPZ();
            return (T)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove array element");
        }

        private void aPZ() {
            int n2 = this.lastIndex;
            while (true) {
                int n3 = n2;
                this.indices[n3] = this.indices[n3] + 1;
                if (this.indices[n3] < this.wX[n2]) break;
                this.indices[n2] = 0;
                if (--n2 < 0) {
                    this.wZ = false;
                    return;
                }
                this.wY[n2 + 1] = ((Object[])this.wY[n2])[this.indices[n2]];
            }
            if (n2 < this.lastIndex) {
                for (int i2 = n2 + 1; i2 <= this.lastIndex; ++i2) {
                    this.wY[i2] = ((Object[])this.wY[i2 - 1])[this.indices[i2 - 1]];
                }
            }
        }
    }
}

