/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class IncubationQueue<T> {
    Map<T, T> wU;
    LinkedList<T> wV = new LinkedList();

    public IncubationQueue() {
        this(false);
    }

    public IncubationQueue(boolean bl) {
        this.wU = bl ? new IdentityHashMap() : new HashMap();
    }

    public synchronized void clear() {
        this.wV.clear();
        this.wU.clear();
        this.notifyAll();
    }

    public synchronized boolean contains(T t) {
        return this.wU.containsKey(t);
    }

    public synchronized T getNext() throws InterruptedException {
        while (this.wV.isEmpty()) {
            this.wait();
        }
        return this.wV.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNextHatched() throws InterruptedException {
        while (true) {
            T t = this.getNext();
            this.waitUntilIncubated(t);
            IncubationQueue incubationQueue = this;
            synchronized (incubationQueue) {
                if (this.wV.getFirst() == t) {
                    return t;
                }
            }
        }
    }

    public synchronized T getNextHatchedIfAvailable() {
        if (this.wV.isEmpty()) {
            return null;
        }
        T t = this.wV.getFirst();
        if (this.wU.get(t) != null) {
            return null;
        }
        return t;
    }

    public synchronized boolean hatch(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (!this.wU.containsKey(t)) {
            throw new IllegalArgumentException(t + " is not incubating");
        }
        T t2 = this.wU.get(t);
        this.wU.put(t2, null);
        this.notifyAll();
        return t2 != null;
    }

    public synchronized void incubate(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.wU.containsKey(t)) {
            throw new IllegalArgumentException(t + " is already incubating");
        }
        this.wU.put(t, t);
        this.wV.addLast(t);
        this.notifyAll();
    }

    public synchronized boolean isEmpty() {
        return this.wU.isEmpty();
    }

    public synchronized boolean isHatched(T t) {
        if (!this.wU.containsKey(t)) {
            return false;
        }
        return this.wU.get(t) == null;
    }

    public synchronized boolean isIncubating(T t) {
        if (!this.wU.containsKey(t)) {
            return false;
        }
        return this.wU.get(t) != null;
    }

    public Iterator<T> iterator() {
        return this.wV.iterator();
    }

    public synchronized boolean nextIsHatched() {
        if (this.wV.isEmpty()) {
            return false;
        }
        T t = this.wV.getFirst();
        return this.wU.get(t) == null;
    }

    public synchronized T removeNextHatched() throws InterruptedException {
        T t = this.getNextHatched();
        this.wV.removeFirst();
        this.wU.remove(t);
        this.notifyAll();
        return t;
    }

    public synchronized T removeNextHatchedIfAvailable() {
        T t = this.getNextHatchedIfAvailable();
        if (t == null) {
            return null;
        }
        this.wV.removeFirst();
        this.wU.remove(t);
        this.notifyAll();
        return t;
    }

    public synchronized T removeNextHatchedUninterruptibly() {
        while (true) {
            try {
                return this.removeNextHatched();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized int size() {
        return this.wU.size();
    }

    public synchronized void waitUntilIncubated(T t) throws InterruptedException {
        while (this.isIncubating(t)) {
            this.wait();
        }
    }
}

