/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.endpoint.AbstractServerSecureChannel;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.nio.AbstractServerConnection;
import com.prosysopc.ua.stack.transport.tcp.nio.ChunksToMessage;
import com.prosysopc.ua.stack.transport.tcp.nio.InputMessage;
import com.prosysopc.ua.stack.transport.tcp.nio.MessageToChunks;
import com.prosysopc.ua.stack.transport.tcp.nio.MessageType;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServer;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerSecureChannel;
import com.prosysopc.ua.stack.transport.tcp.nio.PendingRequest;
import com.prosysopc.ua.stack.transport.tcp.nio.SecureInputMessageBuilder;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.IStatefulObject;
import com.prosysopc.ua.stack.utils.IncubationQueue;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.StateListener;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncInputStream;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocket;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocketImpl;
import com.prosysopc.ua.stack.utils.asyncsocket.BufferMonitorState;
import com.prosysopc.ua.stack.utils.asyncsocket.MonitorListener;
import com.prosysopc.ua.stack.utils.asyncsocket.SocketState;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable2;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServerConnection
extends AbstractServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(OpcTcpServerConnection.class);
    private static long vM = 600000L;
    int vt;
    Map<Integer, PendingRequest> ss = new ConcurrentHashMap<Integer, PendingRequest>();
    EndpointBinding vN;
    OpcTcpServer vO;
    AsyncSocket vP;
    ReverseHello vQ;
    Timer rs = TimerUtil.getTimer();
    TimerTask vR;
    Runnable vS = new Runnable(){

        @Override
        public void run() {
            OpcTcpServerConnection.this.setError(StatusCodes.Bad_Timeout);
        }
    };
    EncoderContext ru;
    EndpointConfiguration em;
    MonitorListener vT = new MonitorListener(){

        public void a(IStatefulObject<BufferMonitorState, ?> iStatefulObject, BufferMonitorState bufferMonitorState, BufferMonitorState bufferMonitorState2) {
            if (bufferMonitorState2.isUnreachable()) {
                if (OpcTcpServerConnection.this.vw != null) {
                    OpcTcpServerConnection.this.vw.close();
                    OpcTcpServerConnection.this.vw = null;
                }
                return;
            }
            if (bufferMonitorState2 != BufferMonitorState.Triggered) {
                logger.error("Unexpected trigger state {}", (Object)bufferMonitorState2);
                return;
            }
            AsyncInputStream asyncInputStream = OpcTcpServerConnection.this.vP.getInputStream();
            ByteBuffer byteBuffer = asyncInputStream.peek(8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            if (n2 < 12) {
                OpcTcpServerConnection.this.setError(StatusCodes.Bad_TcpInternalError);
                if (OpcTcpServerConnection.this.vw != null) {
                    OpcTcpServerConnection.this.vw.close();
                }
                return;
            }
            if (n2 > OpcTcpServerConnection.this.vv.maxRecvChunkSize) {
                OpcTcpServerConnection.this.setError(new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge, "Chunk size (" + n2 + ") exceeded maximum (" + OpcTcpServerConnection.this.vv.maxRecvChunkSize + ")"));
                if (OpcTcpServerConnection.this.vw != null) {
                    OpcTcpServerConnection.this.vw.close();
                }
                return;
            }
            if (asyncInputStream.available() >= n2) {
                ByteBuffer byteBuffer2 = asyncInputStream.read(n2);
                byteBuffer2.rewind();
                try {
                    try {
                        OpcTcpServerConnection.this.handleChunk(byteBuffer2);
                    }
                    catch (RuntimeException runtimeException) {
                        logger.warn("Error in handleChunk", (Throwable)runtimeException);
                        throw StackUtils.toServiceResultException(runtimeException);
                    }
                }
                catch (ServiceResultException serviceResultException) {
                    logger.info("Error in handleChunk", (Throwable)serviceResultException);
                    OpcTcpServerConnection.this.setError(serviceResultException);
                }
                asyncInputStream.createMonitor(asyncInputStream.getPosition() + 8L, this);
            } else {
                asyncInputStream.createMonitor(asyncInputStream.getPosition() + (long)n2, this);
            }
        }

        @Override
        public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
            this.a(iStatefulObject, (BufferMonitorState)((Object)object), (BufferMonitorState)((Object)object2));
        }
    };
    SecureInputMessageBuilder.MessageListener vU = new SecureInputMessageBuilder.MessageListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageComplete(InputMessage inputMessage) {
            IEncodeable iEncodeable = inputMessage.getMessage();
            for (Object object : OpcTcpServerConnection.this.vy) {
                if (!object.handleMessage(inputMessage)) continue;
                return;
            }
            if (iEncodeable == null) {
                3 var3_3 = this;
                synchronized (var3_3) {
                    Object object;
                    object = inputMessage.getError();
                    if (object == null) {
                        return;
                    }
                    OpcTcpServerConnection.this.setError(StackUtils.toServiceResultException((Exception)object));
                    return;
                }
            }
            try {
                if (inputMessage.getMessageType() == 4674381) {
                    OpcTcpServerConnection.this.handleSecureMessage(inputMessage);
                } else if (inputMessage.getMessageType() == 5196867) {
                    OpcTcpServerConnection.this.handleCloseSecureChannelRequest(inputMessage);
                } else if (inputMessage.getMessageType() == 5132367) {
                    OpcTcpServerConnection.this.handleOpenSecureChannelRequest(inputMessage);
                }
            }
            catch (ServiceResultException serviceResultException) {
                OpcTcpServerConnection.this.setError(serviceResultException);
            }
        }
    };

    public static long getHandshakeTimeout() {
        return vM;
    }

    public static void setHandshakeTimeout(long l2) {
        vM = l2;
    }

    OpcTcpServerConnection(OpcTcpServer opcTcpServer, AsyncSocketImpl asyncSocketImpl) {
        this(opcTcpServer, asyncSocketImpl, null);
    }

    OpcTcpServerConnection(OpcTcpServer opcTcpServer, AsyncSocketImpl asyncSocketImpl, final ReverseHello reverseHello) {
        this.vO = opcTcpServer;
        this.vP = asyncSocketImpl;
        this.vQ = reverseHello;
        this.ru = opcTcpServer.getEncoderContext();
        this.vu = new StateListener<SocketState>(){

            public void a(IStatefulObject<SocketState, ?> iStatefulObject, SocketState socketState, SocketState socketState2) {
                if (socketState2 == SocketState.Error) {
                    OpcTcpServerConnection.this.setError(StackUtils.toServiceResultException(OpcTcpServerConnection.this.vP.getStateMonitor().getError()));
                }
                if (socketState2 == SocketState.Closed) {
                    OpcTcpServerConnection.this.close();
                }
            }

            @Override
            public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
                this.a(iStatefulObject, (SocketState)((Object)object), (SocketState)((Object)object2));
            }
        };
        this.setState(CloseableObjectState.Opening);
        asyncSocketImpl.getStateMonitor().addStateListener(this.vu);
        asyncSocketImpl.getInputStream().createMonitor(8L, this.vT);
        if (reverseHello == null) {
            this.vR = TimerUtil.schedule(this.rs, this.vS, StackUtils.getBlockingWorkExecutor(), System.currentTimeMillis() + vM);
        }
        if (reverseHello != null) {
            asyncSocketImpl.getStateMonitor().addStateListener(new StateListener<SocketState>(){

                public void a(IStatefulObject<SocketState, ?> iStatefulObject, SocketState socketState, SocketState socketState2) {
                    if (socketState == SocketState.Connecting && socketState2 == SocketState.Connected) {
                        OpcTcpServerConnection.this.vR = TimerUtil.schedule(OpcTcpServerConnection.this.rs, OpcTcpServerConnection.this.vS, StackUtils.getBlockingWorkExecutor(), System.currentTimeMillis() + vM);
                        OpcTcpServerConnection.this.sendReverseHello(reverseHello);
                    }
                }

                @Override
                public /* synthetic */ void onStateTransition(IStatefulObject iStatefulObject, Object object, Object object2) {
                    this.a(iStatefulObject, (SocketState)((Object)object), (SocketState)((Object)object2));
                }
            });
        }
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        logger.debug("addConnectionListener: listener={}", (Object)iConnectionListener);
        super.addConnectionListener(iConnectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        try {
            this.setState(CloseableObjectState.Closing);
        }
        finally {
            try {
                this.vP.close();
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    public SocketAddress getLocalAddress() {
        Socket socket = this.vP.socket();
        if (socket == null) {
            return null;
        }
        return socket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        Socket socket = this.vP.socket();
        if (socket == null) {
            return null;
        }
        return socket.getRemoteSocketAddress();
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        logger.debug("removeConnectionListener: listener={}", (Object)iConnectionListener);
        super.removeConnectionListener(iConnectionListener);
        this.cancelTimeoutTimer();
    }

    private String p(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected void cancelTimeoutTimer() {
        if (this.vR != null) {
            this.vR.cancel();
            this.vR = null;
            this.vS = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endChunkSend(ByteBuffer byteBuffer) {
        this.vx.hatch(byteBuffer);
        OpcTcpServerConnection opcTcpServerConnection = this;
        synchronized (opcTcpServerConnection) {
            while (this.vx.nextIsHatched()) {
                ByteBuffer byteBuffer2 = (ByteBuffer)this.vx.removeNextHatchedIfAvailable();
                byteBuffer2.rewind();
                this.vP.getOutputStream().offer(byteBuffer2);
            }
        }
    }

    protected BufferMonitorState flush(long l2) throws InterruptedException, IOException {
        return this.vP.getOutputStream().createMonitor(l2, null).waitForState(BufferMonitorState.FINAL_STATES);
    }

    @Override
    protected CertificateValidator getRemoteCertificateValidator() {
        return this.vN == null ? null : this.vN.serviceServer.getApplication().getOpctcpSettings().getCertificateValidator();
    }

    protected void handleAcknowledgeMessage(Acknowledge acknowledge) throws ServiceResultException {
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
    }

    protected void handleAsymmChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        byteBuffer.rewind();
        if (this.vw != null && !this.vw.moreChunksRequired()) {
            this.vw = null;
        }
        if (this.vw == null) {
            Object object;
            Cert cert;
            int n2 = ChunkUtils.getSecureChannelId(byteBuffer);
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.so.get(n2);
            String string = ChunkUtils.getString(byteBuffer);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(string);
            if (securityPolicy == null) {
                logger.warn("Security policy \"{}\" is not supported by the stack", (Object)string);
                throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, "Security policy \"" + string + "\" is not supported by the stack");
            }
            byte[] byArray = ChunkUtils.getByteString(byteBuffer);
            byte[] byArray2 = ChunkUtils.getByteString(byteBuffer);
            logger.debug("secureChannelId={}", (Object)n2);
            logger.debug("secureChannel={}", (Object)opcTcpServerSecureChannel);
            logger.debug("securityPolicyUri={}", (Object)string);
            logger.debug("securityPolicy={}", (Object)securityPolicy);
            logger.debug("encodedRemoteCertificate={}", (Object)byArray);
            logger.debug("encodedLocalCertificateThumbprint={}", (Object)byArray2);
            KeyPair keyPair = this.vN.serviceServer.getApplication().getApplicationInstanceCertificate(byArray2);
            if (keyPair == null && securityPolicy != SecurityPolicy.NONE) {
                logger.warn("Requested Application Instance Certificate is not found in the server");
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Requested Application Instance Certificate is not found in the server");
            }
            try {
                cert = byArray == null ? null : new Cert(CertificateUtils.decodeX509Certificate(byArray));
            }
            catch (CertificateException certificateException) {
                throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed);
            }
            CertificateValidator certificateValidator = this.getRemoteCertificateValidator();
            if (certificateValidator != null && (object = certificateValidator.validateCertificate(cert)) != null && !((StatusCode)object).isGood()) {
                logger.warn("Remote certificate not accepted: {}", (Object)((StatusCode)object).toString());
                if (((StatusCode)object).isStatusCode(StatusCodes.Bad_CertificateChainIncomplete) || ((StatusCode)object).isStatusCode(StatusCodes.Bad_CertificateRevoked)) {
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed);
                }
                throw new ServiceResultException((StatusCode)object);
            }
            object = securityPolicy == SecurityPolicy.NONE ? MessageSecurityMode.None : MessageSecurityMode.SignAndEncrypt;
            SecurityMode securityMode = new SecurityMode(securityPolicy, (MessageSecurityMode)object);
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, cert);
            AtomicInteger atomicInteger = opcTcpServerSecureChannel == null ? null : opcTcpServerSecureChannel.recvSequenceNumber;
            this.vw = new SecureInputMessageBuilder(this.securityConfiguration, this.vU, this.vv, this.ru, atomicInteger);
        }
        logger.debug("onAsymmSecureChunk: {}", (Object)byteBuffer);
        this.vw.addChunk(byteBuffer);
    }

    protected void handleChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        int n2 = ChunkUtils.getMessageType(byteBuffer);
        int n3 = n2 & 0xFFFFFF;
        if (n3 == 4674381) {
            this.handleSymmChunk(byteBuffer);
        } else if (n3 == 5196867) {
            this.handleCloseChunk(byteBuffer);
        } else if (n3 == 5132367) {
            this.handleAsymmChunk(byteBuffer);
        } else if (n3 == 4998472 || n3 == 4932417 || n3 == 0x525245) {
            this.handleRawChunk(byteBuffer);
        } else {
            this.close();
        }
    }

    protected void handleCloseChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        this.close();
    }

    protected void handleCloseSecureChannelRequest(InputMessage inputMessage) throws ServiceResultException {
        logger.debug("onCloseChannel");
        IEncodeable iEncodeable = inputMessage.getMessage();
        if (!(iEncodeable instanceof CloseSecureChannelRequest)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        CloseSecureChannelRequest closeSecureChannelRequest = (CloseSecureChannelRequest)iEncodeable;
        int n2 = inputMessage.getSecureChannelId();
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.so.get(n2);
        if (opcTcpServerSecureChannel == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        opcTcpServerSecureChannel.handleCloseSecureChannelRequest(inputMessage, closeSecureChannelRequest);
    }

    protected void handleErrorMessage(ErrorMessage errorMessage) {
        logger.debug("onError: {}", (Object)errorMessage);
        this.setError(errorMessage.getError());
    }

    protected void handleHelloMessage(Hello hello) throws ServiceResultException {
        List<EndpointBinding> list;
        this.cancelTimeoutTimer();
        EndpointBindingCollection endpointBindingCollection = this.vO.getEndpointBindings();
        if (endpointBindingCollection == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        String string = this.p(hello.getEndpointUrl());
        logger.debug("onHello: url={}", (Object)string);
        if (string == null || string.equals("")) {
            this.vN = this.vO.discoveryEndpointBinding;
        } else {
            list = endpointBindingCollection.get(string);
            if (list.isEmpty()) {
                this.vN = endpointBindingCollection.getDefault(string);
                if (this.vN == null) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                }
            } else {
                this.vN = list.get(0);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" endpoints={}", (Object)Arrays.toString(endpointBindingCollection.getEndpointAddresses().toArray(new Endpoint[0])));
            logger.debug(" endpoint=" + (this.vN == null ? "binding is null" : this.vN.endpointAddress));
        }
        if (this.getState() != CloseableObjectState.Opening) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        list = new Acknowledge();
        if (hello.getSendBufferSize().longValue() < 8192L) {
            this.setError(new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Peer send buffer size <  8192"));
        }
        if (hello.getReceiveBufferSize().longValue() < 8192L) {
            this.setError(new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Peer recv buffer size <  8192"));
        }
        if (this.getError() != null) {
            logger.warn("onHello: " + this.getError());
        }
        this.vt = Math.min(0, hello.getProtocolVersion().intValue());
        ((Acknowledge)((Object)list)).setProtocolVersion(UnsignedInteger.getFromBits(this.vt));
        if (hello.getMaxMessageSize() != null && hello.getMaxMessageSize().intValue() != 0) {
            this.vv.maxSendMessageSize = this.vv.maxSendMessageSize == 0 ? hello.getMaxMessageSize().intValue() : Math.min(this.vv.maxSendMessageSize, hello.getMaxMessageSize().intValue());
        }
        if (this.vN != null) {
            int n2 = this.vN.endpointAddress.getEndpointConfiguration().getMaxMessageSize();
            this.vv.maxSendMessageSize = this.vv.maxSendMessageSize == 0 ? n2 : Math.min(this.vv.maxSendMessageSize, n2);
            this.vv.maxRecvMessageSize = this.vv.maxRecvMessageSize == 0 ? n2 : Math.min(this.vv.maxRecvMessageSize, n2);
            this.ru.maxMessageSize = n2;
        } else {
            this.ru.maxMessageSize = this.vv.maxSendMessageSize;
        }
        if (hello.getMaxChunkCount().intValue() != 0) {
            this.vv.maxSendChunkCount = Math.min(this.vv.maxSendChunkCount, hello.getMaxChunkCount().intValue());
        }
        ((Acknowledge)((Object)list)).setMaxChunkCount(UnsignedInteger.getFromBits(this.vv.maxRecvChunkCount));
        this.vv.maxSendChunkSize = Math.min(hello.getReceiveBufferSize().intValue(), this.vv.maxSendChunkSize);
        this.vv.maxRecvChunkSize = Math.min(hello.getSendBufferSize().intValue(), this.vv.maxRecvChunkSize);
        ((Acknowledge)((Object)list)).setSendBufferSize(UnsignedInteger.getFromBits(this.vv.maxSendChunkSize));
        ((Acknowledge)((Object)list)).setReceiveBufferSize(UnsignedInteger.getFromBits(this.vv.maxRecvChunkSize));
        this.vv.maxRecvChunkSize = Math.min(this.vv.maxRecvChunkSize, hello.getReceiveBufferSize().intValue());
        this.vv.maxSendChunkSize = Math.min(this.vv.maxSendChunkSize, hello.getSendBufferSize().intValue());
        this.setState(CloseableObjectState.Opening);
        this.vv.endpointUrl = hello.getEndpointUrl();
        this.sendAcknowledge((Acknowledge)((Object)list));
        this.setState(CloseableObjectState.Open);
    }

    protected void handleOpenSecureChannelRequest(InputMessage inputMessage) throws ServiceResultException {
        Object object;
        IEncodeable iEncodeable = inputMessage.getMessage();
        if (iEncodeable == null) {
            OpcTcpServerConnection opcTcpServerConnection = this;
            synchronized (opcTcpServerConnection) {
                Exception exception = inputMessage.getError();
                logger.warn("InputMessage has error", (Throwable)exception);
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)exception);
            }
        }
        if (!(iEncodeable instanceof OpenSecureChannelRequest)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)iEncodeable;
        if (openSecureChannelRequest.getRequestType() == SecurityTokenRequestType.Issue) {
            object = new OpcTcpServerSecureChannel(this, this.vO.rK.incrementAndGet());
            logger.debug("handleOpenSecureChannelRequest: endpointServer={} SecureChannelId={}", (Object)this.vO, (Object)((AbstractServerSecureChannel)object).getSecureChannelId());
            ((OpcTcpServerSecureChannel)object).handleOpenChannel(inputMessage, openSecureChannelRequest);
        } else if (openSecureChannelRequest.getRequestType() == SecurityTokenRequestType.Renew) {
            object = (OpcTcpServerSecureChannel)this.so.get(inputMessage.getSecureChannelId());
            if (object == null) {
                throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
            }
            if (!ObjectUtils.objectEquals(openSecureChannelRequest.getRequestType(), SecurityTokenRequestType.Renew)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            ((OpcTcpServerSecureChannel)object).handleRenewSecureChannelRequest(inputMessage, openSecureChannelRequest);
        }
        object = this.so.values().toArray();
        for (Object object2 : object) {
            if (!((CloseableObjectState)((Object)((AbstractServerSecureChannel)object2).getState())).equals((Object)CloseableObjectState.Closed)) continue;
            this.so.remove(((AbstractServerSecureChannel)object2).getSecureChannelId());
        }
    }

    protected void handleRawChunk(ByteBuffer byteBuffer) {
        int n2 = ChunkUtils.getMessageType(byteBuffer);
        int n3 = n2 & 0xFFFFFF;
        int n4 = n2 & 0xFF000000;
        if (n4 != 0x46000000) {
            this.close();
        }
        byteBuffer.position(8);
        try {
            if (n3 == 4998472) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.vv, this.ru, Hello.class, byteBuffer);
                this.handleHelloMessage((Hello)chunksToMessage.call());
            } else if (n3 == 4932417) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.vv, this.ru, Acknowledge.class, byteBuffer);
                this.handleAcknowledgeMessage((Acknowledge)chunksToMessage.call());
            } else if (n3 == 0x525245) {
                ChunksToMessage chunksToMessage = new ChunksToMessage(this.vv, this.ru, ErrorMessage.class, byteBuffer);
                this.handleErrorMessage((ErrorMessage)chunksToMessage.call());
            }
        }
        catch (Exception exception) {
            this.setError(StackUtils.toServiceResultException(exception));
        }
    }

    protected void handleSecureMessage(InputMessage inputMessage) throws ServiceResultException {
        OpcTcpServerSecureChannel opcTcpServerSecureChannel;
        IEncodeable iEncodeable = inputMessage.getMessage();
        int n2 = inputMessage.getSecureChannelId();
        if (logger.isDebugEnabled()) {
            logger.debug("handleSecureMessage: secureChannelId=" + n2 + "msg=" + (iEncodeable == null ? "null" : iEncodeable.getClass().getSimpleName()));
        }
        if ((opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.so.get(n2)) == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        if (iEncodeable instanceof OpenSecureChannelRequest) {
            OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)iEncodeable;
            if (!ObjectUtils.objectEquals(openSecureChannelRequest.getRequestType(), SecurityTokenRequestType.Renew)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            opcTcpServerSecureChannel.handleRenewSecureChannelRequest(inputMessage, openSecureChannelRequest);
        } else if (iEncodeable instanceof CloseSecureChannelRequest) {
            opcTcpServerSecureChannel.handleCloseSecureChannelRequest(inputMessage, (CloseSecureChannelRequest)iEncodeable);
        } else {
            opcTcpServerSecureChannel.handleSecureMessage(inputMessage, iEncodeable);
        }
    }

    protected void handleSymmChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        int n2 = ChunkUtils.getSecureChannelId(byteBuffer);
        int n3 = ChunkUtils.getTokenId(byteBuffer);
        byteBuffer.rewind();
        OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)this.so.get(n2);
        if (opcTcpServerSecureChannel == null) {
            throw new ServiceResultException(StatusCodes.Bad_TcpSecureChannelUnknown);
        }
        if (((CloseableObjectState)((Object)opcTcpServerSecureChannel.getState())).equals((Object)CloseableObjectState.Closed)) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelIdInvalid);
        }
        SecurityToken securityToken = opcTcpServerSecureChannel.getSecurityToken(n3);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelTokenUnknown);
        }
        if (!securityToken.isValid()) {
            securityToken = opcTcpServerSecureChannel.getLatestNonExpiredToken();
        }
        if (securityToken == null || !securityToken.isValid()) {
            System.err.println("Token expired");
            throw new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
        }
        SecurityToken securityToken2 = opcTcpServerSecureChannel.getActiveSecurityToken();
        if (securityToken != securityToken2) {
            logger.debug("handleSymmChunk: activeToken={}, token={}", (Object)securityToken2, (Object)securityToken);
            if (securityToken2.getCreationTime() < securityToken.getCreationTime()) {
                opcTcpServerSecureChannel.setActiveSecurityToken(securityToken);
            }
        }
        logger.debug("handleSymmChunk: {}", (Object)this.vw);
        if (this.vw != null && !this.vw.moreChunksRequired()) {
            this.vw = null;
        }
        if (this.vw == null) {
            this.vw = new SecureInputMessageBuilder(securityToken, this.vU, this.vv, this.ru, opcTcpServerSecureChannel.recvSequenceNumber);
            logger.debug("handleSymmChunk: secureMessageBuilder={}", (Object)this.vw);
        }
        this.vw.addChunk(byteBuffer);
    }

    @Override
    protected synchronized void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        logger.debug("onStateTransition: {}->{}", (Object)closeableObjectState, (Object)closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Closing) {
            ServiceResultException serviceResultException = (ServiceResultException)this.getError();
            ArrayList<ServerSecureChannel> arrayList = new ArrayList<ServerSecureChannel>();
            this.getSecureChannels(arrayList);
            for (ServerSecureChannel serverSecureChannel : arrayList) {
                OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)serverSecureChannel;
                if (opcTcpServerSecureChannel != null && serviceResultException != null) {
                    opcTcpServerSecureChannel.setError(serviceResultException);
                }
                serverSecureChannel.close();
            }
        }
    }

    protected void sendAcknowledge(Acknowledge acknowledge) throws ServiceResultException {
        ChunkFactory.AcknowledgeChunkFactory acknowledgeChunkFactory = new ChunkFactory.AcknowledgeChunkFactory();
        MessageToChunks messageToChunks = new MessageToChunks(acknowledge, this.vv, this.ru, acknowledgeChunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = acknowledgeChunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1179337537);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int sendAsymmSecureMessage(AsyncWrite asyncWrite, SecurityConfiguration securityConfiguration, int n2, int n3, AtomicInteger atomicInteger) throws ServiceResultException {
        Object object = asyncWrite;
        synchronized (object) {
            if (asyncWrite.isCanceled()) {
                return -1;
            }
            asyncWrite.setQueued();
        }
        object = new ChunkFactory.AsymmMsgChunkFactory(this.vv.maxSendChunkSize, securityConfiguration);
        MessageToChunks messageToChunks = new MessageToChunks(asyncWrite.getMessage(), this.vv, this.ru, (ChunkFactory)object, MessageType.Message);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = ((ChunkFactory)object).expandToCompleteChunk(byteBufferArray);
        Object object2 = asyncWrite;
        synchronized (object2) {
            if (asyncWrite.isCanceled()) {
                return -1;
            }
            asyncWrite.setWriting();
        }
        object2 = securityConfiguration.getSecurityPolicy();
        this.startChunkSend(byteBufferArray2);
        for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
            ByteBuffer byteBuffer = byteBufferArray2[i2];
            ByteBuffer byteBuffer2 = byteBufferArray[i2];
            boolean bl = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
            byteBuffer.rewind();
            byteBuffer.putInt(0x4E504F | (bl ? 0x46000000 : 0x43000000));
            byteBuffer.position(8);
            byteBuffer.putInt(n2);
            byte[] byArray = ((SecurityPolicy)((Object)object2)).getEncodedPolicyUri();
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
            byArray = securityConfiguration.getEncodedLocalCertificate();
            byteBuffer.putInt(byArray == null ? -1 : byArray.length);
            if (byArray != null) {
                byteBuffer.put(byArray);
            }
            byteBuffer.putInt((byArray = securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
            if (byArray != null) {
                byteBuffer.put(byArray);
            }
            byteBuffer.putInt(atomicInteger.getAndIncrement());
            byteBuffer.putInt(n3);
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, securityConfiguration).run();
            byteBuffer.rewind();
            this.endChunkSend(byteBuffer);
        }
        asyncWrite.setWritten();
        return byteBufferArray2.length;
    }

    protected synchronized void sendChunks(ByteBuffer ... byteBufferArray) {
        this.startChunkSend(byteBufferArray);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            this.endChunkSend(byteBuffer);
        }
    }

    protected void sendError(ErrorMessage errorMessage) throws ServiceResultException {
        ChunkFactory.ErrorMessageChunkFactory errorMessageChunkFactory = new ChunkFactory.ErrorMessageChunkFactory();
        MessageToChunks messageToChunks = new MessageToChunks(errorMessage, this.vv, this.ru, errorMessageChunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = errorMessageChunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1179800133);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    protected void sendHello(Hello hello) {
        this.vv.endpointUrl = hello.getEndpointUrl();
        ChunkFactory chunkFactory = new ChunkFactory(this.vv.maxSendChunkSize, 8, 0, 0, 0, 1, MessageSecurityMode.None, 0);
        MessageToChunks messageToChunks = new MessageToChunks(hello, this.vv, this.ru, chunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = chunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1179403592);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
    }

    protected void sendReverseHello(ReverseHello reverseHello) {
        ChunkFactory chunkFactory = new ChunkFactory(this.vv.maxSendChunkSize, 8, 0, 0, 0, 1, MessageSecurityMode.None, 0);
        MessageToChunks messageToChunks = new MessageToChunks(reverseHello, this.vv, this.ru, chunkFactory, MessageType.Encodeable);
        ByteBuffer[] byteBufferArray = messageToChunks.call();
        ByteBuffer[] byteBufferArray2 = chunkFactory.expandToCompleteChunk(byteBufferArray);
        byteBufferArray2[0].putInt(1178945618);
        byteBufferArray2[0].rewind();
        this.sendChunks(byteBufferArray2);
        logger.debug("Sent ReverseHello: {}", (Object)reverseHello);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendSecureMessage(final AsyncWrite asyncWrite, final SecurityToken securityToken, int n2, int n3, AtomicInteger atomicInteger) {
        ByteBuffer[] byteBufferArray;
        ByteBuffer[] byteBufferArray2;
        boolean bl;
        int n4;
        int n5;
        ByteBuffer[] byteBufferArray3;
        ByteBuffer[] byteBufferArray4;
        try {
            byteBufferArray4 = asyncWrite;
            synchronized (byteBufferArray4) {
                if (asyncWrite.isCanceled()) {
                    return;
                }
                asyncWrite.setQueued();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("sendSecureMessage: " + ObjectUtils.printFieldsDeep(asyncWrite.getMessage()));
            }
            byteBufferArray4 = new SizeCalculationOutputStream();
            byteBufferArray3 = new BinaryEncoder((OutputStream)byteBufferArray4);
            byteBufferArray3.setEncoderContext(this.ru);
            byteBufferArray3.putMessage(asyncWrite.getMessage());
            n5 = byteBufferArray4.getLength();
            if (n5 > this.vv.maxSendMessageSize && this.vv.maxSendMessageSize != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            SecurityPolicy securityPolicy = securityToken.getSecurityPolicy();
            MessageSecurityMode messageSecurityMode = securityToken.getMessageSecurityMode();
            SecurityAlgorithm object = securityPolicy.getSymmetricEncryptionAlgorithm();
            SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricSignatureAlgorithm();
            int n6 = CryptoUtil.getCipherBlockSize(object, null);
            int n7 = CryptoUtil.getSignatureSize(securityAlgorithm, null);
            int n8 = n4 = messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? securityToken.getRemoteEncryptingKey().length : 0;
            int n9 = messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? (n4 > 2048 ? 2 : 1) : 0;
            int n10 = this.vv.maxSendChunkSize - 24 - n9 - n7;
            n10 -= (n10 + n9 + n7 + 8) % n6;
            int n11 = StackUtils.cores();
            int n12 = (n5 + n11 - 1) / n11;
            if (n12 > n10) {
                n12 = n10;
            }
            if (n12 < 4096) {
                n12 = 4096;
            }
            int n13 = n12 + 24 + n9 + n7;
            ChunkFactory chunkFactory = new ChunkFactory(n13, 8, 8, 8, n7, n6, messageSecurityMode, n4);
            int n14 = (n5 + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
            if (n14 > this.vv.maxSendChunkCount && this.vv.maxSendChunkCount != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            bl = n14 > 1 && n11 > 0 && messageSecurityMode != MessageSecurityMode.None;
            int n15 = n5;
            byteBufferArray2 = new ByteBuffer[n14];
            byteBufferArray = new ByteBuffer[n14];
            for (int i2 = 0; i2 < n14; ++i2) {
                byteBufferArray2[i2] = chunkFactory.allocate(n15);
                byteBufferArray[i2] = chunkFactory.expandToCompleteChunk(byteBufferArray2[i2]);
                n15 -= byteBufferArray2[i2].remaining();
            }
            AsyncWrite asyncWrite2 = asyncWrite;
            synchronized (asyncWrite2) {
                if (asyncWrite.isCanceled()) {
                    return;
                }
                asyncWrite.setWriting();
            }
        }
        catch (ServiceResultException serviceResultException) {
            asyncWrite.setError(serviceResultException);
            return;
        }
        byteBufferArray4 = byteBufferArray;
        byteBufferArray3 = byteBufferArray2;
        n5 = byteBufferArray.length;
        final boolean bl2 = bl;
        int n16 = 0;
        OpcTcpServerConnection opcTcpServerConnection = this;
        synchronized (opcTcpServerConnection) {
            n16 = atomicInteger.getAndAdd(byteBufferArray.length);
            this.startChunkSend(byteBufferArray);
        }
        for (ByteBuffer byteBuffer : byteBufferArray) {
            n4 = byteBuffer == byteBufferArray[byteBufferArray.length - 1] ? 1 : 0;
            byteBuffer.rewind();
            byteBuffer.putInt(n3 | (n4 != 0 ? 0x46000000 : 0x43000000));
            byteBuffer.position(8);
            byteBuffer.putInt(securityToken.getSecureChannelId());
            byteBuffer.putInt(securityToken.getTokenId());
            byteBuffer.putInt(n16++);
            byteBuffer.putInt(n2);
        }
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, final int n2) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        new ChunkSymmEncryptSigner(byteBufferArray4[n2], byteBufferArray3[n2], securityToken).run();
                        byteBufferArray4[n2].rewind();
                        OpcTcpServerConnection.this.endChunkSend(byteBufferArray4[n2]);
                        if (atomicInteger2.incrementAndGet() == n5) {
                            asyncWrite.setWritten();
                        }
                    }
                };
                if (bl2 && n5 > 1) {
                    StackUtils.getNonBlockingWorkExecutor().execute(runnable);
                } else {
                    runnable.run();
                }
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray2, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        final BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable2);
        binaryEncoder.setEncoderContext(this.ru);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    binaryEncoder.putMessage(asyncWrite.getMessage());
                }
                catch (ServiceResultException serviceResultException) {
                    asyncWrite.setError(StackUtils.toServiceResultException(serviceResultException));
                }
            }
        };
        StackUtils.getBlockingWorkExecutor().execute(runnable);
    }

    @Override
    protected synchronized void setError(ServiceResultException serviceResultException) {
        if (!this.hasError()) {
            try {
                this.sendError(new ErrorMessage(serviceResultException.getStatusCode(), serviceResultException.getMessage()));
            }
            catch (ServiceResultException serviceResultException2) {
                logger.warn("Could not send error message", (Throwable)serviceResultException2);
            }
            super.setError(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startChunkSend(ByteBuffer ... byteBufferArray) {
        IncubationQueue incubationQueue = this.vx;
        synchronized (incubationQueue) {
            for (ByteBuffer byteBuffer : byteBufferArray) {
                this.vx.incubate(byteBuffer);
            }
        }
    }
}

