/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.impl.ConnectionCollection;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerConnection;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncServerSocket;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncSocketImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger logger = LoggerFactory.getLogger(OpcTcpServer.class);
    Application application;
    AtomicInteger rK = new AtomicInteger();
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    public Server discoveryServer;
    public EndpointBinding discoveryEndpointBinding;
    private int uP = 0;
    Map<SocketAddress, SocketHandle> sc = new HashMap<SocketAddress, SocketHandle>();
    AsyncServerSocket.ConnectListener vD = new AsyncServerSocket.ConnectListener(){

        @Override
        public void onConnected(AsyncServerSocket asyncServerSocket, AsyncSocketImpl asyncSocketImpl) {
            logger.info("{}: {} connected", (Object)OpcTcpServer.this, (Object)asyncSocketImpl.socket().getRemoteSocketAddress());
            final OpcTcpServerConnection opcTcpServerConnection = new OpcTcpServerConnection(OpcTcpServer.this, asyncSocketImpl);
            OpcTcpServer.this.rM.addConnection(opcTcpServerConnection);
            opcTcpServerConnection.addConnectionListener(new IConnectionListener(){

                @Override
                public void onClosed(ServiceResultException serviceResultException) {
                    OpcTcpServer.this.rM.removeConnection(opcTcpServerConnection);
                }

                @Override
                public void onOpen() {
                }
            });
        }
    };
    ConnectionCollection rM = new ConnectionCollection(this);

    public OpcTcpServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            this.discoveryServer = new Server(application);
            this.discoveryServer.setEndpointBindings(this.endpointBindings);
            this.discoveryEndpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        }
        catch (IOException iOException) {
            throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)iOException);
        }
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.rM.addConnectionListener(connectListener);
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        String string = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        if (!"opc.tcp".equals(string)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind " + string + " to opc.tcp server");
        }
        SocketHandle socketHandle = this.a(socketAddress);
        if (socketHandle.rL == null) {
            try {
                socketHandle.setChannel(ServerSocketChannel.open());
                socketHandle.getChannel().configureBlocking(false);
                socketHandle.rL = new AsyncServerSocket(socketHandle.getChannel(), StackUtils.getNonBlockingWorkExecutor(), StackUtils.getSelector());
                socketHandle.rL.bind(socketHandle.sk, 0);
                socketHandle.rL.addListener(this.vD);
                logger.info("TCP/IP Socket bound to {}", (Object)socketAddress);
            }
            catch (IOException iOException) {
                logger.error("Failed to bind address " + socketHandle.sk, (Throwable)iOException);
                socketHandle.close();
                throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)iOException);
            }
        }
        OpcTcpEndpointHandle opcTcpEndpointHandle = socketHandle.b(endpointBinding);
        return opcTcpEndpointHandle;
    }

    @Override
    public void bindReverse(final SocketAddress socketAddress, final String string) {
        if (socketAddress == null || string == null) {
            throw new IllegalArgumentException();
        }
        ReverseSocketHandle reverseSocketHandle = new ReverseSocketHandle(socketAddress);
        if (reverseSocketHandle.vK == null) {
            try {
                reverseSocketHandle.setChannel(SocketChannel.open());
                reverseSocketHandle.getChannel().configureBlocking(false);
                reverseSocketHandle.vK = new AsyncSocketImpl(reverseSocketHandle.getChannel(), StackUtils.getNonBlockingWorkExecutor(), StackUtils.getSelector());
                ReverseHello reverseHello = new ReverseHello();
                reverseHello.setEndpointUrl(string);
                reverseHello.setServerUri(this.application.getApplicationDescription().getApplicationUri());
                final OpcTcpServerConnection opcTcpServerConnection = new OpcTcpServerConnection(this, reverseSocketHandle.vK, reverseHello);
                this.rM.addConnection(opcTcpServerConnection);
                opcTcpServerConnection.addConnectionListener(new IConnectionListener(){

                    @Override
                    public void onClosed(ServiceResultException serviceResultException) {
                        OpcTcpServer.this.rM.removeConnection(opcTcpServerConnection);
                        logger.debug("ReverseHello connection closed, rescheduling connection process");
                        OpcTcpServer.this.bindReverse(socketAddress, string);
                    }

                    @Override
                    public void onOpen() {
                    }
                });
                reverseSocketHandle.vK.connect(reverseSocketHandle.sk);
            }
            catch (IOException iOException) {
                logger.error("Failed to create a ReverseSocketHandle", (Throwable)iOException);
                reverseSocketHandle.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OpcTcpServer close() {
        logger.info("{} closed", (Object)this.getBoundAddress());
        if (!((CloseableObjectState)((Object)this.getState())).isClosed()) {
            this.setState(CloseableObjectState.Closing);
        }
        try {
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    public void disconnectAll() {
        ArrayList<ServerConnection> arrayList = new ArrayList<ServerConnection>();
        this.getConnections(arrayList);
        for (ServerConnection serverConnection : arrayList) {
            OpcTcpServerConnection opcTcpServerConnection = (OpcTcpServerConnection)serverConnection;
            opcTcpServerConnection.close();
        }
    }

    public SocketAddress getBoundAddress() {
        SocketHandle[] socketHandleArray;
        for (SocketHandle socketHandle : socketHandleArray = this.socketHandleSnapshot()) {
            if (socketHandle.rL == null) continue;
            return socketHandle.sk;
        }
        return null;
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.sk);
        }
        return arrayList;
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.rM.getConnections(collection);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public int getReceiveBufferSize() {
        return this.uP;
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.rM.removeConnectionListener(connectListener);
    }

    public void setReceiveBufferSize(int n2) throws ServiceResultException {
        this.uP = n2;
        if (n2 > 0) {
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                try {
                    AsyncServerSocket asyncServerSocket = socketHandle.rL;
                    if (asyncServerSocket == null) continue;
                    asyncServerSocket.socket().setReceiveBufferSize(n2);
                }
                catch (SocketException socketException) {
                    throw new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)socketException);
                }
            }
        }
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.sc.values().toArray(new SocketHandle[this.sc.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OpcTcpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    int a(Endpoint endpoint) {
        int n2 = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!opcTcpEndpointHandle.si.endpointAddress.equals(endpoint)) continue;
                ++n2;
            }
        }
        return n2;
    }

    List<OpcTcpEndpointHandle> z(String string) {
        ArrayList<OpcTcpEndpointHandle> arrayList = new ArrayList<OpcTcpEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.a(arrayList);
        }
        return arrayList;
    }

    synchronized SocketHandle a(SocketAddress socketAddress) throws ServiceResultException {
        SocketHandle socketHandle = this.sc.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress);
            this.sc.put(socketAddress, socketHandle);
        }
        return socketHandle;
    }

    public class SocketHandle {
        SocketAddress sk;
        AsyncServerSocket rL;
        private ServerSocketChannel vL;
        int port;
        Map<Endpoint, OpcTcpEndpointHandle> endpoints = new HashMap<Endpoint, OpcTcpEndpointHandle>();

        SocketHandle(SocketAddress socketAddress) {
            this.sk = socketAddress;
        }

        public synchronized OpcTcpEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new OpcTcpEndpointHandle[this.endpoints.size()]);
        }

        public ServerSocketChannel getChannel() {
            return this.vL;
        }

        public SocketAddress getSocketAddress() {
            return this.sk;
        }

        public void setChannel(ServerSocketChannel serverSocketChannel) {
            this.vL = serverSocketChannel;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("opc.tcp(" + this.sk + ", ");
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(opcTcpEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        void close() {
            for (OpcTcpEndpointHandle opcTcpEndpointHandle : this.endpoints.values()) {
                opcTcpEndpointHandle.aPQ();
            }
            OpcTcpServer.this.sc.remove(this.sk);
            if (this.rL != null) {
                AsyncServerSocket asyncServerSocket = this.rL;
                this.rL = null;
                asyncServerSocket.close();
            }
        }

        synchronized void a(Collection<OpcTcpEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized OpcTcpEndpointHandle b(EndpointBinding endpointBinding) throws ServiceResultException {
            OpcTcpEndpointHandle opcTcpEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (opcTcpEndpointHandle == null) {
                opcTcpEndpointHandle = new OpcTcpEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, opcTcpEndpointHandle);
                OpcTcpServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!opcTcpEndpointHandle.si.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return opcTcpEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.sk).getPort();
        }
    }

    public static class ReverseSocketHandle {
        private SocketAddress sk;
        private SocketChannel channel;
        private AsyncSocketImpl vK;

        public ReverseSocketHandle(SocketAddress socketAddress) {
            this.sk = socketAddress;
        }

        public SocketChannel getChannel() {
            return this.channel;
        }

        public AsyncSocketImpl getSocket() {
            return this.vK;
        }

        public SocketAddress getSocketAddress() {
            return this.sk;
        }

        public void setChannel(SocketChannel socketChannel) {
            this.channel = socketChannel;
        }

        public void setSocket(AsyncSocketImpl asyncSocketImpl) {
            this.vK = asyncSocketImpl;
        }

        void close() {
            SocketChannel socketChannel = this.channel;
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    logger.error("Failure in closing ReverseSockeHandle", (Throwable)iOException);
                }
            }
        }
    }

    public class OpcTcpEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding si;
        SocketHandle vJ;

        OpcTcpEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.vJ = socketHandle;
            this.si = endpointBinding;
        }

        @Override
        public void close() {
            this.aPP();
            this.aPQ();
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.si;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.vJ.sk;
        }

        public String toString() {
            return "(" + this.si.endpointAddress.toString() + ")";
        }

        void aPP() {
            this.vJ.endpoints.remove(this.si.endpointAddress);
            if (this.vJ.endpoints.isEmpty()) {
                this.vJ.close();
            }
        }

        void aPQ() {
            int n2 = OpcTcpServer.this.a(this.si.endpointAddress);
            if (n2 == 0) {
                OpcTcpServer.this.endpointBindings.remove(this.si);
                this.si.serviceServer.getEndpointBindings().remove(this.si);
            }
        }
    }
}

