/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.MessageType;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;

public class MessageToChunks
implements Callable<ByteBuffer[]> {
    MessageType vz;
    IEncodeable qT;
    TcpConnectionParameters vv;
    EncoderContext ru;
    ChunkFactory vA;

    public MessageToChunks(IEncodeable iEncodeable, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, ChunkFactory chunkFactory, MessageType messageType) {
        if (iEncodeable == null || tcpConnectionParameters == null || chunkFactory == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.qT = iEncodeable;
        this.vv = tcpConnectionParameters;
        this.ru = encoderContext;
        this.vA = chunkFactory;
        this.vz = messageType;
    }

    @Override
    public ByteBuffer[] call() throws RuntimeServiceResultException {
        try {
            SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
            BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
            binaryEncoder.setEncoderContext(this.ru);
            if (this.vz == MessageType.Encodeable) {
                binaryEncoder.putEncodeable(null, this.qT);
            } else {
                binaryEncoder.putMessage(this.qT);
            }
            int n2 = sizeCalculationOutputStream.getLength();
            if (n2 > this.vv.maxSendMessageSize && this.vv.maxSendMessageSize != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            ByteQueue byteQueue = new ByteQueue();
            byteQueue.order(ByteOrder.LITTLE_ENDIAN);
            byteQueue.setWriteLimit(n2);
            byteQueue.setByteBufferFactory(this.vA);
            byteQueue.setChunkSize(this.vA.maxPlaintextSize);
            ByteBufferArrayWriteable byteBufferArrayWriteable = new ByteBufferArrayWriteable(byteQueue);
            byteBufferArrayWriteable.order(ByteOrder.LITTLE_ENDIAN);
            BinaryEncoder binaryEncoder2 = new BinaryEncoder(byteBufferArrayWriteable);
            binaryEncoder2.setEncoderContext(this.ru);
            if (this.vz == MessageType.Message) {
                binaryEncoder2.putMessage(this.qT);
            } else {
                binaryEncoder2.putEncodeable(null, this.qT);
            }
            ByteBuffer[] byteBufferArray = byteQueue.getChunks(n2);
            if (byteBufferArray.length > this.vv.maxRecvChunkCount && this.vv.maxRecvChunkCount != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            return byteBufferArray;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }
}

