/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.Channel;
import com.prosysopc.ua.stack.transport.tcp.nio.SecureInputMessageBuilder;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.IncubationQueue;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.StateListener;
import com.prosysopc.ua.stack.utils.asyncsocket.SocketState;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerConnection
extends AbstractState<CloseableObjectState, ServiceResultException>
implements CloseableObject,
ServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServerConnection.class);
    int vt = 0;
    SecurityConfiguration securityConfiguration;
    StateListener<SocketState> vu;
    TcpConnectionParameters vv = new TcpConnectionParameters();
    SecureInputMessageBuilder vw;
    Map<Integer, ServerSecureChannel> so = new ConcurrentHashMap<Integer, ServerSecureChannel>();
    CopyOnWriteArrayList<ServerConnection.SecureChannelListener> sp = new CopyOnWriteArrayList();
    IncubationQueue<ByteBuffer> vx = new IncubationQueue(true);
    CopyOnWriteArrayList<Channel.ChannelListener> vy = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<IConnectionListener> sq = new CopyOnWriteArrayList();

    protected AbstractServerConnection() {
        super(CloseableObjectState.Closed);
    }

    public void addChannelListener(Channel.ChannelListener channelListener) {
        this.vy.add(channelListener);
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.sq.add(iConnectionListener);
    }

    @Override
    public void addSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.sp.add(secureChannelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        try {
            this.setState(CloseableObjectState.Closing);
        }
        finally {
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    public String getConnectURL() {
        return this.vv.endpointUrl;
    }

    public Certificate getRemoteCertificate() {
        return this.securityConfiguration.getReceiverCertificate();
    }

    @Override
    public void getSecureChannels(Collection<ServerSecureChannel> collection) {
        collection.addAll(this.so.values());
    }

    public void removeChannelListener(Channel.ChannelListener channelListener) {
        this.vy.remove(channelListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.sq.remove(iConnectionListener);
    }

    @Override
    public void removeSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.sp.remove(secureChannelListener);
    }

    public String toString() {
        CloseableObjectState closeableObjectState = (CloseableObjectState)((Object)this.getState());
        return "Connection (state=" + (Object)((Object)closeableObjectState) + ", local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + ")";
    }

    protected void fireSecureChannelAttached(ServerSecureChannel serverSecureChannel) {
        for (ServerConnection.SecureChannelListener secureChannelListener : this.sp) {
            secureChannelListener.onSecureChannelAttached(this, serverSecureChannel);
        }
    }

    protected void fireSecureChannelDetached(ServerSecureChannel serverSecureChannel) {
        for (ServerConnection.SecureChannelListener secureChannelListener : this.sp) {
            secureChannelListener.onSecureChannelDetached(this, serverSecureChannel);
        }
    }

    protected abstract CertificateValidator getRemoteCertificateValidator();

    @Override
    protected void onListenerException(RuntimeException runtimeException) {
        this.setError(StackUtils.toServiceResultException(runtimeException));
    }

    @Override
    protected void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Open) {
            for (IConnectionListener object : this.sq) {
                object.onOpen();
            }
        }
        if (closeableObjectState2 == CloseableObjectState.Closed) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError);
            for (IConnectionListener iConnectionListener : this.sq) {
                iConnectionListener.onClosed(serviceResultException);
            }
        }
    }

    protected abstract int sendAsymmSecureMessage(AsyncWrite var1, SecurityConfiguration var2, int var3, int var4, AtomicInteger var5) throws ServiceResultException;

    protected abstract void sendSecureMessage(AsyncWrite var1, SecurityToken var2, int var3, int var4, AtomicInteger var5);

    @Override
    protected synchronized void setError(ServiceResultException serviceResultException) {
        if (this.hasError()) {
            return;
        }
        super.setError(serviceResultException);
        this.close();
    }

    @Override
    protected void setError(StatusCode statusCode) {
        this.setError(new ServiceResultException(statusCode));
    }

    @Override
    protected void setError(UnsignedInteger unsignedInteger) {
        this.setError(new StatusCode(unsignedInteger));
    }
}

