/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.crypto.Mac;

public class SecurityToken {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private SecurityConfiguration securityConfiguration;
    private int ug;
    private int re;
    private long creationTime;
    private long uh;
    private ByteString ui;
    private ByteString uj;
    private byte[] uk;
    private byte[] ul;
    private byte[] um;
    private byte[] un;
    private byte[] uo;
    private byte[] up;

    public SecurityToken(SecurityConfiguration securityConfiguration, int n2, int n3, long l2, long l3, ByteString byteString, ByteString byteString2) throws ServiceResultException {
        if (securityConfiguration == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.re = n2;
        this.securityConfiguration = securityConfiguration;
        this.ug = n3;
        this.uh = l3;
        this.creationTime = l2;
        this.ui = byteString;
        this.uj = byteString2;
        boolean bl = securityConfiguration.getMessageSecurityMode() == MessageSecurityMode.None;
        int n4 = this.getSecurityPolicy().getSignatureKeySize();
        int n5 = this.getSecurityPolicy().getEncryptionKeySize();
        int n6 = this.getSecurityPolicy().getEncryptionBlockSize();
        this.uk = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), 0, n4);
        this.ul = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), n4, n5);
        this.um = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), n4 + n5, n6);
        this.un = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), 0, n4);
        this.uo = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), n4, n5);
        this.up = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), n4 + n5, n6);
    }

    public Mac createLocalHmac() throws ServiceResultException {
        return this.createHmac(this.getLocalSigningKey());
    }

    public Mac createRemoteHmac() throws ServiceResultException {
        return this.createHmac(this.getRemoteSigningKey());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLifeTime() {
        return this.uh;
    }

    public byte[] getLocalEncryptingKey() {
        return this.ul;
    }

    public byte[] getLocalInitializationVector() {
        return this.um;
    }

    public ByteString getLocalNonce() {
        return this.ui;
    }

    public byte[] getLocalSigningKey() {
        return this.uk;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.securityConfiguration.getMessageSecurityMode();
    }

    public byte[] getRemoteEncryptingKey() {
        return this.uo;
    }

    public byte[] getRemoteInitializationVector() {
        return this.up;
    }

    public ByteString getRemoteNonce() {
        return this.uj;
    }

    public byte[] getRemoteSigningKey() {
        return this.un;
    }

    public long getRenewTime() {
        return this.creationTime + this.uh * 3L / 4L;
    }

    public int getSecureChannelId() {
        return this.re;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityConfiguration.getSecurityPolicy();
    }

    public int getTokenId() {
        return this.ug;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.creationTime + this.uh;
    }

    public boolean isTimeToRenew() {
        return this.creationTime + this.uh * 3L / 4L < System.currentTimeMillis();
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.creationTime + this.uh + this.uh / 4L;
    }

    public void setLocalEncryptingKey(byte[] byArray) {
        this.ul = byArray;
    }

    public void setLocalInitializationVector(byte[] byArray) {
        this.um = byArray;
    }

    public void setLocalSigningKey(byte[] byArray) {
        this.uk = byArray;
    }

    public void setRemoteEncryptingKey(byte[] byArray) {
        this.uo = byArray;
    }

    public void setRemoteInitializationVector(byte[] byArray) {
        this.up = byArray;
    }

    public void setRemoteSigningKey(byte[] byArray) {
        this.un = byArray;
    }

    public String toString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(this.creationTime);
        return "SecurityToken(Id=" + this.ug + ", secureChannelId=" + this.re + ", creationTime=" + DateFormat.getDateTimeInstance().format(gregorianCalendar.getTime()) + ", lifetime=" + this.uh + ")";
    }

    private byte[] a(ByteString byteString, String string, ByteString byteString2, int n2, int n3) throws ServiceResultException {
        Object object;
        byte[] byArray;
        if (byteString == null) {
            throw new IllegalArgumentException("ArgumentNullException: secret");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        byte[] byArray2 = byArray = string != null && !string.isEmpty() ? string.getBytes(UTF8) : null;
        if (byteString2 != null && byteString2.getLength() > 0) {
            if (byArray != null) {
                object = ByteBuffer.allocate(byArray.length + byteString2.getLength());
                ((ByteBuffer)object).put(byArray);
                ((ByteBuffer)object).put(byteString2.getValue());
                ((ByteBuffer)object).rewind();
                byArray = ((ByteBuffer)object).array();
            } else {
                byArray = byteString2.getValue();
            }
        }
        if (byArray == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The PSHA algorithm requires a non-null seed.");
        }
        object = this.securityConfiguration.getSecurityPolicy();
        Mac mac = CryptoUtil.createMac(((SecurityPolicy)((Object)object)).getKeyDerivationAlgorithm(), byteString.getValue());
        mac.update(byArray);
        byte[] byArray3 = mac.doFinal();
        byte[] byArray4 = new byte[mac.getMacLength() + byArray.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        byte[] byArray5 = new byte[n3];
        int n4 = 0;
        do {
            mac.update(byArray4);
            byte[] byArray6 = mac.doFinal();
            if (n2 < byArray6.length) {
                for (int i2 = n2; n4 < n3 && i2 < byArray6.length; ++i2) {
                    byArray5[n4++] = byArray6[i2];
                }
            }
            n2 = n2 > byArray6.length ? (n2 -= byArray6.length) : 0;
            mac.update(byArray3);
            byArray3 = mac.doFinal();
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        } while (n4 < n3);
        return byArray5;
    }

    protected Mac createHmac(byte[] byArray) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.securityConfiguration.getSecurityPolicy();
        return CryptoUtil.createMac(securityPolicy.getSymmetricSignatureAlgorithm(), byArray);
    }
}

