/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkSymmDecryptVerifier
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkSymmDecryptVerifier.class);
    static final int tX = 8;
    static final int messageHeaderSize = 8;
    static final int tY = 8;
    static final int tZ = 16;
    ByteBuffer tQ;
    SecurityToken ua;

    public ChunkSymmDecryptVerifier(ByteBuffer byteBuffer, SecurityToken securityToken) {
        this.tQ = byteBuffer;
        this.ua = securityToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws RuntimeServiceResultException {
        SecurityPolicy securityPolicy = this.ua.getSecurityPolicy();
        MessageSecurityMode messageSecurityMode = this.ua.getMessageSecurityMode();
        int n2 = this.tQ.limit();
        try {
            int n3;
            int n4 = ChunkUtils.getTokenId(this.tQ);
            if (n4 != this.ua.getTokenId()) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
            }
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                this.tQ.position(16);
                byte[] byArray = new byte[this.tQ.limit() - 16];
                this.tQ.get(byArray, 0, byArray.length);
                n3 = this.a(this.ua, byArray, 0, byArray.length, this.tQ.array(), 16 + this.tQ.arrayOffset());
            } else {
                n3 = this.tQ.limit() - 16;
            }
            int n5 = 0;
            int n6 = securityPolicy.getSymmetricSignatureSize();
            if (messageSecurityMode == MessageSecurityMode.Sign || messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n6];
                this.tQ.position(n2 - n6);
                this.tQ.get(byArray);
                this.tQ.position(0);
                byte[] byArray2 = new byte[16 + n3 - n6];
                this.tQ.get(byArray2, 0, byArray2.length);
                this.a(this.ua, byArray2, byArray);
            }
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n7 = 0;
                n7 = 16 + n3 - n6 - 1;
                n5 = this.tQ.get(n7);
                for (int i2 = n7 - n5; i2 < n7; ++i2) {
                    if (this.tQ.get(i2) == n5) continue;
                    logger.error("Padding does not match");
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Could not verify the padding in the message");
                }
                ++n5;
            }
            this.tQ.position(24);
            this.tQ.limit(this.tQ.position() + n3 - 8 - n5 - n6);
            int n8 = this.tQ.limit() - 8 - 8 - 8 - n6 - n5;
            if (n8 >= 0) return;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int a(SecurityToken securityToken, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ServiceResultException {
        logger.debug("decrypt: dataToDecrypt.length={} inputOffset={} inputLength={} output.length={} outputOffset={}", new Object[]{byArray.length, n2, n3, byArray2.length, n4});
        return CryptoUtil.getCryptoProvider().decryptSymm(securityToken.getSecurityPolicy(), securityToken.getRemoteEncryptingKey(), securityToken.getRemoteInitializationVector(), byArray, n2, n3, byArray2, n4);
    }

    private void a(SecurityToken securityToken, byte[] byArray, byte[] byArray2) throws ServiceResultException {
        CryptoUtil.getCryptoProvider().verifySymm(securityToken.getSecurityPolicy(), securityToken.getRemoteSigningKey(), byArray, 0, byArray.length, byArray2);
    }
}

