/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.CryptoProvider;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkAsymmEncryptSigner
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkAsymmEncryptSigner.class);
    ByteBuffer tQ;
    ByteBuffer tU;
    SecurityConfiguration tV;
    private int signatureSize;

    public ChunkAsymmEncryptSigner(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, SecurityConfiguration securityConfiguration) {
        this.tQ = byteBuffer;
        this.tU = byteBuffer2;
        this.tV = securityConfiguration;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        try {
            int n2 = this.tU.limit();
            MessageSecurityMode messageSecurityMode = this.tV.getMessageSecurityMode();
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            SecurityPolicy securityPolicy = this.tV.getSecurityPolicy();
            int n3 = 8;
            SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
            boolean bl = MessageSecurityMode.Sign == messageSecurityMode || MessageSecurityMode.SignAndEncrypt == messageSecurityMode;
            this.signatureSize = bl ? CryptoUtil.getSignatureSize(securityAlgorithm, this.tV.getLocalPrivateKey()) : 0;
            logger.debug("SecurityMode in asymm enc: {}", (Object)messageSecurityMode.getValue());
            int n4 = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n5 = this.tV.getRemoteCertificate2().getKeySize();
                logger.trace("keySize={}", (Object)n5);
                n4 = this.i(n5);
                logger.trace("padding={}", (Object)n4);
            }
            if (messageSecurityMode == MessageSecurityMode.Sign || messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[this.tU.arrayOffset() + n2 + n4];
                this.tQ.rewind();
                this.tQ.get(byArray, 0, byArray.length);
                byte[] byArray2 = this.a(byArray, this.tV.getLocalPrivateKey());
                this.tQ.put(byArray2);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("getPaddingSize: chunk={}", (Object)CryptoUtil.toHex(this.tQ.array(), 64));
            }
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n3 + n2 + n4 + this.signatureSize];
                this.tQ.position(this.tU.arrayOffset() - n3);
                this.tQ.get(byArray, 0, byArray.length);
                this.a(byArray, this.tV.getRemoteCertificate().getPublicKey(), this.tQ.array(), this.tU.arrayOffset() - n3);
            }
            this.tQ.position(this.tU.arrayOffset());
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private void a(byte[] byArray, PublicKey publicKey, byte[] byArray2, int n2) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.tV.getSecurityPolicy();
        logger.debug("rsa_Encrypt: policy={}", (Object)securityPolicy);
        int n3 = 1;
        PublicKey publicKey2 = this.tV.getRemoteCertificate().getPublicKey();
        n3 = CryptoUtil.getPlainTextBlockSize(securityPolicy.getAsymmetricEncryptionAlgorithm(), publicKey2);
        logger.debug("encrypt: inputBlockSize={}", (Object)n3);
        if (byArray.length % n3 != 0) {
            logger.error("Wrong block size in asym encryption: length={} inputBlockSize={}", (Object)byArray.length, (Object)n3);
            throw new ServiceResultException(StatusCodes.Bad_InternalError, "Error in asymmetric encrypt: Input data is not an even number of encryption blocks.");
        }
        CryptoProvider cryptoProvider = CryptoUtil.getCryptoProvider();
        cryptoProvider.encryptAsymm(publicKey, this.tV.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n2);
        if (logger.isTraceEnabled()) {
            logger.trace("encrypt: dataToEncrypt={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("encrypt: output={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
    }

    private int i(int n2) {
        int n3 = this.tQ.limit() - 1;
        if (logger.isTraceEnabled()) {
            logger.trace("getPaddingSize: chunk={}", (Object)CryptoUtil.toHex(this.tQ.array(), 64));
            logger.trace("getPaddingSize: plaintext={}", (Object)CryptoUtil.toHex(this.tU.array(), 64));
            logger.trace("getPaddingSize: plaintext.arrayOffset()={}", (Object)this.tU.arrayOffset());
            logger.trace("getPaddingSize: plaintext.limit()={}", (Object)this.tU.limit());
            logger.trace("getPaddingSize: lastPaddingBytePosition={}", (Object)n3);
        }
        if (n2 > 2048) {
            int n4 = this.tQ.get(n3) & 0xFF;
            int n5 = this.tQ.get(n3 - 1) & 0xFF;
            logger.trace("getPaddingSize: paddingByte={}", (Object)n5);
            logger.trace("getPaddingSize: extraPaddingByte={}", (Object)n4);
            logger.trace("getPaddingSize: padding={}", (Object)(n5 | n4 << 8));
            return (n5 & 0xFF | (n4 & 0xFF) << 8) + 2;
        }
        int n6 = this.tQ.get(n3) & 0xFF;
        return (n6 & 0xFF) + 1;
    }

    private byte[] a(byte[] byArray, RSAPrivateKey rSAPrivateKey) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.tV.getSecurityPolicy();
        if (securityPolicy == SecurityPolicy.NONE) {
            return null;
        }
        byte[] byArray2 = CryptoUtil.getCryptoProvider().signAsymm(rSAPrivateKey, this.tV.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), byArray);
        if (logger.isTraceEnabled()) {
            logger.trace("sign: dataToSign={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("sign: signature={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
        return byArray2;
    }
}

