/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkAsymmDecryptVerifier
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkAsymmDecryptVerifier.class);
    ByteBuffer tQ;
    SecurityConfiguration tR;
    String securityPolicyUri;
    byte[] tS;
    byte[] tT;

    public ChunkAsymmDecryptVerifier(ByteBuffer byteBuffer, SecurityConfiguration securityConfiguration) {
        this.tQ = byteBuffer;
        this.tR = securityConfiguration;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.tT;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public byte[] getSenderCertificate() {
        return this.tS;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        try {
            SecurityPolicy securityPolicy = this.tR.getSecurityPolicy();
            MessageSecurityMode messageSecurityMode = this.tR.getMessageSecurityMode();
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            this.tQ.position(12);
            this.securityPolicyUri = ChunkUtils.getString(this.tQ);
            logger.debug("SecurityPolicy in use: {}", (Object)this.securityPolicyUri);
            logger.debug("SecurityMode in use: {}", (Object)this.tR.getMessageSecurityMode());
            if (logger.isTraceEnabled()) {
                logger.trace("Chunk: {}", (Object)CryptoUtil.toHex(this.tQ.array(), 64));
            }
            this.tS = ChunkUtils.getByteString(this.tQ);
            this.tT = ChunkUtils.getByteString(this.tQ);
            int n2 = this.tQ.position();
            int n3 = this.tQ.position() + 8;
            int n4 = this.tQ.limit();
            int n5 = n4 - n2;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n5];
                this.tQ.position(n2);
                this.tQ.get(byArray, 0, byArray.length);
                n5 = this.a(byArray, this.tR.getLocalPrivateKey(), this.tQ.array(), n2 + this.tQ.arrayOffset());
                if (logger.isTraceEnabled()) {
                    logger.trace("Chunk decrypted: {}", (Object)CryptoUtil.toHex(this.tQ.array(), 64));
                }
            }
            int n6 = 0;
            if (MessageSecurityMode.Sign == messageSecurityMode || MessageSecurityMode.SignAndEncrypt == messageSecurityMode) {
                SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
                logger.debug("signatureAlgorithm={}", (Object)securityAlgorithm);
                PublicKey publicKey = this.tR.getRemoteCertificate().getPublicKey();
                n6 = CryptoUtil.getSignatureSize(securityAlgorithm, publicKey);
                logger.debug("signatureSize={}", (Object)n6);
                byte[] byArray = new byte[n2 + n5 - n6];
                this.tQ.position(0);
                this.tQ.get(byArray, 0, byArray.length);
                this.tQ.position(n2 + n5 - n6);
                byte[] byArray2 = new byte[n6];
                this.tQ.get(byArray2, 0, n6);
                Certificate certificate = this.tR.getRemoteCertificate();
                if (!this.a(byArray, certificate, byArray2)) {
                    logger.error("Signature verification fails.");
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature could not be VERIFIED");
                }
            }
            int n7 = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n8;
                byte by;
                boolean bl;
                int n9 = this.tR.getLocalCertificate2().getCertificate().getKeySize();
                int n10 = n2 + n5 - n6 - 1;
                boolean bl2 = bl = n9 > 2048;
                if (bl) {
                    by = this.tQ.get(n10 - 1);
                    n8 = this.tQ.get(n10);
                    n7 = (by & 0xFF | (n8 & 0xFF) << 8) + 2;
                } else {
                    by = this.tQ.get(n10);
                    n7 = (by & 0xFF) + 1;
                }
                logger.debug("paddingEnd={} paddingSize={}", (Object)n10, (Object)n7);
                n8 = bl ? n7 - 1 : n7;
                int n11 = bl ? n10 - n8 : n10 - n8 + 1;
                for (int i2 = 0; i2 < n8; ++i2) {
                    byte by2 = this.tQ.get(n11 + i2);
                    if (by2 == by) continue;
                    logger.error(String.format("Padding does not match: %x <> %x", by2, (int)by));
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Could not verify the padding in the message");
                }
            }
            this.tQ.position(n3);
            this.tQ.limit(this.tQ.position() + n5 - 8 - n7 - n6);
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int a(byte[] byArray, PrivateKey privateKey, byte[] byArray2, int n2) throws ServiceResultException {
        int n3 = CryptoUtil.getCryptoProvider().decryptAsymm(privateKey, this.tR.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n2);
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: dataToDecrypt={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("decrypt: output={}", (Object)CryptoUtil.toHex(byArray2, 64));
            logger.trace("decrypt: bytesDecrypted={}", (Object)n3);
        }
        return n3;
    }

    private boolean a(byte[] byArray, Certificate certificate, byte[] byArray2) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.tR.getSecurityPolicy();
        logger.debug("verify: policy={}", (Object)securityPolicy);
        if (logger.isTraceEnabled()) {
            logger.trace("verify: {}", (Object)certificate);
            logger.trace("verify: dataToVerify={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("verify: signature={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
        return CryptoUtil.getCryptoProvider().verifyAsymm(certificate.getPublicKey(), this.tR.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), byArray, byArray2);
    }
}

