/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.FileUtil;
import com.prosysopc.ua.stack.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class Cert {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----" + StringUtils.lineSeparator();
    private static final String END_CERT = StringUtils.lineSeparator() + "-----END CERTIFICATE-----";
    public final X509Certificate certificate;
    public final byte[] encodedCertificate;
    public final byte[] encodedCertificateThumbprint;

    public static Cert load(File file) throws IOException, CertificateException {
        return Cert.load(file.toURI().toURL());
    }

    public static Cert load(URL uRL) throws IOException, CertificateException {
        X509Certificate x509Certificate = CertificateUtils.readX509Certificate(uRL);
        return new Cert(x509Certificate);
    }

    public Cert(byte[] byArray) throws ServiceResultException {
        try {
            this.certificate = CertificateUtils.decodeX509Certificate(byArray);
            this.encodedCertificate = this.certificate.getEncoded();
            this.encodedCertificateThumbprint = CertificateUtils.createThumbprint(this.encodedCertificate);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateTimeInvalid, (Throwable)certificateNotYetValidException);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateTimeInvalid, (Throwable)certificateExpiredException);
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, (Throwable)certificateParsingException);
        }
        catch (CertificateException certificateException) {
            throw new ServiceResultException(StatusCodes.Bad_CertificateInvalid, (Throwable)certificateException);
        }
    }

    public Cert(X509Certificate x509Certificate) throws CertificateEncodingException {
        this.certificate = x509Certificate;
        this.encodedCertificate = x509Certificate.getEncoded();
        this.encodedCertificateThumbprint = CertificateUtils.createThumbprint(this.encodedCertificate);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Cert cert = (Cert)object;
        return Arrays.equals(this.encodedCertificate, cert.encodedCertificate);
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] getEncoded() {
        return this.encodedCertificate;
    }

    public byte[] getEncodedThumbprint() {
        return this.encodedCertificateThumbprint;
    }

    public int getKeySize() {
        PublicKey publicKey = this.certificate.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            return -1;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        return rSAPublicKey.getModulus().bitLength();
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedCertificate);
    }

    public void save(File file) throws IOException {
        FileUtil.writeFile(file, this.encodedCertificate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToPem(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.append(BEGIN_CERT);
            fileWriter.append(StringUtils.addLineBreaks(CryptoUtil.base64Encode(this.getEncoded()), 64));
            fileWriter.append(END_CERT);
        }
        finally {
            fileWriter.close();
        }
    }

    public String toString() {
        return this.certificate.toString();
    }
}

