/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.impl;

import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.ServerConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectionCollection
implements ConnectionMonitor {
    Set<ServerConnection> sT = new HashSet<ServerConnection>();
    CopyOnWriteArrayList<ConnectionMonitor.ConnectListener> rg = new CopyOnWriteArrayList();
    Object sU;

    public ConnectionCollection(Object object) {
        this.sU = object;
    }

    public void addConnection(ServerConnection serverConnection) {
        if (!this.sT.add(serverConnection)) {
            return;
        }
        for (ConnectionMonitor.ConnectListener connectListener : this.rg) {
            connectListener.onConnect(this.sU, serverConnection);
        }
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.rg.add(connectListener);
    }

    public Iterator<ConnectionMonitor.ConnectListener> getConnectionListeners() {
        return this.rg.iterator();
    }

    @Override
    public synchronized void getConnections(Collection<ServerConnection> collection) {
        collection.addAll(this.sT);
    }

    public void removeConnection(ServerConnection serverConnection) {
        this.sT.remove(serverConnection);
        for (ConnectionMonitor.ConnectListener connectListener : this.rg) {
            connectListener.onClose(this.sU, serverConnection);
        }
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.rg.remove(connectListener);
    }
}

