/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.transport.https.HttpsServerConnection;
import com.prosysopc.ua.stack.transport.https.HttpsServerEndpointHandler;
import com.prosysopc.ua.stack.transport.https.HttpsServerSecureChannel;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class b
extends EndpointServiceRequest<ServiceRequest<ServiceResponse>, ServiceResponse>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(b.class);
    HttpsServerEndpointHandler su;
    HttpAsyncExchange sv;
    HttpRequest sw;
    HttpEntity sx;
    HttpsServerSecureChannel sy;
    SecurityPolicy sz;
    int requestId;
    AsyncWrite sA;
    Thread sB;
    int re = -1;

    public b(HttpsServerEndpointHandler httpsServerEndpointHandler, HttpAsyncExchange httpAsyncExchange, HttpRequest httpRequest, HttpsServerSecureChannel httpsServerSecureChannel, int n2) {
        super(null, httpsServerEndpointHandler.si.serviceServer, httpsServerEndpointHandler.si.endpointAddress);
        this.su = httpsServerEndpointHandler;
        this.sw = httpRequest;
        this.requestId = n2;
        this.sv = httpAsyncExchange;
        this.sy = httpsServerSecureChannel;
        String string = null;
        if (httpRequest instanceof HttpMessage) {
            HttpRequest httpRequest2 = httpRequest;
            Header header = httpRequest2.getFirstHeader("OPCUA-SecurityPolicy");
            if (header != null) {
                string = header.getValue();
            }
            if (string == null) {
                string = "http://opcfoundation.org/UA/SecurityPolicy#None";
            }
        }
        if (string == null || string.isEmpty()) {
            this.sz = SecurityPolicy.NONE;
        } else {
            try {
                this.sz = SecurityPolicy.getSecurityPolicy(string);
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("Encountered unknown SecurityPolicyUri, {}", (Object)string, (Object)serviceResultException);
                throw new RuntimeException();
            }
        }
    }

    @Override
    public ServerSecureChannel getChannel() {
        return this.sy;
    }

    @Override
    public SecurityMode getSecurityMode() {
        if (SecurityPolicy.NONE == this.sz) {
            return SecurityMode.NONE;
        }
        return new SecurityMode(this.sz, MessageSecurityMode.Sign);
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.sz;
    }

    @Override
    public void run() {
        Object object;
        this.sB = Thread.currentThread();
        Header header = this.sw.getFirstHeader("Content-Length");
        if (header != null && !((String)(object = header.getValue().trim())).isEmpty()) {
            try {
                long l2 = Long.valueOf((String)object);
                long l3 = this.su.em.getMaxMessageSize().intValue();
                if (l3 != 0L && l2 > l3) {
                    this.a(500, StatusCodes.Bad_RequestTooLarge, "No request message");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            Object object2;
            if (this.sw instanceof HttpEntityEnclosingRequest) {
                object2 = (HttpEntityEnclosingRequest)this.sw;
                this.sx = object2.getEntity();
                long l4 = this.sx.getContentLength();
                long l5 = this.su.em.getMaxMessageSize().intValue();
                if (l5 != 0L && l4 > l5) {
                    this.a(500, StatusCodes.Bad_RequestTooLarge, "No request message");
                    return;
                }
            } else {
                this.a(500, StatusCodes.Bad_RequestTypeInvalid, "No request message");
                return;
            }
            object = EntityUtils.toByteArray((HttpEntity)this.sx);
            object2 = new BinaryDecoder((byte[])object);
            ((BinaryDecoder)object2).setEncoderContext(this.su.getEncoderContext());
            this.request = (ServiceRequest)((BinaryDecoder)object2).getMessage();
            logger.trace("request={}", this.request);
            logger.debug("request={}", (Object)this.request.getClass().getSimpleName());
        }
        catch (IllegalStateException illegalStateException) {
            this.a(500, StatusCodes.Bad_UnexpectedError, illegalStateException.getMessage());
            return;
        }
        catch (IOException iOException) {
            this.a(400, StatusCodes.Bad_UnexpectedError, iOException.getMessage());
            return;
        }
        catch (DecodingException decodingException) {
            this.a(400, StatusCodes.Bad_RequestTypeInvalid, decodingException.getMessage());
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            this.a(400, StatusCodes.Bad_DecodingError, stackOverflowError.getMessage());
            return;
        }
        this.su.a(this);
    }

    @Override
    public void sendResponse(final AsyncWrite asyncWrite) {
        this.sA = asyncWrite;
        final int n2 = asyncWrite.getMessage() instanceof ServiceResponse ? 200 : 400;
        asyncWrite.setQueued();
        if (Thread.currentThread() == this.sB) {
            asyncWrite.setWriting();
            this.a(n2, asyncWrite.getMessage());
            asyncWrite.setWritten();
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    asyncWrite.setWriting();
                    b.this.a(n2, asyncWrite.getMessage());
                    asyncWrite.setWritten();
                }
            };
            StackUtils.getBlockingWorkExecutor().execute(runnable);
        }
    }

    @Override
    public AsyncWrite sendResponse(ServiceResponse serviceResponse) {
        this.sA = new AsyncWrite(serviceResponse);
        this.sendResponse(this.sA);
        return this.sA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(int n2, UnsignedInteger unsignedInteger, String string) {
        try {
            ErrorMessage errorMessage = null;
            if (string != null) {
                errorMessage = new ErrorMessage(unsignedInteger, string);
            }
            this.a(n2, errorMessage);
        }
        finally {
            this.su.ss.remove(this.requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(int n2, IEncodeable iEncodeable) {
        try {
            HttpResponse httpResponse;
            block7: {
                httpResponse = this.sv.getResponse();
                httpResponse.setHeader("Content-Type", "application/octet-stream");
                httpResponse.setStatusCode(n2);
                if (iEncodeable != null) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream;
                        logger.trace("sendResponse: requestId={} statusCode={} responseObject={}", new Object[]{this.requestId, n2, iEncodeable});
                        logger.debug("sendResponse: requestId={} statusCode={} responseObject={}", new Object[]{this.requestId, n2, iEncodeable.getClass().getSimpleName()});
                        if (logger.isDebugEnabled() && this.sy.getConnection() != null) {
                            byteArrayOutputStream = ((HttpsServerConnection)this.sy.getConnection()).getNHttpServerConnection();
                            logger.debug("sendResponse: timeout={} {} context={}", new Object[]{this.sv.getTimeout(), byteArrayOutputStream.getSocketTimeout(), byteArrayOutputStream.getContext()});
                        }
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        BinaryEncoder binaryEncoder = new BinaryEncoder(byteArrayOutputStream);
                        binaryEncoder.setEncoderContext(this.su.getEncoderContext());
                        binaryEncoder.putMessage(iEncodeable);
                        httpResponse.setEntity((HttpEntity)new NByteArrayEntity(byteArrayOutputStream.toByteArray()));
                    }
                    catch (EncodingException encodingException) {
                        logger.info("sendResponse: Encoding failed", (Throwable)encodingException);
                        if (iEncodeable instanceof ErrorMessage) break block7;
                        httpResponse.setStatusCode(500);
                    }
                }
            }
            logger.debug("sendResponse: {} length={}", (Object)httpResponse, (Object)httpResponse.getEntity().getContentLength());
            this.sv.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(httpResponse));
        }
        finally {
            this.su.ss.remove(this.requestId);
        }
    }
}

