/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.https.HttpsClient;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a<T extends ServiceResponse>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(a.class);
    HttpsClient rz;
    long gO = System.currentTimeMillis();
    long rA = 0L;
    int requestId;
    AsyncResultImpl<T> rB;
    ServiceRequest<T> rC;
    HttpPost rD;
    UnsignedInteger rE = null;
    int re;
    String rF;

    public a(HttpsClient httpsClient, ServiceRequest<T> serviceRequest) {
        long l2;
        this.rz = httpsClient;
        this.rC = serviceRequest;
        this.rB = new AsyncResultImpl();
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l3 = l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)httpsClient.getOperationTimeout();
        if (l2 != 0L) {
            this.rA = this.gO + l2;
        }
    }

    public void cancel() {
        if (this.rz.rr.remove(this) == null) {
            return;
        }
        this.rE = StatusCodes.Bad_RequestCancelledByRequest;
        HttpPost httpPost = this.rD;
        if (httpPost != null) {
            httpPost.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CloseableHttpResponse closeableHttpResponse;
            if (this.rE != null) {
                this.rB.setError(new ServiceResultException(this.rE));
                return;
            }
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(this.rz.rk);
            String string = inetSocketAddress.getHostName();
            int n2 = inetSocketAddress.getPort();
            String string2 = UriUtil.getTransportProtocol(this.rz.rk);
            HttpHost httpHost = new HttpHost(string, n2, string2);
            String string3 = this.rz.rj.getDescription().getEndpointUrl();
            String string4 = string3 == null ? "" : string3;
            this.rD = new HttpPost(string4);
            this.rD.addHeader("OPCUA-SecurityPolicy", this.rz.securityPolicyUri);
            this.rD.addHeader("Content-Type", "application/octet-stream");
            SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
            BinaryEncoder binaryEncoder = new BinaryEncoder(sizeCalculationOutputStream);
            binaryEncoder.setEncoderContext(this.rz.ru);
            binaryEncoder.putMessage(this.rC);
            int n3 = sizeCalculationOutputStream.getLength();
            int n4 = this.rz.ru.getMaxMessageSize();
            if (n4 != 0 && n3 > n4) {
                EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n4 + " < " + n3);
                logger.warn("run: failed", (Throwable)encodingException);
                throw encodingException;
            }
            byte[] byArray = new byte[n3];
            BinaryEncoder binaryEncoder2 = new BinaryEncoder(byArray);
            binaryEncoder2.setEncoderContext(this.rz.ru);
            binaryEncoder2.putMessage(this.rC);
            this.rD.setEntity((HttpEntity)new NByteArrayEntity(byArray));
            if (this.rE != null) {
                this.rB.setError(new ServiceResultException(this.rE));
                return;
            }
            try {
                closeableHttpResponse = this.rz.rp.execute(httpHost, (HttpRequest)this.rD);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                this.rB.setError(new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, (Throwable)sSLPeerUnverifiedException, "Could not negotiate a TLS security cipher or the server did not provide a valid certificate."));
                this.rz.rr.remove(this.requestId);
                return;
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            int n5 = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n5 != 200) {
                UnsignedInteger unsignedInteger = StatusCodes.Bad_UnknownResponse;
                if (n5 == 501) {
                    unsignedInteger = StatusCodes.Bad_ServiceUnsupported;
                }
                String string5 = EntityUtils.toString((HttpEntity)httpEntity);
                this.rB.setError(new ServiceResultException(unsignedInteger, n5 + ": " + string5));
                return;
            }
            if (this.rE != null) {
                this.rB.setError(new ServiceResultException(this.rE));
                return;
            }
            byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
            BinaryDecoder binaryDecoder = new BinaryDecoder(byArray);
            binaryDecoder.setEncoderContext(this.rz.ru);
            Object t = binaryDecoder.getMessage();
            if (t instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)t;
                ServiceResultException serviceResultException = new ServiceResultException(new StatusCode(errorMessage.getError()), errorMessage.getReason());
                this.rB.setError(serviceResultException);
                return;
            }
            try {
                ServiceResponse serviceResponse = (ServiceResponse)t;
                this.rB.setResult(serviceResponse);
            }
            catch (ClassCastException classCastException) {
                this.rB.setError(new ServiceResultException(classCastException));
                logger.error("Cannot cast response to ServiceResponse, response=" + t.getClass(), (Throwable)classCastException);
            }
        }
        catch (EncodingException encodingException) {
            this.rB.setError(new ServiceResultException(StatusCodes.Bad_EncodingError, (Throwable)encodingException));
        }
        catch (ClientProtocolException clientProtocolException) {
            this.rB.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)clientProtocolException));
        }
        catch (IOException iOException) {
            if (this.rE != null) {
                this.rB.setError(new ServiceResultException(this.rE, (Throwable)iOException));
            } else {
                this.rB.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException));
            }
        }
        catch (DecodingException decodingException) {
            this.rB.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)decodingException));
        }
        catch (ServiceResultException serviceResultException) {
            this.rB.setError(serviceResultException);
        }
        catch (RuntimeException runtimeException) {
            this.rB.setError(new ServiceResultException(runtimeException));
        }
        catch (StackOverflowError stackOverflowError) {
            this.rB.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
        }
        finally {
            this.rz.rr.remove(this.requestId);
        }
    }

    public void timeout() {
        if (this.rz.rr.remove(this.requestId) == null) {
            return;
        }
        this.rE = StatusCodes.Bad_Timeout;
        HttpPost httpPost = this.rD;
        if (httpPost != null) {
            httpPost.abort();
        }
        this.rB.setError(new ServiceResultException(this.rE));
    }
}

