/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.https.a;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.io.ITransportChannel;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClient
implements ITransportChannel {
    static final ServiceResultException rh = new ServiceResultException(StatusCodes.Bad_Timeout);
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final Logger logger = LoggerFactory.getLogger(HttpsClient.class);
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new X509HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }

        public void verify(String string, SSLSocket sSLSocket) throws IOException {
        }

        public void verify(String string, String[] stringArray, String[] stringArray2) throws SSLException {
        }

        public void verify(String string, X509Certificate x509Certificate) throws SSLException {
        }
    };
    AtomicInteger ri = new AtomicInteger(0);
    TransportChannelSettings rj;
    String rk;
    HttpsSecurityPolicy[] rl;
    Executor executor = StackUtils.getBlockingWorkExecutor();
    SchemeRegistry rm;
    ClientConnectionManager rn;
    int ro = 20;
    DefaultHttpClient rp;
    String protocol;
    IEncodeableSerializer rq;
    String securityPolicyUri;
    Map<Integer, a> rr = new ConcurrentHashMap<Integer, a>();
    Timer rs;
    AtomicReference<TimerTask> rt = new AtomicReference<Object>(null);
    EncoderContext ru;
    AtomicInteger rv = new AtomicInteger();
    String[] rw;
    Runnable rx = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpsClient.this.aPL();
            Map<Integer, a> map = HttpsClient.this.rr;
            synchronized (map) {
                long l2 = System.currentTimeMillis();
                for (a a2 : HttpsClient.this.rr.values()) {
                    if (a2.rA == 0L || l2 < a2.rA) continue;
                    long l3 = System.currentTimeMillis() - a2.gO;
                    long l4 = a2.rA - a2.gO;
                    logger.warn("Request id={} msg={} timeouted {} ms elapsed. timeout at {} ms", new Object[]{a2.requestId, a2.rC.getClass(), l3, l4});
                    a2.timeout();
                }
            }
            HttpsClient.this.aPM();
        }
    };

    public HttpsClient(String string) {
        if (!string.equals("http") && !string.equals("opc.https")) {
            throw new IllegalArgumentException();
        }
        this.protocol = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<a> arrayList;
        this.rn.shutdown();
        this.aPL();
        Map<Integer, a> map = this.rr;
        synchronized (map) {
            arrayList = new ArrayList<a>(this.rr.values());
            logger.debug("requests.clear()");
            this.rr.clear();
        }
        if (!arrayList.isEmpty()) {
            for (a a2 : arrayList) {
                a2.cancel();
            }
        }
    }

    @Override
    public void dispose() {
        this.close();
        this.rn = null;
        this.rm = null;
        this.rp = null;
        this.rq = null;
        this.rj = null;
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.rj.getConfiguration();
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.rj.getDescription();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.ru;
    }

    @Override
    public int getOperationTimeout() {
        Integer n2 = this.rj.getConfiguration().getOperationTimeout();
        return n2 == null ? 0 : n2;
    }

    @Override
    public EnumSet<ITransportChannel.TransportChannelFeature> getSupportedFeatures() {
        return EnumSet.of(ITransportChannel.TransportChannelFeature.open, new ITransportChannel.TransportChannelFeature[]{ITransportChannel.TransportChannelFeature.openAsync, ITransportChannel.TransportChannelFeature.close, ITransportChannel.TransportChannelFeature.closeAync, ITransportChannel.TransportChannelFeature.sendRequest, ITransportChannel.TransportChannelFeature.sendRequestAsync});
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.rk = string;
        this.securityPolicyUri = transportChannelSettings.getDescription().getSecurityPolicyUri();
        this.rj = transportChannelSettings;
        HttpsSettings httpsSettings = transportChannelSettings.getHttpsSettings();
        this.rl = httpsSettings.getHttpsSecurityPolicies();
        if (this.rl == null || this.rl.length == 0) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "No HttpsSecurityPolicies defined");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initialize: url={}; settings={}", (Object)transportChannelSettings.getDescription().getEndpointUrl(), (Object)ObjectUtils.printFields(transportChannelSettings));
        }
        EndpointConfiguration endpointConfiguration = transportChannelSettings.getConfiguration();
        this.ru = encoderContext;
        this.ru.setMaxArrayLength(endpointConfiguration.getMaxArrayLength() != null ? endpointConfiguration.getMaxArrayLength() : 0);
        this.ru.setMaxStringLength(endpointConfiguration.getMaxStringLength() != null ? endpointConfiguration.getMaxStringLength() : 0);
        this.ru.setMaxByteStringLength(endpointConfiguration.getMaxByteStringLength() != null ? endpointConfiguration.getMaxByteStringLength() : 0);
        this.ru.setMaxMessageSize(endpointConfiguration.getMaxMessageSize() != null ? endpointConfiguration.getMaxMessageSize() : 0);
        this.rs = TimerUtil.getTimer();
        try {
            X509HostnameVerifier x509HostnameVerifier;
            SSLContext sSLContext;
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            if (this.protocol.equals("opc.https")) {
                try {
                    sSLContext = SSLContext.getInstance("TLSv1.2");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    logger.debug("No TLSv1.2 implementation found, trying TLS");
                    sSLContext = SSLContext.getInstance("TLS");
                }
                sSLContext.init(httpsSettings.getKeyManagers(), httpsSettings.getTrustManagers(), null);
                x509HostnameVerifier = httpsSettings.getHostnameVerifier() != null ? httpsSettings.getHostnameVerifier() : SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(sSLContext, x509HostnameVerifier){

                    protected void prepareSocket(SSLSocket sSLSocket) throws IOException {
                        sSLSocket.setEnabledCipherSuites(HttpsClient.this.rw);
                    }
                };
                SSLEngine sSLEngine = sSLContext.createSSLEngine();
                Object[] objectArray = sSLEngine.getEnabledCipherSuites();
                HashSet<String> hashSet = new HashSet<String>();
                for (HttpsSecurityPolicy httpsSecurityPolicy : this.rl) {
                    for (String string2 : httpsSecurityPolicy.getCipherSuites()) {
                        hashSet.add(string2);
                    }
                }
                this.rw = CryptoUtil.filterCipherSuiteList((String[])objectArray, hashSet.toArray(new String[0]));
                logger.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(sSLEngine.getEnabledProtocols()));
                logger.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(objectArray));
                logger.info("Client CipherSuite selection for {} is {}", (Object)Arrays.toString((Object[])this.rl), (Object)Arrays.toString(this.rw));
                Scheme scheme = new Scheme("opc.https", 443, (SchemeSocketFactory)sSLSocketFactory);
                schemeRegistry.register(scheme);
            }
            if (this.protocol.equals("http")) {
                sSLContext = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
                schemeRegistry.register((Scheme)sSLContext);
            }
            if (this.rn == null) {
                sSLContext = new PoolingClientConnectionManager(schemeRegistry);
                this.rn = sSLContext;
                sSLContext.setMaxTotal(this.ro);
                sSLContext.setDefaultMaxPerRoute(this.ro);
            }
            sSLContext = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)sSLContext, (int)this.rj.getConfiguration().getOperationTimeout());
            HttpConnectionParams.setSoTimeout((HttpParams)sSLContext, (int)0);
            this.rp = new DefaultHttpClient(this.rn, (HttpParams)sSLContext);
            if (httpsSettings.getUsername() != null && httpsSettings.getPassword() != null) {
                x509HostnameVerifier = new BasicCredentialsProvider();
                x509HostnameVerifier.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(httpsSettings.getUsername(), httpsSettings.getPassword()));
                this.rp.setCredentialsProvider((CredentialsProvider)x509HostnameVerifier);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            new ServiceResultException(noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            new ServiceResultException(keyManagementException);
        }
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceResultException {
        return this.serviceRequest(serviceRequest, this.b(serviceRequest));
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest, long l2) throws ServiceResultException {
        AsyncResult<T> asyncResult = this.serviceRequestAsync(serviceRequest);
        return (T)((ServiceResponse)asyncResult.waitForResult(l2, TimeUnit.MILLISECONDS));
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        return this.serviceRequestAsync(serviceRequest, this.b(serviceRequest));
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest, long l2) {
        return this.serviceRequestAsync(serviceRequest, l2, -1);
    }

    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest, long l2, int n2) {
        a<T> a2 = new a<T>(this, serviceRequest);
        a2.re = n2;
        a2.rF = this.securityPolicyUri;
        a2.requestId = this.ri.getAndIncrement();
        logger.debug("serviceRequestAsync: Sending message, requestId={} message={} operationTimeout={}", new Object[]{a2.requestId, serviceRequest.getClass().getSimpleName(), l2});
        logger.trace("serviceRequestAsync: message={}", serviceRequest);
        this.rr.put(a2.requestId, a2);
        if (a2.gO != 0L) {
            this.aPM();
        }
        this.executor.execute(a2);
        return a2.rB;
    }

    public void setClientConnectionManager(ClientConnectionManager clientConnectionManager) {
        this.rn = clientConnectionManager;
    }

    public void setMaxConnections(int n2) {
        this.ro = n2;
    }

    @Override
    public void setOperationTimeout(int n2) {
        this.rj.getConfiguration().setOperationTimeout(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private a aPK() {
        long l2 = Long.MAX_VALUE;
        a a2 = null;
        Map<Integer, a> map = this.rr;
        synchronized (map) {
            for (a a3 : this.rr.values()) {
                if (l2 <= a3.rA) continue;
                l2 = a3.rA;
                a2 = a3;
                break;
            }
        }
        return a2;
    }

    private void aPL() {
        TimerTask timerTask = this.rt.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    private void aPM() {
        a a2 = this.aPK();
        if (a2 == null) {
            this.aPL();
        } else {
            TimerTask timerTask = this.rt.get();
            if (timerTask == null || timerTask.scheduledExecutionTime() > a2.rA) {
                this.aPL();
                timerTask = TimerUtil.schedule(this.rs, this.rx, this.executor, a2.rA);
                if (!this.rt.compareAndSet(null, timerTask)) {
                    timerTask.cancel();
                }
            }
        }
    }

    long b(ServiceRequest serviceRequest) {
        long l2;
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l3 = l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)this.getOperationTimeout();
        if (l2 == 0L) {
            l2 = 100000L;
        }
        return l2;
    }
}

