/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.endpoint;

import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.security.SecurityMode;

public abstract class EndpointServiceRequest<Request extends ServiceRequest<Response>, Response extends ServiceResponse> {
    protected Server server;
    protected Endpoint endpoint;
    protected Request request;
    protected DateTime receiveTimestamp;

    public EndpointServiceRequest(Request Request, Server server, Endpoint endpoint) {
        this.request = Request;
        this.server = server;
        this.endpoint = endpoint;
        this.receiveTimestamp = DateTime.currentTime();
    }

    public abstract ServerSecureChannel getChannel();

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public DateTime getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public Request getRequest() {
        return this.request;
    }

    public abstract SecurityMode getSecurityMode();

    public Server getServer() {
        return this.server;
    }

    public void sendException(Throwable throwable) {
        this.sendResponse(new AsyncWrite(ServiceFaultException.toServiceFault(throwable)));
    }

    public void sendFault(ServiceFault serviceFault) {
        this.sendResponse(new AsyncWrite(serviceFault));
    }

    public abstract void sendResponse(AsyncWrite var1);

    public abstract AsyncWrite sendResponse(Response var1);
}

