/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class TransportChannelSettings
implements Cloneable {
    EndpointDescription qZ;
    EndpointConfiguration ra;
    NamespaceTable rb;
    OpcTcpSettings or = new OpcTcpSettings();
    HttpsSettings eo = new HttpsSettings();

    public TransportChannelSettings() {
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, Cert cert, PrivKey privKey, CertificateValidator certificateValidator, NamespaceTable namespaceTable) throws RuntimeServiceResultException {
        this.ra = endpointConfiguration;
        this.qZ = endpointDescription;
        this.or.setClientCertificate(cert);
        this.or.setCertificateValidator(certificateValidator);
        this.or.setPrivKey(privKey);
        if (namespaceTable != null) {
            this.rb = namespaceTable;
        }
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, KeyPair keyPair, CertificateValidator certificateValidator, X509HostnameVerifier x509HostnameVerifier) throws RuntimeServiceResultException {
        this.ra = endpointConfiguration;
        this.qZ = endpointDescription;
        this.eo.setKeyPair(keyPair, new Cert[0]);
        this.eo.setCertificateValidator(certificateValidator);
        this.eo.setHostnameVerifier(x509HostnameVerifier);
    }

    public TransportChannelSettings clone() {
        TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
        if (this.qZ != null) {
            transportChannelSettings.setDescription(this.qZ.clone());
        }
        if (this.ra != null) {
            transportChannelSettings.setConfiguration(this.ra.clone());
        }
        if (this.or != null) {
            transportChannelSettings.or = this.or.clone();
        }
        if (this.eo != null) {
            transportChannelSettings.eo = this.eo.clone();
        }
        if (this.rb != null) {
            transportChannelSettings.setNamespaceUris(this.rb);
        }
        return transportChannelSettings;
    }

    public EndpointConfiguration getConfiguration() {
        return this.ra;
    }

    public EndpointDescription getDescription() {
        return this.qZ;
    }

    public HttpsSettings getHttpsSettings() {
        return this.eo;
    }

    public NamespaceTable getNamespaceUris() {
        return this.rb;
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.or;
    }

    public Cert getServerCertificate() {
        try {
            if (this.qZ != null && this.qZ.getServerCertificate() != null && this.qZ.getServerCertificate().getLength() > 0) {
                return new Cert(ByteString.asByteArray(this.qZ.getServerCertificate()));
            }
            return null;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    public void readFrom(TransportChannelSettings transportChannelSettings) {
        if (transportChannelSettings.qZ != null) {
            this.qZ = transportChannelSettings.qZ.clone();
        }
        if (transportChannelSettings.ra != null) {
            this.ra = transportChannelSettings.ra.clone();
        }
        if (transportChannelSettings.or != null) {
            this.or.readFrom(transportChannelSettings.or);
        }
        if (transportChannelSettings.eo != null) {
            this.eo.readFrom(transportChannelSettings.eo);
        }
        if (transportChannelSettings.rb != null) {
            this.rb = transportChannelSettings.rb;
        }
    }

    public void setConfiguration(EndpointConfiguration endpointConfiguration) {
        this.ra = endpointConfiguration;
    }

    public void setDescription(EndpointDescription endpointDescription) {
        this.qZ = endpointDescription;
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.eo = httpsSettings;
    }

    public void setNamespaceUris(NamespaceTable namespaceTable) {
        this.rb = namespaceTable;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.or = opcTcpSettings;
    }
}

