/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport;

import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.ObjectUtils;
import java.net.URI;
import java.util.Arrays;

public class Endpoint {
    SecurityMode[] qX;
    String endpointUrl;
    private int hash;
    EndpointConfiguration em;

    public static EndpointConfiguration createDefaultEndpointConfiguration() {
        EndpointConfiguration endpointConfiguration = new EndpointConfiguration();
        endpointConfiguration.setOperationTimeout(120000);
        endpointConfiguration.setUseBinaryEncoding(true);
        endpointConfiguration.setMaxArrayLength(UnsignedShort.MAX_VALUE.intValue());
        endpointConfiguration.setMaxByteStringLength(UnsignedShort.MAX_VALUE.intValue() * 16);
        endpointConfiguration.setMaxMessageSize(UnsignedShort.MAX_VALUE.intValue() * 64);
        endpointConfiguration.setMaxStringLength(UnsignedShort.MAX_VALUE.intValue());
        endpointConfiguration.setMaxBufferSize(UnsignedShort.MAX_VALUE.intValue());
        endpointConfiguration.setChannelLifetime(120000);
        endpointConfiguration.setSecurityTokenLifetime(3600000);
        return endpointConfiguration;
    }

    public Endpoint(String string, SecurityMode ... securityModeArray) {
        if (securityModeArray == null || string == null) {
            throw new IllegalArgumentException("null arg");
        }
        for (SecurityMode securityMode : securityModeArray) {
            if (securityMode == null) {
                throw new IllegalArgumentException("null arg");
            }
            this.hash = 13 * this.hash + securityMode.hashCode();
        }
        this.endpointUrl = string;
        this.qX = securityModeArray;
        this.em = Endpoint.createDefaultEndpointConfiguration();
        this.hash = 13 * this.hash + string.hashCode();
    }

    public Endpoint(URI uRI, SecurityMode ... securityModeArray) {
        if (securityModeArray == null || uRI == null) {
            throw new IllegalArgumentException("null arg");
        }
        for (SecurityMode securityMode : securityModeArray) {
            if (securityMode == null) {
                throw new IllegalArgumentException("null arg");
            }
            this.hash = 13 * this.hash + securityMode.hashCode();
        }
        this.endpointUrl = uRI.toString();
        this.qX = securityModeArray;
        this.em = Endpoint.createDefaultEndpointConfiguration();
        this.hash = 13 * this.hash + uRI.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)object;
        if (!ObjectUtils.objectEquals(endpoint.getEndpointUrl(), this.getEndpointUrl())) {
            return false;
        }
        return Arrays.deepEquals(this.qX, endpoint.qX);
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.em;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public SecurityMode[] getSecurityModes() {
        return this.qX;
    }

    public int hashCode() {
        return this.hash;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.em = endpointConfiguration;
    }

    public boolean supportsSecurityMode(SecurityMode securityMode) {
        for (SecurityMode securityMode2 : this.qX) {
            if (!securityMode2.equals(securityMode)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsSecurityPolicy(SecurityPolicy securityPolicy) {
        for (SecurityMode securityMode : this.qX) {
            if (!securityMode.getSecurityPolicy().equals((Object)securityPolicy)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.endpointUrl + " " + Arrays.toString(this.qX);
    }
}

