/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.xml;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.UriTable;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDecoder
implements IDecoder {
    private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String EMPTY_STRING = "";
    private static final String qQ = "http://opcfoundation.org/UA/2008/02/Types.xsd";
    static Logger logger = LoggerFactory.getLogger(XmlDecoder.class);
    private XMLStreamReader reader;
    private NamespaceTable namespaceTable;
    private ServerTable serverTable;
    private EncoderContext hB;
    private UnsignedShort[] qR;
    private UnsignedShort[] qS;

    public XmlDecoder(XmlElement xmlElement, EncoderContext encoderContext) throws DecodingException {
        if (encoderContext == null) {
            throw new NullPointerException("context");
        }
        this.initialize();
        try {
            this.reader = XMLFactoryCache.getXMLInputFactory().createXMLStreamReader(new StringReader(xmlElement.toString()));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
        this.hB = encoderContext;
    }

    public XmlDecoder(XMLStreamReader xMLStreamReader, EncoderContext encoderContext) throws DecodingException {
        if (encoderContext == null) {
            throw new NullPointerException("context");
        }
        this.initialize();
        this.reader = xMLStreamReader;
        this.hB = encoderContext;
    }

    public void close() throws DecodingException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
    }

    public void close(boolean bl) throws DecodingException {
        if (bl && this.reader.getEventType() != 8) {
            this.getEndElement();
        }
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
    }

    @Override
    public <T> T get(String string, Class<T> clazz) throws DecodingException {
        if (clazz.equals(Boolean.class)) {
            return (T)this.getBoolean(string);
        }
        if (clazz.equals(Byte.class)) {
            return (T)this.getSByte(string);
        }
        if (clazz.equals(UnsignedByte.class)) {
            return (T)this.getByte(string);
        }
        if (clazz.equals(Short.class)) {
            return (T)this.getInt16(string);
        }
        if (clazz.equals(UnsignedShort.class)) {
            return (T)this.getUInt16(string);
        }
        if (clazz.equals(Integer.class)) {
            return (T)this.getInt32(string);
        }
        if (clazz.equals(UnsignedInteger.class)) {
            return (T)this.getUInt32(string);
        }
        if (clazz.equals(Long.class)) {
            return (T)this.getInt64(string);
        }
        if (clazz.equals(UnsignedLong.class)) {
            return (T)this.getUInt64(string);
        }
        if (clazz.equals(Float.class)) {
            return (T)this.getFloat(string);
        }
        if (clazz.equals(Double.class)) {
            return (T)this.getDouble(string);
        }
        if (clazz.equals(String.class)) {
            return (T)this.getString(string);
        }
        if (clazz.equals(DateTime.class)) {
            return (T)this.getDateTime(string);
        }
        if (clazz.equals(UUID.class)) {
            return (T)this.getGuid(string);
        }
        if (clazz.equals(ByteString.class)) {
            return (T)this.getByteString(string);
        }
        if (clazz.equals(XmlElement.class)) {
            return (T)this.getXmlElement(string);
        }
        if (clazz.equals(NodeId.class)) {
            return (T)this.getNodeId(string);
        }
        if (clazz.equals(ExpandedNodeId.class)) {
            return (T)this.getExpandedNodeId(string);
        }
        if (clazz.equals(StatusCode.class)) {
            return (T)this.getStatusCode(string);
        }
        if (clazz.equals(QualifiedName.class)) {
            return (T)this.getQualifiedName(string);
        }
        if (clazz.equals(LocalizedText.class)) {
            return (T)this.getLocalizedText(string);
        }
        if (clazz.equals(ExtensionObject.class)) {
            return (T)this.getExtensionObject(string);
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return this.getEncodeable(string, clazz);
        }
        if (clazz.equals(DataValue.class)) {
            return (T)this.getDataValue(string);
        }
        if (clazz.equals(Variant.class)) {
            return (T)this.getVariant(string);
        }
        if (clazz.equals(Object.class)) {
            return (T)this.getVariant(string).getValue();
        }
        if (clazz.equals(DiagnosticInfo.class)) {
            return (T)this.getDiagnosticInfo(string);
        }
        if (clazz.equals(Boolean[].class)) {
            return (T)this.getBooleanArray(string);
        }
        if (clazz.equals(Byte[].class)) {
            return (T)this.getSByteArray(string);
        }
        if (clazz.equals(UnsignedByte[].class)) {
            return (T)this.getByteArray(string);
        }
        if (clazz.equals(Short[].class)) {
            return (T)this.getInt16Array(string);
        }
        if (clazz.equals(UnsignedShort[].class)) {
            return (T)this.getUInt16Array(string);
        }
        if (clazz.equals(Integer[].class)) {
            return (T)this.getInt32Array(string);
        }
        if (clazz.equals(UnsignedInteger[].class)) {
            return (T)this.getUInt32Array(string);
        }
        if (clazz.equals(Long[].class)) {
            return (T)this.getInt64Array(string);
        }
        if (clazz.equals(UnsignedLong[].class)) {
            return (T)this.getUInt64Array(string);
        }
        if (clazz.equals(Float[].class)) {
            return (T)this.getFloatArray(string);
        }
        if (clazz.equals(Double[].class)) {
            return (T)this.getDoubleArray(string);
        }
        if (clazz.equals(String[].class)) {
            return (T)this.getStringArray(string);
        }
        if (clazz.equals(DateTime[].class)) {
            return (T)this.getDateTimeArray(string);
        }
        if (clazz.equals(UUID[].class)) {
            return (T)this.getGuidArray(string);
        }
        if (clazz.equals(ByteString[].class)) {
            return (T)this.getByteStringArray(string);
        }
        if (clazz.equals(XmlElement[].class)) {
            return (T)this.getXmlElementArray(string);
        }
        if (clazz.equals(NodeId[].class)) {
            return (T)this.getNodeIdArray(string);
        }
        if (clazz.equals(ExpandedNodeId[].class)) {
            return (T)this.getExpandedNodeIdArray(string);
        }
        if (clazz.equals(StatusCode[].class)) {
            return (T)this.getStatusCodeArray(string);
        }
        if (clazz.equals(QualifiedName[].class)) {
            return (T)this.getQualifiedNameArray(string);
        }
        if (clazz.equals(LocalizedText[].class)) {
            return (T)this.getLocalizedTextArray(string);
        }
        if (clazz.equals(ExtensionObject[].class)) {
            return (T)this.getExtensionObjectArray(string);
        }
        if (clazz.getComponentType() != null && Structure.class.isAssignableFrom(clazz.getComponentType())) {
            Class<?> clazz2 = clazz.getComponentType();
            Structure[] structureArray = (Structure[])this.getEncodeableArray(string, clazz2);
            return (T)structureArray;
        }
        if (clazz.equals(DataValue[].class)) {
            return (T)this.getDataValueArray(string);
        }
        if (clazz.equals(Variant[].class)) {
            return (T)this.getVariantArray(string);
        }
        if (clazz.equals(Object[].class)) {
            Variant[] variantArray = this.getVariantArray(string);
            Object[] objectArray = new Object[variantArray.length];
            for (int i2 = 0; i2 < variantArray.length; ++i2) {
                objectArray[i2] = variantArray[i2].getValue();
            }
            return (T)objectArray;
        }
        if (clazz.equals(DiagnosticInfo[].class)) {
            return (T)this.getDiagnosticInfoArray(string);
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return this.getEnumeration(string, clazz);
        }
        if (clazz.getComponentType() != null && Enumeration.class.isAssignableFrom(clazz.getComponentType())) {
            return (T)this.getEnumerationArray(string, clazz.getComponentType());
        }
        if (clazz.equals(BigDecimal.class)) {
            return (T)this.s(string);
        }
        if (clazz.equals(BigDecimal[].class)) {
            return (T)this.t(string);
        }
        throw new DecodingException("Cannot decode " + clazz);
    }

    @Override
    public Object getArrayObject(String string, int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.getBooleanArray(null);
            }
            case 2: {
                return this.getSByteArray(null);
            }
            case 3: {
                return this.getByteArray(null);
            }
            case 4: {
                return this.getInt16Array(null);
            }
            case 5: {
                return this.getUInt16Array(null);
            }
            case 6: {
                return this.getInt32Array(null);
            }
            case 7: {
                return this.getUInt32Array(null);
            }
            case 8: {
                return this.getInt64Array(null);
            }
            case 9: {
                return this.getUInt64Array(null);
            }
            case 10: {
                return this.getFloatArray(null);
            }
            case 11: {
                return this.getDoubleArray(null);
            }
            case 12: {
                return this.getStringArray(null);
            }
            case 13: {
                return this.getDateTimeArray(null);
            }
            case 14: {
                return this.getGuidArray(null);
            }
            case 15: {
                return this.getByteStringArray(null);
            }
            case 16: {
                return this.getXmlElementArray(null);
            }
            case 17: {
                return this.getNodeIdArray(null);
            }
            case 18: {
                return this.getExpandedNodeIdArray(null);
            }
            case 19: {
                return this.getStatusCodeArray(null);
            }
            case 20: {
                return this.getQualifiedNameArray(null);
            }
            case 21: {
                return this.getLocalizedTextArray(null);
            }
            case 22: {
                return this.getExtensionObjectArray(null);
            }
            case 23: {
                return this.getDataValueArray(null);
            }
            case 24: {
                return this.getVariantArray(null);
            }
            case 25: {
                return this.getDiagnosticInfoArray(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    @Override
    public Boolean getBoolean(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            boolean bl = Boolean.parseBoolean(string2.toLowerCase());
            this.x(string);
            return bl;
        }
        return false;
    }

    @Override
    public Boolean[] getBooleanArray(String string) throws DecodingException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        if (this.c(string, true)) {
            while (this.y("Boolean")) {
                arrayList.add(this.getBoolean("Boolean"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Boolean[0]);
    }

    @Override
    public UnsignedByte getByte(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            UnsignedByte unsignedByte = UnsignedByte.parseUnsignedByte(string2);
            this.x(string);
            return unsignedByte;
        }
        return UnsignedByte.ZERO;
    }

    @Override
    public UnsignedByte[] getByteArray(String string) throws DecodingException {
        ArrayList<UnsignedByte> arrayList = new ArrayList<UnsignedByte>();
        if (this.c(string, true)) {
            while (this.y("Byte")) {
                arrayList.add(this.getByte("Byte"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new UnsignedByte[0]);
    }

    @Override
    public ByteString getByteString(String string) throws DecodingException {
        if (this.c(string, true)) {
            byte[] byArray = null;
            String string2 = this.aPF();
            byArray = !this.v(string2) ? CryptoUtil.base64Decode(string2) : new byte[]{};
            if (this.hB.getMaxByteStringLength() > 0 && this.hB.getMaxByteStringLength() < byArray.length) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
            return ByteString.valueOf(byArray);
        }
        return null;
    }

    @Override
    public ByteString[] getByteStringArray(String string) throws DecodingException {
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        if (this.c(string, true)) {
            while (this.y("ByteString")) {
                arrayList.add(this.getByteString("ByteString"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new ByteString[0]);
    }

    @Override
    public DataValue getDataValue(String string) throws DecodingException {
        DataValue dataValue = new DataValue();
        if (this.c(string, true)) {
            dataValue.setValue(this.getVariant("Value"));
            dataValue.setStatusCode(this.getStatusCode("StatusCode"));
            dataValue.setSourceTimestamp(this.getDateTime("SourceTimestamp"));
            dataValue.setSourcePicoseconds(this.getUInt16("SourcePicoseconds"));
            dataValue.setServerTimestamp(this.getDateTime("ServerTimestamp"));
            dataValue.setServerPicoseconds(this.getUInt16("ServerPicoseconds"));
            this.x(string);
        }
        return dataValue;
    }

    @Override
    public DataValue[] getDataValueArray(String string) throws DecodingException {
        ArrayList<DataValue> arrayList = new ArrayList<DataValue>();
        if (this.c(string, true)) {
            while (this.y("DataValue")) {
                arrayList.add(this.getDataValue("DataValue"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new DataValue[0]);
    }

    @Override
    public DateTime getDateTime(String string) throws DecodingException {
        if (this.c(string, true)) {
            String string2 = this.getString();
            if (this.hB.getMaxStringLength() > 0 && this.hB.getMaxStringLength() < string2.length()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            if (!this.v(string2)) {
                DateTime dateTime;
                try {
                    dateTime = DateTime.parseDateTime(string2);
                }
                catch (ParseException parseException) {
                    throw new DecodingException(parseException);
                }
                this.x(string);
                return dateTime;
            }
        }
        return DateTime.MIN_VALUE;
    }

    @Override
    public DateTime[] getDateTimeArray(String string) throws DecodingException {
        ArrayList<DateTime> arrayList = new ArrayList<DateTime>();
        if (this.c(string, true)) {
            while (this.y("DateTime")) {
                arrayList.add(this.getDateTime("DateTime"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new DateTime[0]);
    }

    public DiagnosticInfo getDiagnosticInfo() throws DecodingException {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo();
        if (this.c("SymbolicId", true)) {
            diagnosticInfo.setSymbolicId(this.getInt32(null));
            this.x("SymbolicId");
        }
        if (this.c("NamespaceUri", true)) {
            diagnosticInfo.setNamespaceUri(this.getInt32(null));
            this.x("NamespaceUri");
        }
        if (this.c("Locale", true)) {
            diagnosticInfo.setLocale(this.getInt32(null));
            this.x("Locale");
        }
        if (this.c("LocalizedText", true)) {
            diagnosticInfo.setLocalizedText(this.getInt32(null));
            this.x("LocalizedText");
        }
        diagnosticInfo.setAdditionalInfo(this.getString("AdditionalInfo"));
        diagnosticInfo.setInnerStatusCode(this.getStatusCode("InnerStatusCode"));
        if (this.c("InnerDiagnosticInfo", true)) {
            diagnosticInfo.setInnerDiagnosticInfo(this.getDiagnosticInfo());
            this.x("InnerDiagnosticInfo");
        }
        return diagnosticInfo;
    }

    @Override
    public DiagnosticInfo getDiagnosticInfo(String string) throws DecodingException {
        DiagnosticInfo diagnosticInfo = null;
        if (this.c(string, true)) {
            diagnosticInfo = this.getDiagnosticInfo();
            this.x(string);
            return diagnosticInfo;
        }
        return diagnosticInfo;
    }

    @Override
    public DiagnosticInfo[] getDiagnosticInfoArray(String string) throws DecodingException {
        ArrayList<DiagnosticInfo> arrayList = new ArrayList<DiagnosticInfo>();
        if (this.c(string, true)) {
            while (this.y("DiagnosticInfo")) {
                arrayList.add(this.getDiagnosticInfo("DiagnosticInfo"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new DiagnosticInfo[0]);
    }

    @Override
    public Double getDouble(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            double d2 = 0.0;
            if (string2.length() == 3) {
                if (string2 == "NaN") {
                    d2 = Double.NaN;
                }
                if (string2 == "INF") {
                    d2 = Double.POSITIVE_INFINITY;
                }
            }
            if (string2.length() == 4 && string2 == "-INF") {
                d2 = Double.NEGATIVE_INFINITY;
            }
            if (d2 == 0.0) {
                d2 = Double.parseDouble(string2);
            }
            this.x(string);
            return d2;
        }
        return 0.0;
    }

    @Override
    public Double[] getDoubleArray(String string) throws DecodingException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.c(string, true)) {
            while (this.y("Double")) {
                arrayList.add(this.getDouble("Double"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Double[0]);
    }

    @Override
    public <T extends IEncodeable> T getEncodeable(String string, Class<? extends T> clazz) throws DecodingException {
        this.b(string, true);
        IEncodeable iEncodeable = this.hB.getEncodeableSerializer().getEncodeable(clazz, this);
        this.x(string);
        return (T)iEncodeable;
    }

    @Override
    public <T extends IEncodeable> T[] getEncodeableArray(String string, Class<? extends T> clazz) throws DecodingException {
        if (clazz == null) {
            throw new IllegalArgumentException("encodeableClass");
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.c(string, true)) {
            String string2 = clazz.getSimpleName();
            while (this.y(string2)) {
                arrayList.add(this.getEncodeable(string2, clazz));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray((IEncodeable[])Array.newInstance(clazz, arrayList.size()));
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.hB;
    }

    public void getEndElement() throws DecodingException {
        this.aPI();
        if (this.reader.isEndElement()) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        } else {
            throw new DecodingException("Not an end element");
        }
    }

    @Override
    public <T extends Enumeration> T getEnumeration(String string, Class<T> clazz) throws DecodingException {
        Enumeration enumeration = null;
        if (clazz.getEnumConstants() != null && ((Enumeration[])clazz.getEnumConstants()).length > 0) {
            enumeration = ((Enumeration[])clazz.getEnumConstants())[0];
        }
        if (this.c(string, true)) {
            String string2 = this.getString();
            if (!this.v(string2)) {
                int n2 = string2.lastIndexOf(95);
                if (n2 != -1) {
                    int n3 = Integer.parseInt(string2.substring(n2 + 1));
                    try {
                        Method method = clazz.getMethod("valueOf", Integer.TYPE);
                        enumeration = (Enumeration)method.invoke(null, n3);
                    }
                    catch (SecurityException securityException) {
                        throw new DecodingException(securityException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new DecodingException(noSuchMethodException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException(illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new DecodingException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new DecodingException(invocationTargetException);
                    }
                }
                int n4 = Integer.parseInt(string2);
                try {
                    Method method = clazz.getMethod("valueOf", Integer.TYPE);
                    enumeration = (Enumeration)method.invoke(null, n4);
                }
                catch (SecurityException securityException) {
                    throw new DecodingException(securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new DecodingException(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new DecodingException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new DecodingException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new DecodingException(invocationTargetException);
                }
            }
            this.x(string);
        }
        return (T)enumeration;
    }

    @Override
    public <T extends Enumeration> T[] getEnumerationArray(String string, Class<T> clazz) throws DecodingException {
        Object object;
        if (clazz == null) {
            throw new IllegalArgumentException("enumerationClass");
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.c(string, true)) {
            object = clazz.getSimpleName();
            while (this.y((String)object)) {
                arrayList.add(this.getEnumeration((String)object, clazz));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        object = Array.newInstance(clazz, arrayList.size());
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            Array.set(object, i2, arrayList.get(i2));
        }
        return (Enumeration[])object;
    }

    @Override
    public ExpandedNodeId getExpandedNodeId(String string) throws DecodingException {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.NULL;
        if (this.c(string, true)) {
            expandedNodeId = ExpandedNodeId.parseExpandedNodeId(this.getString("Identifier"));
            this.x(string);
        }
        int n2 = expandedNodeId.getNamespaceIndex();
        int n3 = expandedNodeId.getServerIndex().intValue();
        boolean bl = false;
        if (this.qR != null && this.qR.length > expandedNodeId.getNamespaceIndex()) {
            n2 = this.qR[expandedNodeId.getNamespaceIndex()].intValue();
            bl = true;
        }
        if (this.qS != null && this.qS.length > expandedNodeId.getServerIndex().intValue()) {
            n3 = this.qS[expandedNodeId.getServerIndex().intValue()].intValue();
            bl = true;
        }
        if (bl) {
            expandedNodeId = new ExpandedNodeId(UnsignedInteger.valueOf(n3), n2, expandedNodeId.getValue());
        }
        return expandedNodeId;
    }

    @Override
    public ExpandedNodeId[] getExpandedNodeIdArray(String string) throws DecodingException {
        ArrayList<ExpandedNodeId> arrayList = new ArrayList<ExpandedNodeId>();
        if (this.c(string, true)) {
            while (this.y("ExpandedNodeId")) {
                arrayList.add(this.getExpandedNodeId("ExpandedNodeId"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new ExpandedNodeId[0]);
    }

    @Override
    public ExtensionObject getExtensionObject(String string) throws IllegalArgumentException, DecodingException {
        if (!this.c(string, true)) {
            return null;
        }
        NodeId nodeId = this.getNodeId("TypeId");
        ExpandedNodeId expandedNodeId = this.hB.getNamespaceTable().toExpandedNodeId(nodeId);
        if (!NodeId.isNull(nodeId) && ExpandedNodeId.isNull(expandedNodeId)) {
            logger.error("Cannot de-serialized extension objects if the NamespaceUri is not in the NamespaceTable: Type = {}", (Object)nodeId);
        }
        if (!this.c("Body", true)) {
            this.x(string);
            return new ExtensionObject(expandedNodeId, new XmlElement(EMPTY_STRING));
        }
        Object object = this.getExtensionObjectBody(expandedNodeId);
        this.x("Body");
        this.x(string);
        ExtensionObject extensionObject = object instanceof XmlElement ? new ExtensionObject(expandedNodeId, (XmlElement)object) : new ExtensionObject(expandedNodeId, (ByteString)object);
        try {
            if (this.namespaceTable == null) {
                Structure structure = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject(structure);
            }
            Structure structure = (Structure)extensionObject.decode(this.getEncoderContext(), this.namespaceTable);
            return new ExtensionObject(structure);
        }
        catch (DecodingException decodingException) {
            return extensionObject;
        }
    }

    @Override
    public ExtensionObject[] getExtensionObjectArray(String string) throws DecodingException {
        ArrayList<ExtensionObject> arrayList = new ArrayList<ExtensionObject>();
        if (this.c(string, true)) {
            while (this.y("ExtensionObject")) {
                arrayList.add(this.getExtensionObject("ExtensionObject"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new ExtensionObject[0]);
    }

    public Object getExtensionObjectBody(ExpandedNodeId expandedNodeId) throws DecodingException {
        this.aPI();
        if (this.reader.getLocalName() == "ByteString" && this.reader.getNamespaceURI() == qQ) {
            ByteString byteString = this.getByteString("ByteString");
            return byteString;
        }
        return this.getXmlElement(EMPTY_STRING);
    }

    @Override
    public Float getFloat(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            float f2 = 0.0f;
            if (string2.length() == 3) {
                if (string2 == "NaN") {
                    f2 = Float.NaN;
                }
                if (string2 == "INF") {
                    f2 = Float.POSITIVE_INFINITY;
                }
            }
            if (string2.length() == 4 && string2 == "-INF") {
                f2 = Float.NEGATIVE_INFINITY;
            }
            if (f2 == 0.0f) {
                f2 = Float.parseFloat(string2);
            }
            this.x(string);
            return Float.valueOf(f2);
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public Float[] getFloatArray(String string) throws DecodingException {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        if (this.c(string, true)) {
            while (this.y("Float")) {
                arrayList.add(this.getFloat("Float"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Float[0]);
    }

    @Override
    public UUID getGuid(String string) throws DecodingException {
        String string2 = null;
        if (this.c(string, true)) {
            string2 = this.getString("String");
            this.x(string);
        }
        return UUID.fromString(string2);
    }

    @Override
    public UUID[] getGuidArray(String string) throws DecodingException {
        ArrayList<UUID> arrayList = new ArrayList<UUID>();
        if (this.c(string, true)) {
            while (this.y("Guid")) {
                arrayList.add(this.getGuid("Guid"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new UUID[0]);
    }

    @Override
    public Short getInt16(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            short s2 = Short.parseShort(string2);
            this.x(string);
            return s2;
        }
        return (short)0;
    }

    @Override
    public Short[] getInt16Array(String string) throws DecodingException {
        ArrayList<Short> arrayList = new ArrayList<Short>();
        if (this.c(string, true)) {
            while (this.y("Int16")) {
                arrayList.add(this.getInt16("Int16"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Short[0]);
    }

    @Override
    public Integer getInt32(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            int n2 = Integer.parseInt(string2);
            this.x(string);
            return n2;
        }
        return 0;
    }

    @Override
    public Integer[] getInt32Array(String string) throws DecodingException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.c(string, true)) {
            while (this.y("Int32")) {
                arrayList.add(this.getInt32("Int32"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Integer[0]);
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.c(string, true)) {
            while (this.y("Int32")) {
                arrayList.add(this.getInt32("Int32"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
            int[] nArray = new int[arrayList.size()];
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                nArray[i2] = (Integer)arrayList.get(i2);
            }
            return nArray;
        }
        return new int[0];
    }

    @Override
    public Long getInt64(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            long l2 = Long.parseLong(string2);
            this.x(string);
            return l2;
        }
        return 0L;
    }

    @Override
    public Long[] getInt64Array(String string) throws DecodingException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (this.c(string, true)) {
            while (this.y("Int64")) {
                arrayList.add(this.getInt64("Int64"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Long[0]);
    }

    @Override
    public LocalizedText getLocalizedText(String string) throws DecodingException {
        if (this.c(string, true)) {
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            if (this.c("Locale", true)) {
                string3 = this.getString(null);
                this.x("Locale");
            } else if (!bl) {
                string3 = EMPTY_STRING;
            }
            if (this.c("Text", true)) {
                string2 = this.getString(null);
                this.x("Text");
            } else if (!bl) {
                string2 = EMPTY_STRING;
            }
            LocalizedText localizedText = new LocalizedText(string2, string3);
            this.x(string);
            return localizedText;
        }
        return LocalizedText.NULL;
    }

    @Override
    public LocalizedText[] getLocalizedTextArray(String string) throws DecodingException {
        ArrayList<LocalizedText> arrayList = new ArrayList<LocalizedText>();
        if (this.c(string, true)) {
            while (this.y("LocalizedText")) {
                arrayList.add(this.getLocalizedText("LocalizedText"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new LocalizedText[0]);
    }

    public Object getMatrix(String string) throws DecodingException {
        if (this.c(string, true)) {
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
            int[] nArray = this.getInt32Array_("Dimensions");
            if (this.c("Elements", true)) {
                try {
                    this.reader.next();
                }
                catch (XMLStreamException xMLStreamException) {
                    logger.error(xMLStreamException.getMessage());
                }
                while (this.reader.getEventType() != 2) {
                    Object object = null;
                    String string2 = this.reader.getLocalName();
                    if (string2.equals("Boolean")) {
                        object = this.getBoolean(string2);
                    } else if (string2.equals("SByte")) {
                        object = this.getSByte(string2);
                    } else if (string2.equals("Byte")) {
                        object = this.getByte(string2);
                    } else if (string2.equals("Int16")) {
                        object = this.getInt16(string2);
                    } else if (string2.equals("UInt16")) {
                        object = this.getUInt16(string2);
                    } else if (string2.equals("Int32")) {
                        object = this.getInt32(string2);
                    } else if (string2.equals("UInt32")) {
                        object = this.getUInt32(string2);
                    } else if (string2.equals("Int64")) {
                        object = this.getInt64(string2);
                    } else if (string2.equals("UInt64")) {
                        object = this.getUInt64(string2);
                    } else if (string2.equals("Float")) {
                        object = this.getFloat(string2);
                    } else if (string2.equals("Double")) {
                        object = this.getDouble(string2);
                    } else if (string2.equals("String")) {
                        object = this.getString(string2);
                    } else if (string2.equals("DateTime")) {
                        object = this.getDateTime(string2);
                    } else if (string2.equals("Guid")) {
                        object = this.getGuid(string2);
                    } else if (string2.equals("ByteString")) {
                        object = this.getByteString(string2);
                    } else if (string2.equals("XmlElement")) {
                        object = this.getXmlElement(string2);
                    } else if (string2.equals("NodeId")) {
                        object = this.getNodeId(string2);
                    } else if (string2.equals("ExpandedNodeId")) {
                        object = this.getExpandedNodeId(string2);
                    } else if (string2.equals("StatusCode")) {
                        object = this.getStatusCode(string2);
                    } else if (string2.equals("DiagnosticInfo")) {
                        object = this.getDiagnosticInfo(string2);
                    } else if (string2.equals("QualifiedName")) {
                        object = this.getQualifiedName(string2);
                    } else if (string2.equals("LocalizedText")) {
                        object = this.getLocalizedText(string2);
                    } else if (string2.equals("ExtensionObject")) {
                        ExtensionObject extensionObject = this.getExtensionObject(string2);
                        try {
                            object = this.b(extensionObject);
                        }
                        catch (DecodingException decodingException) {
                            logger.debug("Failed to decode ExtensionObject: " + decodingException.getMessage());
                            object = extensionObject;
                        }
                    } else if (string2.equals("DataValue")) {
                        object = this.getDataValue(string2);
                    } else if (string2.equals("Variant")) {
                        object = this.getVariant(string2);
                    }
                    arrayList.add((Boolean)object);
                    try {
                        this.reader.next();
                    }
                    catch (XMLStreamException xMLStreamException) {
                        logger.error(xMLStreamException.getMessage());
                    }
                }
                this.x("Elements");
            }
            this.x(string);
            if (MultiDimensionArrayUtils.getLength(nArray) != arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_DecodingError);
            }
            return MultiDimensionArrayUtils.demuxArray((Object)arrayList.toArray(), nArray, arrayList.get(0).getClass());
        }
        return null;
    }

    @Override
    public <T extends IEncodeable> T getMessage() throws DecodingException {
        NodeId nodeId = this.getNodeId(null);
        if (nodeId == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        Class<? extends IEncodeable> clazz = this.hB.getEncodeableClass(nodeId);
        if (clazz == null) {
            throw new DecodingException("Cannot decode " + nodeId);
        }
        return (T)this.hB.getEncodeableSerializer().getEncodeable(clazz, this);
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    @Override
    public NodeId getNodeId(String string) throws IllegalArgumentException, DecodingException {
        NodeId nodeId = null;
        if (this.c(string, true)) {
            nodeId = NodeId.parseNodeId(this.getString("Identifier"));
            this.x(string);
        }
        if (this.qR != null && this.qR.length > nodeId.getNamespaceIndex()) {
            nodeId = NodeId.get(nodeId.getIdType(), this.qR[nodeId.getNamespaceIndex()].intValue(), nodeId.getValue());
        }
        return nodeId;
    }

    @Override
    public NodeId[] getNodeIdArray(String string) throws DecodingException {
        ArrayList<NodeId> arrayList = new ArrayList<NodeId>();
        if (this.c(string, true)) {
            while (this.y("NodeId")) {
                arrayList.add(this.getNodeId("NodeId"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new NodeId[0]);
    }

    @Override
    public QualifiedName getQualifiedName(String string) throws DecodingException {
        if (this.c(string, true)) {
            UnsignedShort unsignedShort = UnsignedShort.ZERO;
            if (this.c("NamespaceIndex", true)) {
                unsignedShort = this.getUInt16(null);
                this.x("NamespaceIndex");
            }
            String string2 = null;
            if (this.c("Name", true)) {
                string2 = this.getString(null);
                this.x("Name");
            }
            this.x(string);
            if (this.qR != null && this.qR.length > unsignedShort.getValue()) {
                unsignedShort = this.qR[unsignedShort.getValue()];
            }
            return new QualifiedName(unsignedShort, string2);
        }
        return QualifiedName.NULL;
    }

    @Override
    public QualifiedName[] getQualifiedNameArray(String string) throws DecodingException {
        ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
        if (this.c(string, true)) {
            while (this.y("QualifiedName")) {
                arrayList.add(this.getQualifiedName("QualifiedName"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new QualifiedName[0]);
    }

    @Override
    public Byte getSByte(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            byte by = Byte.parseByte(string2);
            this.x(string);
            return by;
        }
        return (byte)0;
    }

    @Override
    public Byte[] getSByteArray(String string) throws DecodingException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        if (this.c(string, true)) {
            while (this.y("SByte")) {
                arrayList.add(this.getSByte("SByte"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Byte[0]);
    }

    @Override
    public Object getScalarObject(String string, int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.getBoolean(null);
            }
            case 2: {
                return this.getSByte(null);
            }
            case 3: {
                return this.getByte(null);
            }
            case 4: {
                return this.getInt16(null);
            }
            case 5: {
                return this.getUInt16(null);
            }
            case 6: {
                return this.getInt32(null);
            }
            case 7: {
                return this.getUInt32(null);
            }
            case 8: {
                return this.getInt64(null);
            }
            case 9: {
                return this.getUInt64(null);
            }
            case 10: {
                return this.getFloat(null);
            }
            case 11: {
                return this.getDouble(null);
            }
            case 12: {
                return this.getString(null);
            }
            case 13: {
                return this.getDateTime(null);
            }
            case 14: {
                return this.getGuid(null);
            }
            case 15: {
                return this.getByteString(null);
            }
            case 16: {
                return this.getXmlElement(null);
            }
            case 17: {
                return this.getNodeId(null);
            }
            case 18: {
                return this.getExpandedNodeId(null);
            }
            case 19: {
                return this.getStatusCode(null);
            }
            case 20: {
                return this.getQualifiedName(null);
            }
            case 21: {
                return this.getLocalizedText(null);
            }
            case 22: {
                return this.getExtensionObject(null);
            }
            case 23: {
                return this.getDataValue(null);
            }
            case 24: {
                return this.getVariant(null);
            }
            case 25: {
                return this.getDiagnosticInfo(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public void getStartElement() throws DecodingException {
        if (this.reader.isStartElement()) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
    }

    @Override
    public StatusCode getStatusCode(String string) throws DecodingException {
        StatusCode statusCode = StatusCode.getFromBits(0);
        if (this.c(string, true)) {
            statusCode = new StatusCode(this.getUInt32("Code"));
            this.x(string);
        }
        return statusCode;
    }

    @Override
    public StatusCode[] getStatusCodeArray(String string) throws DecodingException {
        ArrayList<StatusCode> arrayList = new ArrayList<StatusCode>();
        if (this.c(string, true)) {
            while (this.y("StatusCode")) {
                arrayList.add(this.getStatusCode("StatusCode"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new StatusCode[0]);
    }

    @Override
    public String getString(String string) throws DecodingException {
        if (this.c(string, true)) {
            String string2 = this.getString();
            if (string2 != null) {
                string2 = string2.trim();
            }
            this.x(string);
            return string2;
        }
        return null;
    }

    @Override
    public String[] getStringArray(String string) throws DecodingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.c(string, true)) {
            while (this.y("String")) {
                arrayList.add(this.getString("String"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public Structure getStructure(String string) throws DecodingException {
        NodeId nodeId = this.getNodeId(null);
        Class<? extends IEncodeable> clazz = this.hB.getEncodeableClass(nodeId);
        return (Structure)this.getEncodeable(string, clazz);
    }

    @Override
    public Structure[] getStructureArray(String string) throws DecodingException {
        ArrayList<Structure> arrayList = new ArrayList<Structure>();
        if (this.c(string, true)) {
            while (this.y("Structure")) {
                arrayList.add(this.getStructure(null));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Structure[0]);
    }

    @Override
    public UnsignedShort getUInt16(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            UnsignedShort unsignedShort = UnsignedShort.parseUnsignedShort(string2);
            this.x(string);
            return unsignedShort;
        }
        return UnsignedShort.ZERO;
    }

    @Override
    public UnsignedShort[] getUInt16Array(String string) throws DecodingException {
        ArrayList<UnsignedShort> arrayList = new ArrayList<UnsignedShort>();
        if (this.c(string, true)) {
            while (this.y("UInt16")) {
                arrayList.add(this.getUInt16("UInt16"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new UnsignedShort[0]);
    }

    @Override
    public UnsignedInteger getUInt32(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            UnsignedInteger unsignedInteger = UnsignedInteger.parseUnsignedInteger(string2);
            this.x(string);
            return unsignedInteger;
        }
        return UnsignedInteger.ZERO;
    }

    @Override
    public UnsignedInteger[] getUInt32Array(String string) throws DecodingException {
        ArrayList<UnsignedInteger> arrayList = new ArrayList<UnsignedInteger>();
        if (this.c(string, true)) {
            while (this.y("UInt32")) {
                arrayList.add(this.getUInt32("UInt32"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new UnsignedInteger[0]);
    }

    @Override
    public UnsignedLong getUInt64(String string) throws DecodingException {
        String string2;
        if (this.c(string, true) && !this.v(string2 = this.getString())) {
            UnsignedLong unsignedLong = UnsignedLong.parseUnsignedLong(string2);
            this.x(string);
            return unsignedLong;
        }
        return UnsignedLong.valueOf(0L);
    }

    @Override
    public UnsignedLong[] getUInt64Array(String string) throws DecodingException {
        ArrayList<UnsignedLong> arrayList = new ArrayList<UnsignedLong>();
        if (this.c(string, true)) {
            while (this.y("UInt64")) {
                arrayList.add(this.getUInt64("UInt64"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new UnsignedLong[0]);
    }

    @Override
    public Variant getVariant(String string) throws DecodingException {
        Variant variant = new Variant(null);
        if (this.c(string, true)) {
            if (this.c("Value", true)) {
                Object object = this.getVariantContents();
                variant = new Variant(object);
                this.x("Value");
            }
            if (!this.v(string)) {
                this.x(string);
            }
        }
        return variant;
    }

    @Override
    public Variant[] getVariantArray(String string) throws DecodingException {
        ArrayList<Variant> arrayList = new ArrayList<Variant>();
        if (this.c(string, true)) {
            while (this.y("Variant")) {
                arrayList.add(this.getVariant("Variant"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new Variant[0]);
    }

    public Object getVariantContents() throws DecodingException {
        while (this.reader.getEventType() != 1) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
        String string = this.reader.getLocalName();
        if (string.startsWith("ListOf")) {
            String string2 = string.substring("ListOf".length());
            if (string2.equals("Boolean")) {
                return this.getBooleanArray(string);
            }
            if (string2.equals("SByte")) {
                return this.getSByteArray(string);
            }
            if (string2.equals("Byte")) {
                return this.getByteArray(string);
            }
            if (string2.equals("Int16")) {
                return this.getInt16Array(string);
            }
            if (string2.equals("UInt16")) {
                return this.getUInt16Array(string);
            }
            if (string2.equals("Int32")) {
                return this.getInt32Array(string);
            }
            if (string2.equals("UInt32")) {
                return this.getUInt32Array(string);
            }
            if (string2.equals("Int64")) {
                return this.getInt64Array(string);
            }
            if (string2.equals("UInt64")) {
                return this.getUInt64Array(string);
            }
            if (string2.equals("Float")) {
                return this.getFloatArray(string);
            }
            if (string2.equals("Double")) {
                return this.getDoubleArray(string);
            }
            if (string2.equals("String")) {
                return this.getStringArray(string);
            }
            if (string2.equals("DateTime")) {
                return this.getDateTimeArray(string);
            }
            if (string2.equals("Guid")) {
                return this.getGuidArray(string);
            }
            if (string2.equals("ByteString")) {
                return this.getByteStringArray(string);
            }
            if (string2.equals("XmlElement")) {
                return this.getXmlElementArray(string);
            }
            if (string2.equals("NodeId")) {
                return this.getNodeIdArray(string);
            }
            if (string2.equals("ExpandedNodeId")) {
                return this.getExpandedNodeIdArray(string);
            }
            if (string2.equals("StatusCode")) {
                return this.getStatusCodeArray(string);
            }
            if (string2.equals("DiagnosticInfo")) {
                return this.getDiagnosticInfoArray(string);
            }
            if (string2.equals("QualifiedName")) {
                return this.getQualifiedNameArray(string);
            }
            if (string2.equals("LocalizedText")) {
                return this.getLocalizedTextArray(string);
            }
            if (string2.equals("ExtensionObject")) {
                ExtensionObject[] extensionObjectArray = this.getExtensionObjectArray(string);
                try {
                    return this.decode(extensionObjectArray);
                }
                catch (DecodingException decodingException) {
                    logger.info("Failed to decode ExtensionObjects: " + decodingException.getMessage());
                    return extensionObjectArray;
                }
            }
            if (string2.equals("DataValue")) {
                return this.getDataValueArray(string);
            }
            if (string2.equals("Variant")) {
                return this.getVariantArray(string);
            }
        } else {
            if (string.equals("Null")) {
                if (this.c(string, true)) {
                    this.x(string);
                }
                return null;
            }
            if (string.equals("Boolean")) {
                return this.getBoolean(string);
            }
            if (string.equals("SByte")) {
                return this.getSByte(string);
            }
            if (string.equals("Byte")) {
                return this.getByte(string);
            }
            if (string.equals("Int16")) {
                return this.getInt16(string);
            }
            if (string.equals("UInt16")) {
                return this.getUInt16(string);
            }
            if (string.equals("Int32")) {
                return this.getInt32(string);
            }
            if (string.equals("UInt32")) {
                return this.getUInt32(string);
            }
            if (string.equals("Int64")) {
                return this.getInt64(string);
            }
            if (string.equals("UInt64")) {
                return this.getUInt64(string);
            }
            if (string.equals("Float")) {
                return this.getFloat(string);
            }
            if (string.equals("Double")) {
                return this.getDouble(string);
            }
            if (string.equals("String")) {
                return this.getString(string);
            }
            if (string.equals("DateTime")) {
                return this.getDateTime(string);
            }
            if (string.equals("Guid")) {
                return this.getGuid(string);
            }
            if (string.equals("ByteString")) {
                return this.getByteString(string);
            }
            if (string.equals("XmlElement")) {
                return this.getXmlElement(string);
            }
            if (string.equals("NodeId")) {
                return this.getNodeId(string);
            }
            if (string.equals("ExpandedNodeId")) {
                return this.getExpandedNodeId(string);
            }
            if (string.equals("StatusCode")) {
                return this.getStatusCode(string);
            }
            if (string.equals("DiagnosticInfo")) {
                return this.getDiagnosticInfo(string);
            }
            if (string.equals("QualifiedName")) {
                return this.getQualifiedName(string);
            }
            if (string.equals("LocalizedText")) {
                return this.getLocalizedText(string);
            }
            if (string.equals("ExtensionObject")) {
                ExtensionObject extensionObject = this.getExtensionObject(string);
                try {
                    return this.b(extensionObject);
                }
                catch (DecodingException decodingException) {
                    logger.info("Failed to decode ExtensionObject: " + decodingException.getMessage());
                    return extensionObject;
                }
            }
            if (string.equals("DataValue")) {
                return this.getDataValue(string);
            }
            if (string.equals("Matrix")) {
                return this.getMatrix(string);
            }
        }
        throw new DecodingException(StatusCodes.Bad_DecodingError, "Element '" + this.reader.getNamespaceURI() + ":" + this.reader.getLocalName() + "' is not allowed in an Variant.");
    }

    @Override
    public XmlElement getXmlElement(String string) throws DecodingException {
        if (this.c(string, true)) {
            return new XmlElement(this.u(EMPTY_STRING));
        }
        return null;
    }

    @Override
    public XmlElement[] getXmlElementArray(String string) throws DecodingException {
        ArrayList<XmlElement> arrayList = new ArrayList<XmlElement>();
        if (this.c(string, true)) {
            while (this.y("XmlElement")) {
                arrayList.add(this.getXmlElement("XmlElement"));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new XmlElement[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStringTable(String string, String string2, List<String> list) throws DecodingException {
        block4: {
            if (this.peek(string)) break block4;
            boolean bl = false;
            return bl;
        }
        this.getStartElement();
        while (this.peek(string2)) {
            String string3 = this.getString(string2);
            list.add(string3);
        }
        this.a(new QName(string, qQ));
        boolean bl = true;
        return bl;
    }

    public QName peek(int n2) {
        this.aPG();
        if (n2 != this.reader.getEventType()) {
            return null;
        }
        return new QName(this.reader.getLocalName(), this.reader.getNamespaceURI());
    }

    public boolean peek(String string) {
        this.aPG();
        if (1 != this.reader.getEventType()) {
            return false;
        }
        String string2 = this.reader.getLocalName();
        return string.equals(string2);
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.hB = encoderContext;
    }

    public void setNamespaceTable(NamespaceTable namespaceTable) {
        this.namespaceTable = namespaceTable;
        this.qR = null;
        if (namespaceTable != null && this.hB.getNamespaceTable() != null) {
            this.qR = this.a(namespaceTable, this.hB.getNamespaceTable(), false);
        }
    }

    public void setServerTable(ServerTable serverTable) {
        this.serverTable = serverTable;
        this.qS = null;
        if (serverTable != null && this.hB.getServerTable() != null) {
            this.qS = this.a(serverTable, this.hB.getServerTable(), false);
        }
    }

    private boolean b(String string, boolean bl) throws DecodingException {
        String string2;
        if (this.v(string)) {
            return true;
        }
        this.aPI();
        if (!this.w(string)) {
            if (!bl) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, String.format("Encountered element: '{1}:{0}' when expecting element: '{2}'.", this.reader.getLocalName(), this.reader.getNamespaceURI(), string));
            }
            return false;
        }
        if (this.reader.getAttributeCount() != 0 && !this.v(string2 = this.reader.getAttributeValue("nil", XML_SCHEMA_INSTANCE)) && Boolean.parseBoolean(string2)) {
            return false;
        }
        this.getStartElement();
        this.aPG();
        if (this.reader.getEventType() == 2 && this.reader.getLocalName() == string) {
            this.getEndElement();
            return false;
        }
        return true;
    }

    private UnsignedShort[] a(UriTable uriTable, UriTable uriTable2, boolean bl) {
        if (uriTable == null) {
            return null;
        }
        UnsignedShort[] unsignedShortArray = new UnsignedShort[uriTable.size()];
        for (int i2 = 0; i2 < uriTable.size(); ++i2) {
            String string = uriTable.getUri(i2);
            int n2 = uriTable2.getIndex(string);
            if (n2 < 0) {
                if (!bl) {
                    unsignedShortArray[i2] = UnsignedShort.MAX_VALUE;
                    continue;
                }
                n2 = uriTable2.add(-1, string);
            }
            unsignedShortArray[i2] = UnsignedShort.valueOf(n2);
        }
        return unsignedShortArray;
    }

    private Object b(ExtensionObject extensionObject) throws DecodingException {
        if (this.a(extensionObject)) {
            return this.a((XmlElement)extensionObject.getObject());
        }
        return extensionObject.decode(this.getEncoderContext(), this.namespaceTable);
    }

    private Object decode(ExtensionObject[] extensionObjectArray) throws DecodingException {
        Object object = this.b(extensionObjectArray);
        if (object instanceof ExtensionObject[]) {
            return this.getEncoderContext().decode(extensionObjectArray, this.namespaceTable);
        }
        return object;
    }

    /*
     * Exception decompiling
     */
    private String aPF() throws DecodingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BigDecimal s(String string) throws DecodingException {
        ExtensionObject extensionObject = this.getExtensionObject(string);
        XmlElement xmlElement = (XmlElement)extensionObject.getObject();
        return this.a(xmlElement);
    }

    private BigDecimal[] t(String string) throws DecodingException {
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        if (this.c(string, true)) {
            while (this.y("ExtensionObject")) {
                ExtensionObject extensionObject = this.getExtensionObject("ExtensionObject");
                arrayList.add(this.a((XmlElement)extensionObject.getObject()));
            }
            if (this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < arrayList.size()) {
                throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
            }
            this.x(string);
        }
        return arrayList.toArray(new BigDecimal[0]);
    }

    private String u(String string) throws DecodingException {
        String string2 = EMPTY_STRING;
        boolean bl = true;
        int n2 = 0;
        try {
            do {
                int n3 = this.reader.getEventType();
                switch (n3) {
                    case 1: {
                        if (this.reader.getLocalName().equals(string)) {
                            bl = true;
                        }
                        if (bl) {
                            string2 = string2 + "<" + this.reader.getLocalName() + ">";
                        }
                        ++n2;
                        break;
                    }
                    case 4: {
                        if (!bl) break;
                        string2 = string2 + this.reader.getText();
                        break;
                    }
                    case 2: {
                        if (--n2 < 0) {
                            return string2;
                        }
                        if (this.reader.getLocalName().equals(string)) {
                            string2 = string2 + "</" + this.reader.getLocalName() + ">";
                            bl = false;
                        }
                        if (!bl || this.reader.getLocalName().equals(string)) break;
                        string2 = string2 + "</" + this.reader.getLocalName() + ">";
                        break;
                    }
                }
                this.reader.next();
            } while (this.reader.hasNext());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DecodingException(xMLStreamException);
        }
        return string2;
    }

    private String getString() throws DecodingException {
        String string = this.aPF();
        if (string != null && this.hB.getMaxArrayLength() > 0 && this.hB.getMaxArrayLength() < string.length()) {
            throw new DecodingException(StatusCodes.Bad_EncodingLimitsExceeded);
        }
        return string;
    }

    private void initialize() {
        this.reader = null;
    }

    private boolean a(ExtensionObject extensionObject) {
        return this.getEncoderContext().getNamespaceTable().nodeIdEquals(Identifiers.Decimal, extensionObject.getTypeId());
    }

    private boolean v(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    private boolean w(String string) {
        this.aPG();
        return this.peek(string);
    }

    private void aPG() {
        while (this.reader.getEventType() != 12 && this.reader.getEventType() != 1 && this.reader.getEventType() != 2 && this.reader.getEventType() != 9 && this.reader.getEventType() != 4 && this.reader.getEventType() != 8) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private void aPH() {
        while (this.reader.getEventType() != 2 && this.reader.getEventType() != 8) {
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private void aPI() throws DecodingException {
        while (this.reader.getEventType() != 1 && this.reader.getEventType() != 2 && this.reader.getEventType() != 9 && this.reader.getEventType() != 8) {
            try {
                this.reader.nextTag();
            }
            catch (XMLStreamException xMLStreamException) {
                return;
            }
        }
    }

    private BigDecimal a(XmlElement xmlElement) throws DecodingException {
        XmlDecoder xmlDecoder = new XmlDecoder(xmlElement, this.getEncoderContext());
        xmlDecoder.c("Decimal", false);
        Short s2 = xmlDecoder.get("Scale", Short.class);
        String string = xmlDecoder.get("Value", String.class).trim();
        xmlDecoder.close();
        return new BigDecimal(new BigInteger(string), s2.shortValue());
    }

    private void skip() throws XMLStreamException {
        int n2 = 0;
        this.reader.next();
        if (this.reader.getEventType() != 2) {
            ++n2;
            while (n2 != 0) {
                this.reader.next();
                if (this.reader.getEventType() != 1) {
                    ++n2;
                    continue;
                }
                if (this.reader.getEventType() == 1) continue;
                --n2;
            }
        }
        this.reader.next();
    }

    private void a(QName qName) throws DecodingException {
        this.aPG();
        int n2 = 1;
        while (n2 > 0) {
            if (this.reader.getEventType() == 2) {
                if (this.reader.getLocalName().equals(qName.getLocalPart()) && this.reader.getNamespaceURI().equals(qName.getNamespaceURI())) {
                    --n2;
                }
            } else if (this.reader.getEventType() == 1 && this.reader.getLocalName().equals(qName.getLocalPart()) && this.reader.getNamespaceURI().equals(qName.getNamespaceURI())) {
                ++n2;
            }
            try {
                this.skip();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
            this.aPG();
        }
    }

    private Object b(ExtensionObject[] extensionObjectArray) throws DecodingException {
        BigDecimal[] bigDecimalArray = new BigDecimal[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (!this.a(extensionObject)) {
                return extensionObjectArray;
            }
            bigDecimalArray[i2] = this.a((XmlElement)extensionObject.getObject());
        }
        return bigDecimalArray;
    }

    boolean c(String string, boolean bl) throws DecodingException {
        return this.b(string, bl);
    }

    void x(String string) throws DecodingException {
        if (!this.v(string)) {
            this.aPH();
            int n2 = this.reader.getEventType();
            String string2 = this.reader.getLocalName();
            if (n2 != 2) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, "No end element found: '" + string2 + ":" + this.reader.getNamespaceURI() + "' eventType=" + n2);
            }
            if (!string2.equals(string)) {
                throw new DecodingException(StatusCodes.Bad_DecodingError, "Encountered end element: '" + string2 + ":" + this.reader.getNamespaceURI() + "' when expecting element: '" + string + "'.");
            }
            this.getEndElement();
        }
    }

    boolean y(String string) throws DecodingException {
        while (!this.reader.isStartElement()) {
            if (this.reader.getEventType() == 2) {
                return false;
            }
            try {
                this.reader.next();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DecodingException(xMLStreamException);
            }
        }
        if (this.v(string)) {
            return true;
        }
        return this.reader.getLocalName().equals(string);
    }
}

