/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.utils;

import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.IEncodeableSerializer;
import java.util.Collection;

public abstract class AbstractSerializer
implements IEncodeableSerializer {
    Class<? extends IEncodeable> clazz;
    ExpandedNodeId nodeId;
    ExpandedNodeId binaryId;
    ExpandedNodeId xmlId;
    ExpandedNodeId qB;

    private static ExpandedNodeId c(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId == null) {
            return null;
        }
        if (!expandedNodeId.isLocal()) {
            throw new IllegalArgumentException("Only ExpandedNodeIds that refer the local server are allowed as parameters");
        }
        if (expandedNodeId.getNamespaceUri() != null && !expandedNodeId.getNamespaceUri().isEmpty()) {
            return expandedNodeId;
        }
        if (expandedNodeId.getNamespaceIndex() == 0) {
            return new ExpandedNodeId(NamespaceTable.OPCUA_NAMESPACE, expandedNodeId.getValue());
        }
        throw new IllegalArgumentException("Only ExpandedNodeIds that contain the URI are allowed as parameter");
    }

    public AbstractSerializer(Class<? extends IEncodeable> clazz, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        this(clazz, expandedNodeId, expandedNodeId2, null);
    }

    public AbstractSerializer(Class<? extends IEncodeable> clazz, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, ExpandedNodeId expandedNodeId3) {
        this(clazz, expandedNodeId, expandedNodeId2, expandedNodeId3, null);
    }

    public AbstractSerializer(Class<? extends IEncodeable> clazz, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, ExpandedNodeId expandedNodeId3, ExpandedNodeId expandedNodeId4) {
        if (clazz == null) {
            throw new IllegalArgumentException("Given parameters cannot be null");
        }
        this.clazz = clazz;
        this.binaryId = AbstractSerializer.c(expandedNodeId);
        this.xmlId = AbstractSerializer.c(expandedNodeId2);
        this.nodeId = AbstractSerializer.c(expandedNodeId3);
        this.qB = AbstractSerializer.c(expandedNodeId4);
    }

    @Override
    @Deprecated
    public void calcEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (!clazz.equals(this.clazz)) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        this.calcEncodeable(iEncodeable, iEncoder);
    }

    @Deprecated
    public void calcEncodeable(IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
    }

    @Override
    public Class<? extends IEncodeable> getClass(ExpandedNodeId expandedNodeId) {
        return expandedNodeId.equals(this.binaryId) || expandedNodeId.equals(this.xmlId) || expandedNodeId.equals(this.qB) || this.nodeId != null && expandedNodeId.equals(this.nodeId) ? this.clazz : null;
    }

    @Override
    public IEncodeable getEncodeable(Class<? extends IEncodeable> clazz, IDecoder iDecoder) throws DecodingException {
        if (!clazz.equals(this.clazz)) {
            throw new DecodingException("Cannot decode " + clazz);
        }
        return this.getEncodeable(iDecoder);
    }

    public abstract IEncodeable getEncodeable(IDecoder var1) throws DecodingException;

    @Override
    public ExpandedNodeId getNodeId(Class<? extends IEncodeable> clazz, EncodeType encodeType) {
        if (encodeType == null) {
            return this.nodeId;
        }
        if (encodeType == EncodeType.Binary) {
            return this.binaryId;
        }
        if (encodeType == EncodeType.Xml) {
            return this.xmlId;
        }
        if (encodeType == EncodeType.Json) {
            return this.qB;
        }
        return null;
    }

    @Override
    public void getSupportedClasses(Collection<Class<? extends IEncodeable>> collection) {
        collection.add(this.clazz);
    }

    @Override
    public void getSupportedNodeIds(Collection<ExpandedNodeId> collection) {
        if (this.binaryId != null) {
            collection.add(this.binaryId);
        }
        if (this.xmlId != null) {
            collection.add(this.xmlId);
        }
        if (this.qB != null) {
            collection.add(this.qB);
        }
    }

    @Override
    public void putEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        if (!clazz.equals(this.clazz)) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        this.putEncodeable(iEncodeable, iEncoder);
    }

    public abstract void putEncodeable(IEncodeable var1, IEncoder var2) throws EncodingException;
}

