/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.ByteOptionSetDataType;
import com.prosysopc.ua.OptionSetDataType;
import com.prosysopc.ua.UInt16OptionSetDataType;
import com.prosysopc.ua.UInt32OptionSetDataType;
import com.prosysopc.ua.UInt64OptionSetDataType;
import com.prosysopc.ua.stack.builtintypes.BuiltinsMap;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncoderMode;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.IEncoder;
import com.prosysopc.ua.stack.encoding.binary.NodeIdEncoding;
import com.prosysopc.ua.stack.utils.EncodingLimitsExceededIoException;
import com.prosysopc.ua.stack.utils.LimitedByteArrayOutputStream;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.OutputStreamWriteable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEncoder
implements IEncoder {
    private static Logger logger = LoggerFactory.getLogger(BinaryEncoder.class);
    public static final Charset UTF8 = Charset.forName("utf-8");
    private static final Map<Class<?>, a<?>> pL = new HashMap();
    private static final a<DateTime> pY;
    private static final a<ExtensionObject> pZ;
    private static final a<Structure> qa;
    private static final a<DataValue> qb;
    private static final a<Variant> qc;
    private static final a<DiagnosticInfo> qd;
    private static final a<Enumeration> qe;
    private static final a<BigDecimal> qf;
    private static final a<OptionSetDataType<?, ?>> qg;
    private static final ExpandedNodeId pV;
    IBinaryWriteable qh;
    EncoderContext pX;
    EncoderMode qi = EncoderMode.NonStrict;

    private static <T> void a(Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        a<T> a3 = pL.put(clazz, a2);
        if (a3 != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
    }

    private static <T> a<T> h(Class<?> clazz) throws EncodingException {
        a<?> a2 = pL.get(clazz);
        if (a2 != null) {
            return a2;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return pZ;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return qa;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return qb;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return qc;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return qd;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return qe;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return pY;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return qf;
        }
        if (OptionSetDataType.class.isAssignableFrom(clazz)) {
            return qg;
        }
        throw new EncodingException("Cannot encode class: " + clazz);
    }

    private static EncodingException b(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new EncodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new EncodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new EncodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new EncodingException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
        }
        if (iOException instanceof EncodingLimitsExceededIoException) {
            return new EncodingException(new StatusCode(StatusCodes.Bad_EncodingLimitsExceeded), (Throwable)iOException, iOException.getMessage());
        }
        return new EncodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    static ExtensionObject[] a(BigDecimal[] bigDecimalArray) throws EncodingException {
        if (bigDecimalArray == null) {
            return null;
        }
        ExtensionObject[] extensionObjectArray = new ExtensionObject[bigDecimalArray.length];
        for (int i2 = 0; i2 < bigDecimalArray.length; ++i2) {
            extensionObjectArray[i2] = BinaryEncoder.a(bigDecimalArray[i2]);
        }
        return extensionObjectArray;
    }

    static ExtensionObject a(BigDecimal bigDecimal) throws EncodingException {
        int n2 = bigDecimal.scale();
        if (n2 > Short.MAX_VALUE) {
            throw new EncodingException("Decimal scale overflow Short max value: " + n2);
        }
        if (n2 < Short.MIN_VALUE) {
            throw new EncodingException("Decimal scale underflow Short min value: " + n2);
        }
        short s2 = (short)n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort(s2);
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = com.prosysopc.ua.stack.encoding.binary.a.reverse(bigDecimal.unscaledValue().toByteArray());
        byte[] byArray3 = com.prosysopc.ua.stack.encoding.binary.a.concat(byArray, byArray2);
        return new ExtensionObject(pV, ByteString.valueOf(byArray3));
    }

    public BinaryEncoder(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(new ByteBufferWriteable(byteBuffer));
    }

    public BinaryEncoder(ByteBuffer byteBuffer) {
        ByteBufferWriteable byteBufferWriteable = new ByteBufferWriteable(byteBuffer);
        this.setWriteable(byteBufferWriteable);
    }

    public BinaryEncoder(IBinaryWriteable iBinaryWriteable) {
        this.setWriteable(iBinaryWriteable);
    }

    public BinaryEncoder(OutputStream outputStream) {
        OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(outputStream);
        outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
        this.setWriteable(outputStreamWriteable);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.pX;
    }

    public EncoderMode getEncoderType() {
        return this.qi;
    }

    public IBinaryWriteable getOutput() {
        return this.qh;
    }

    public IBinaryWriteable getWriteable() {
        return this.qh;
    }

    @Override
    public void put(String string, Object object) throws EncodingException {
        if (object == null) {
            throw new EncodingException("Cannot encode null object without Class information, use the overload that takes Class parameter");
        }
        this.put(string, object, object.getClass());
    }

    @Override
    public void put(String string, Object object, Class<?> clazz) throws EncodingException {
        Class<?> clazz2 = MultiDimensionArrayUtils.getComponentType(clazz);
        a<Object> a2 = BinaryEncoder.h(clazz2);
        int n2 = MultiDimensionArrayUtils.getClassDimensions(clazz);
        if (n2 == 0) {
            a2.a(this, string, object, clazz2);
            return;
        }
        if (n2 == 1) {
            if (object == null) {
                this.putInt32((String)null, -1);
                return;
            }
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length;
            this.h(n3);
            this.putInt32((String)null, n3);
            for (Object object2 : objectArray) {
                a2.a(this, null, object2, clazz2);
            }
            return;
        }
        if (object == null) {
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = -1;
            }
            this.putInt32Array((String)null, nArray);
            return;
        }
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(object);
        Object[] objectArray = (Object[])MultiDimensionArrayUtils.muxArray(object, nArray, clazz2);
        int n4 = objectArray.length;
        this.h(n4);
        this.putInt32Array((String)null, nArray);
        for (Object object3 : objectArray) {
            a2.a(this, null, object3, clazz2);
        }
    }

    @Override
    public void putArray(String string, int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.putBooleanArray(null, (Boolean[])object);
                break;
            }
            case 2: {
                this.putSByteArray(null, (Byte[])object);
                break;
            }
            case 3: {
                this.putByteArray(null, (UnsignedByte[])object);
                break;
            }
            case 4: {
                this.putInt16Array(null, (Short[])object);
                break;
            }
            case 5: {
                this.putUInt16Array(null, (UnsignedShort[])object);
                break;
            }
            case 6: {
                this.putInt32Array((String)null, (Integer[])object);
                break;
            }
            case 7: {
                this.putUInt32Array(null, (UnsignedInteger[])object);
                break;
            }
            case 8: {
                this.putInt64Array(null, (Long[])object);
                break;
            }
            case 9: {
                this.putUInt64Array(null, (UnsignedLong[])object);
                break;
            }
            case 10: {
                this.putFloatArray(null, (Float[])object);
                break;
            }
            case 11: {
                this.putDoubleArray(null, (Double[])object);
                break;
            }
            case 12: {
                this.putStringArray(null, (String[])object);
                break;
            }
            case 13: {
                this.putDateTimeArray(null, (DateTime[])object);
                break;
            }
            case 14: {
                this.putGuidArray(null, (UUID[])object);
                break;
            }
            case 15: {
                this.putByteStringArray(null, (ByteString[])object);
                break;
            }
            case 16: {
                this.putXmlElementArray(null, (XmlElement[])object);
                break;
            }
            case 17: {
                this.putNodeIdArray(null, (NodeId[])object);
                break;
            }
            case 18: {
                this.putExpandedNodeIdArray(null, (ExpandedNodeId[])object);
                break;
            }
            case 19: {
                this.putStatusCodeArray(null, (StatusCode[])object);
                break;
            }
            case 20: {
                this.putQualifiedNameArray(null, (QualifiedName[])object);
                break;
            }
            case 21: {
                this.putLocalizedTextArray(null, (LocalizedText[])object);
                break;
            }
            case 22: {
                if (object instanceof ExtensionObject[]) {
                    this.putExtensionObjectArray(null, (ExtensionObject[])object);
                    break;
                }
                if (object instanceof Structure[]) {
                    this.a(null, (Structure[])object);
                    break;
                }
                throw new EncodingException("cannot encode " + object);
            }
            case 23: {
                this.putDataValueArray(null, (DataValue[])object);
                break;
            }
            case 24: {
                this.putVariantArray(null, (Variant[])object);
                break;
            }
            case 25: {
                this.putDiagnosticInfoArray(null, (DiagnosticInfo[])object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    @Override
    public void putBoolean(String string, Boolean bl) throws EncodingException {
        try {
            if (bl == null) {
                this.d(bl);
                this.putSByte(null, 0);
            } else {
                this.qh.put(bl != false ? (byte)1 : 0);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putBooleanArray(String string, Boolean[] booleanArray) throws EncodingException {
        try {
            if (booleanArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(booleanArray.length);
            this.qh.putInt(booleanArray.length);
            for (Boolean bl : booleanArray) {
                this.putBoolean(null, bl);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putBooleanArray(String string, Collection<Boolean> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Boolean bl : collection) {
                this.putBoolean(null, bl);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putByte(String string, UnsignedByte unsignedByte) throws EncodingException {
        try {
            if (unsignedByte == null) {
                this.d(unsignedByte);
                this.putSByte(null, 0);
            } else {
                this.qh.put(unsignedByte.toByteBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putByteArray(String string, Collection<UnsignedByte> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (UnsignedByte unsignedByte : collection) {
                this.putByte(null, unsignedByte);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putByteArray(String string, UnsignedByte[] unsignedByteArray) throws EncodingException {
        try {
            if (unsignedByteArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(unsignedByteArray.length);
            this.qh.putInt(unsignedByteArray.length);
            for (UnsignedByte unsignedByte : unsignedByteArray) {
                this.putByte(null, unsignedByte);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putByteString(String string, ByteString byteString) throws EncodingException {
        this.a(string, ByteString.asByteArray(byteString));
    }

    @Override
    public void putByteStringArray(String string, ByteString[] byteStringArray) throws EncodingException {
        try {
            if (byteStringArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(byteStringArray.length);
            this.qh.putInt(byteStringArray.length);
            for (ByteString byteString : byteStringArray) {
                this.putByteString(null, byteString);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putByteStringArray(String string, Collection<ByteString> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (ByteString byteString : collection) {
                this.putByteString(null, byteString);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDataValue(String string, DataValue dataValue) throws EncodingException {
        if (dataValue == null) {
            this.putSByte(null, 0);
            return;
        }
        int n2 = 0;
        if (dataValue.getValue() != null) {
            n2 |= 1;
        }
        if (dataValue.getStatusCode() != null && !dataValue.getStatusCode().equals(StatusCode.GOOD)) {
            n2 |= 2;
        }
        if (dataValue.getSourceTimestamp() != null && !dataValue.getSourceTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 4;
        }
        if (dataValue.getServerTimestamp() != null && !dataValue.getServerTimestamp().equals(DateTime.MIN_VALUE)) {
            n2 |= 8;
        }
        if (dataValue.getSourcePicoseconds() != null && !dataValue.getSourcePicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x10;
        }
        if (dataValue.getServerPicoseconds() != null && !dataValue.getServerPicoseconds().equals(UnsignedShort.MIN_VALUE)) {
            n2 |= 0x20;
        }
        this.putSByte(null, n2);
        if ((n2 & 1) == 1) {
            this.putVariant(null, dataValue.getValue());
        }
        if ((n2 & 2) == 2) {
            this.putStatusCode(null, dataValue.getStatusCode());
        }
        if ((n2 & 4) == 4) {
            this.putDateTime(null, dataValue.getSourceTimestamp());
        }
        if ((n2 & 0x10) == 16) {
            this.putUInt16(null, dataValue.getSourcePicoseconds());
        }
        if ((n2 & 8) == 8) {
            this.putDateTime(null, dataValue.getServerTimestamp());
        }
        if ((n2 & 0x20) == 32) {
            this.putUInt16(null, dataValue.getServerPicoseconds());
        }
    }

    @Override
    public void putDataValueArray(String string, Collection<DataValue> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (DataValue dataValue : collection) {
                this.putDataValue(null, dataValue);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDataValueArray(String string, DataValue[] dataValueArray) throws EncodingException {
        try {
            if (dataValueArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(dataValueArray.length);
            this.qh.putInt(dataValueArray.length);
            for (DataValue dataValue : dataValueArray) {
                this.putDataValue(null, dataValue);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDateTime(String string, DateTime dateTime) throws EncodingException {
        try {
            if (dateTime == null) {
                this.d(dateTime);
                this.qh.putLong(0L);
            } else if (dateTime.compareTo(DateTime.MAX_VALUE) >= 0) {
                this.qh.putLong(Long.MAX_VALUE);
            } else if (dateTime.compareTo(DateTime.MIN_VALUE) <= 0) {
                this.qh.putLong(0L);
            } else {
                this.qh.putLong(dateTime.getValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDateTimeArray(String string, Collection<DateTime> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (DateTime dateTime : collection) {
                this.putDateTime(null, dateTime);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDateTimeArray(String string, DateTime[] dateTimeArray) throws EncodingException {
        try {
            if (dateTimeArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(dateTimeArray.length);
            this.qh.putInt(dateTimeArray.length);
            for (DateTime dateTime : dateTimeArray) {
                this.putDateTime(null, dateTime);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDiagnosticInfo(String string, DiagnosticInfo diagnosticInfo) throws EncodingException {
        if (diagnosticInfo == null) {
            this.putSByte(null, 0);
            return;
        }
        int n2 = 0;
        if (diagnosticInfo.getSymbolicId() != null) {
            n2 |= 1;
        }
        if (diagnosticInfo.getNamespaceUriStr() != null) {
            n2 |= 2;
        }
        if (diagnosticInfo.getLocalizedTextStr() != null) {
            n2 |= 4;
        }
        if (diagnosticInfo.getLocaleStr() != null) {
            n2 |= 8;
        }
        if (diagnosticInfo.getAdditionalInfo() != null) {
            n2 |= 0x10;
        }
        if (diagnosticInfo.getInnerStatusCode() != null) {
            n2 |= 0x20;
        }
        if (diagnosticInfo.getInnerDiagnosticInfo() != null) {
            n2 |= 0x40;
        }
        try {
            this.putSByte(null, n2);
            if ((n2 & 1) == 1) {
                this.qh.putInt(diagnosticInfo.getSymbolicId());
            }
            if ((n2 & 2) == 2) {
                this.qh.putInt(diagnosticInfo.getNamespaceUri());
            }
            if ((n2 & 8) == 8) {
                this.qh.putInt(diagnosticInfo.getLocale());
            }
            if ((n2 & 4) == 4) {
                this.qh.putInt(diagnosticInfo.getLocalizedText());
            }
            if ((n2 & 0x10) == 16) {
                this.putString(null, diagnosticInfo.getAdditionalInfo());
            }
            if ((n2 & 0x20) == 32) {
                this.putStatusCode(null, diagnosticInfo.getInnerStatusCode());
            }
            if ((n2 & 0x40) == 64) {
                this.putDiagnosticInfo(null, diagnosticInfo.getInnerDiagnosticInfo());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, Collection<DiagnosticInfo> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (DiagnosticInfo diagnosticInfo : collection) {
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDiagnosticInfoArray(String string, DiagnosticInfo[] diagnosticInfoArray) throws EncodingException {
        try {
            if (diagnosticInfoArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(diagnosticInfoArray.length);
            this.qh.putInt(diagnosticInfoArray.length);
            for (DiagnosticInfo diagnosticInfo : diagnosticInfoArray) {
                this.putDiagnosticInfo(null, diagnosticInfo);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDouble(String string, double d2) throws EncodingException {
        try {
            this.qh.putDouble(d2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDouble(String string, Double d2) throws EncodingException {
        try {
            if (d2 == null) {
                this.d(d2);
                this.qh.putDouble(0.0);
            } else {
                this.qh.putDouble(d2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDoubleArray(String string, Collection<Double> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Double d2 : collection) {
                this.putDouble((String)null, d2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putDoubleArray(String string, Double[] doubleArray) throws EncodingException {
        try {
            if (doubleArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(doubleArray.length);
            this.qh.putInt(doubleArray.length);
            for (Double d2 : doubleArray) {
                this.putDouble((String)null, d2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putEncodeable(String string, Class<? extends IEncodeable> clazz, IEncodeable iEncodeable) throws EncodingException {
        this.pX.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void putEncodeable(String string, IEncodeable iEncodeable) throws EncodingException {
        Class<?> clazz = iEncodeable.getClass();
        this.pX.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void putEncodeableArray(String string, Class<? extends IEncodeable> clazz, Object object) throws EncodingException {
        try {
            if (object == null) {
                this.qh.putInt(-1);
                return;
            }
            int n2 = Array.getLength(object);
            this.h(n2);
            this.qh.putInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pX.getEncodeableSerializer().putEncodeable(clazz, (IEncodeable)Array.get(object, i2), this);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putEnumeration(String string, Enumeration enumeration) throws EncodingException {
        try {
            if (enumeration == null) {
                this.qh.putInt(0);
                return;
            }
            this.qh.putInt(enumeration.getValue());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putEnumerationArray(String string, Object object) throws EncodingException {
        try {
            if (object == null) {
                this.qh.putInt(-1);
                return;
            }
            int n2 = Array.getLength(object);
            this.h(n2);
            this.qh.putInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.putEnumeration(null, (Enumeration)Array.get(object, i2));
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putExpandedNodeId(String string, ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            if (expandedNodeId == null) {
                expandedNodeId = ExpandedNodeId.NULL;
            }
            int n2 = 0;
            if (expandedNodeId.getNamespaceUri() != null) {
                n2 = (byte)(n2 | 0x80);
            }
            if (expandedNodeId.getServerIndex() != null) {
                n2 = (byte)(n2 | 0x40);
            }
            Object object = expandedNodeId.getValue();
            if (expandedNodeId.getIdType() == IdType.Numeric) {
                UnsignedInteger unsignedInteger = (UnsignedInteger)object;
                if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() == 0) {
                    this.putSByte(null, NodeIdEncoding.TwoByte.getBits() | n2);
                    this.qh.put(unsignedInteger.byteValue());
                } else if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && expandedNodeId.getNamespaceIndex() < 256) {
                    this.putSByte(null, NodeIdEncoding.FourByte.getBits() | n2);
                    this.putSByte(null, expandedNodeId.getNamespaceIndex());
                    this.qh.putShort(unsignedInteger.shortValue());
                } else {
                    this.putSByte(null, NodeIdEncoding.Numeric.getBits() | n2);
                    this.qh.putShort((short)expandedNodeId.getNamespaceIndex());
                    this.qh.putInt(unsignedInteger.intValue());
                }
            }
            if (expandedNodeId.getIdType() == IdType.String) {
                this.putSByte(null, NodeIdEncoding.String.getBits() | n2);
                this.qh.putShort((short)expandedNodeId.getNamespaceIndex());
                this.putString(null, (String)expandedNodeId.getValue());
            } else if (expandedNodeId.getIdType() == IdType.Opaque) {
                this.putSByte(null, NodeIdEncoding.ByteString.getBits() | n2);
                this.qh.putShort((short)expandedNodeId.getNamespaceIndex());
                this.putByteString(null, (ByteString)expandedNodeId.getValue());
            } else if (expandedNodeId.getIdType() == IdType.Guid) {
                this.putSByte(null, NodeIdEncoding.Guid.getBits() | n2);
                this.qh.putShort((short)expandedNodeId.getNamespaceIndex());
                this.putGuid(null, (UUID)expandedNodeId.getValue());
            }
            if (expandedNodeId.getNamespaceUri() != null) {
                this.putString(null, expandedNodeId.getNamespaceUri());
            }
            if (expandedNodeId.getServerIndex() != null) {
                this.qh.putInt(expandedNodeId.getServerIndex().intValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, Collection<ExpandedNodeId> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (ExpandedNodeId expandedNodeId : collection) {
                this.putExpandedNodeId(null, expandedNodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putExpandedNodeIdArray(String string, ExpandedNodeId[] expandedNodeIdArray) throws EncodingException {
        try {
            if (expandedNodeIdArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(expandedNodeIdArray.length);
            this.qh.putInt(expandedNodeIdArray.length);
            for (ExpandedNodeId expandedNodeId : expandedNodeIdArray) {
                this.putExpandedNodeId(null, expandedNodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putExtensionObject(String string, ExtensionObject extensionObject) throws EncodingException {
        if (extensionObject == null) {
            this.d(extensionObject);
            this.putNodeId(null, null);
            this.putSByte(null, 0);
            return;
        }
        if (!extensionObject.isEncoded()) {
            this.putExtensionObject(string, ExtensionObject.binaryEncode((Structure)extensionObject.getObject(), this.pX));
            return;
        }
        this.putNodeId(null, this.pX.toNodeId(extensionObject.getTypeId()));
        Object object = extensionObject.getObject();
        if (object == null) {
            this.putSByte(null, 0);
        } else if (extensionObject.getEncodeType() == EncodeType.Binary) {
            this.putSByte(null, 1);
            this.putByteString(null, (ByteString)object);
        } else if (extensionObject.getEncodeType() == EncodeType.Xml) {
            this.putSByte(null, 2);
            this.putXmlElement(null, (XmlElement)object);
        } else {
            throw new EncodingException("Unexpected object " + (Object)((Object)extensionObject.getEncodeType()));
        }
    }

    @Override
    public void putExtensionObjectArray(String string, Collection<ExtensionObject> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (ExtensionObject extensionObject : collection) {
                this.putExtensionObject(null, extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putExtensionObjectArray(String string, ExtensionObject[] extensionObjectArray) throws EncodingException {
        try {
            if (extensionObjectArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(extensionObjectArray.length);
            this.qh.putInt(extensionObjectArray.length);
            for (ExtensionObject extensionObject : extensionObjectArray) {
                this.putExtensionObject(null, extensionObject);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putFloat(String string, float f2) throws EncodingException {
        try {
            this.qh.putFloat(f2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putFloat(String string, Float f2) throws EncodingException {
        try {
            if (f2 == null) {
                this.d(f2);
                this.qh.putFloat(0.0f);
            } else {
                this.qh.putFloat(f2.floatValue());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putFloatArray(String string, Collection<Float> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Float f2 : collection) {
                this.putFloat((String)null, f2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putFloatArray(String string, Float[] floatArray) throws EncodingException {
        try {
            if (floatArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(floatArray.length);
            this.qh.putInt(floatArray.length);
            for (Float f2 : floatArray) {
                this.putFloat((String)null, f2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putGuid(String string, UUID uUID) throws EncodingException {
        try {
            if (uUID == null) {
                this.d(uUID);
                this.qh.putLong(0L);
                this.qh.putLong(0L);
            } else {
                int n2;
                long l2 = uUID.getMostSignificantBits();
                long l3 = uUID.getLeastSignificantBits();
                byte[] byArray = new byte[16];
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray[n2] = (byte)(l2 >>> 8 * (7 - n2));
                }
                for (n2 = 8; n2 < 16; ++n2) {
                    byArray[n2] = (byte)(l3 >>> 8 * (7 - n2));
                }
                this.qh.put(byArray[3]);
                this.qh.put(byArray[2]);
                this.qh.put(byArray[1]);
                this.qh.put(byArray[0]);
                this.qh.put(byArray[5]);
                this.qh.put(byArray[4]);
                this.qh.put(byArray[7]);
                this.qh.put(byArray[6]);
                for (n2 = 8; n2 < 16; ++n2) {
                    this.qh.put(byArray[n2]);
                }
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putGuidArray(String string, Collection<UUID> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (UUID uUID : collection) {
                this.putGuid(null, uUID);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putGuidArray(String string, UUID[] uUIDArray) throws EncodingException {
        try {
            if (uUIDArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(uUIDArray.length);
            this.qh.putInt(uUIDArray.length);
            for (UUID uUID : uUIDArray) {
                this.putGuid(null, uUID);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16(String string, short s2) throws EncodingException {
        try {
            this.qh.putShort(s2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16(String string, Short s2) throws EncodingException {
        try {
            if (s2 == null) {
                this.d(s2);
                this.qh.putShort((short)0);
            } else {
                this.qh.putShort(s2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16Array(String string, Collection<Short> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Short s2 : collection) {
                this.putInt16((String)null, s2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt16Array(String string, Short[] shortArray) throws EncodingException {
        try {
            if (shortArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(shortArray.length);
            this.qh.putInt(shortArray.length);
            for (Short s2 : shortArray) {
                this.putInt16((String)null, s2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32(String string, int n2) throws EncodingException {
        try {
            this.qh.putInt(n2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32(String string, Integer n2) throws EncodingException {
        try {
            if (n2 == null) {
                this.d(n2);
                this.qh.putInt(0);
            } else {
                this.qh.putInt(n2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, Collection<Integer> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (int n2 : collection) {
                this.putInt32((String)null, n2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, int[] nArray) throws EncodingException {
        try {
            if (nArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(nArray.length);
            this.qh.putInt(nArray.length);
            for (int n2 : nArray) {
                this.putInt32((String)null, n2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt32Array(String string, Integer[] integerArray) throws EncodingException {
        try {
            if (integerArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(integerArray.length);
            this.qh.putInt(integerArray.length);
            for (Integer n2 : integerArray) {
                this.putInt32((String)null, n2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64(String string, long l2) throws EncodingException {
        try {
            this.qh.putLong(l2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64(String string, Long l2) throws EncodingException {
        try {
            if (l2 == null) {
                this.d(l2);
                this.qh.putLong(0L);
            } else {
                this.qh.putLong(l2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64Array(String string, Collection<Long> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Long l2 : collection) {
                this.putInt64((String)null, l2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putInt64Array(String string, Long[] longArray) throws EncodingException {
        try {
            if (longArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(longArray.length);
            this.qh.putInt(longArray.length);
            for (Long l2 : longArray) {
                this.putInt64((String)null, l2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putLocalizedText(String string, LocalizedText localizedText) throws EncodingException {
        try {
            if (localizedText == null) {
                this.putSByte(null, 0);
                return;
            }
            String string2 = localizedText.getLocaleId();
            String string3 = localizedText.getText();
            byte by = (byte)((string2 != null ? 1 : 0) | (string3 != null ? 2 : 0));
            this.qh.put(by);
            if (string2 != null) {
                this.putString(null, string2);
            }
            if (string3 != null) {
                this.putString(null, string3);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, Collection<LocalizedText> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (LocalizedText localizedText : collection) {
                this.putLocalizedText(null, localizedText);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putLocalizedTextArray(String string, LocalizedText[] localizedTextArray) throws EncodingException {
        try {
            if (localizedTextArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(localizedTextArray.length);
            this.qh.putInt(localizedTextArray.length);
            for (LocalizedText localizedText : localizedTextArray) {
                this.putLocalizedText(null, localizedText);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putMessage(IEncodeable iEncodeable) throws EncodingException {
        Class<?> clazz = iEncodeable.getClass();
        try {
            this.putNodeId(null, this.pX.getEncodeableNodeId(clazz, EncodeType.Binary));
        }
        catch (ServiceResultException serviceResultException) {
            serviceResultException.printStackTrace();
        }
        this.pX.getEncodeableSerializer().putEncodeable(clazz, iEncodeable, this);
    }

    @Override
    public void putNodeId(String string, NodeId nodeId) throws EncodingException {
        try {
            if (nodeId == null) {
                nodeId = NodeId.NULL;
            }
            Object object = nodeId.getValue();
            if (nodeId.getIdType() == IdType.Numeric) {
                UnsignedInteger unsignedInteger = (UnsignedInteger)object;
                if (unsignedInteger.compareTo(UnsignedByte.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() == 0) {
                    this.qh.put(NodeIdEncoding.TwoByte.getBits());
                    this.qh.put(unsignedInteger.byteValue());
                } else if (unsignedInteger.compareTo(UnsignedShort.MAX_VALUE) <= 0 && nodeId.getNamespaceIndex() < 256) {
                    this.qh.put(NodeIdEncoding.FourByte.getBits());
                    this.putSByte(null, nodeId.getNamespaceIndex());
                    this.qh.putShort(unsignedInteger.shortValue());
                } else {
                    this.qh.put(NodeIdEncoding.Numeric.getBits());
                    this.qh.putShort((short)nodeId.getNamespaceIndex());
                    this.qh.putInt(unsignedInteger.intValue());
                }
            } else if (nodeId.getIdType() == IdType.String) {
                this.qh.put(NodeIdEncoding.String.getBits());
                this.qh.putShort((short)nodeId.getNamespaceIndex());
                this.putString(null, (String)nodeId.getValue());
            } else if (nodeId.getIdType() == IdType.Opaque) {
                this.qh.put(NodeIdEncoding.ByteString.getBits());
                this.qh.putShort((short)nodeId.getNamespaceIndex());
                this.putByteString(null, (ByteString)nodeId.getValue());
            } else if (nodeId.getIdType() == IdType.Guid) {
                UUID uUID = (UUID)nodeId.getValue();
                this.qh.put(NodeIdEncoding.Guid.getBits());
                this.qh.putShort((short)nodeId.getNamespaceIndex());
                this.putGuid(null, uUID);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putNodeIdArray(String string, Collection<NodeId> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (NodeId nodeId : collection) {
                this.putNodeId(null, nodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putNodeIdArray(String string, NodeId[] nodeIdArray) throws EncodingException {
        try {
            if (nodeIdArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(nodeIdArray.length);
            this.qh.putInt(nodeIdArray.length);
            for (NodeId nodeId : nodeIdArray) {
                this.putNodeId(null, nodeId);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putObject(String string, Class<?> clazz, Object object) throws EncodingException {
        Class<?> clazz2;
        Integer n2 = BuiltinsMap.ID_MAP.get(clazz);
        boolean bl = clazz.isArray();
        if (n2 != null) {
            if (bl) {
                this.putArray(null, n2, object);
            } else {
                this.putScalar(null, n2, object);
            }
            return;
        }
        if (!bl && Enumeration.class.isAssignableFrom(clazz)) {
            this.putEnumeration(null, (Enumeration)object);
            return;
        }
        if (bl && Enumeration.class.isAssignableFrom(clazz.getComponentType())) {
            this.putEnumerationArray(null, object);
            return;
        }
        Class<?> clazz3 = clazz2 = bl ? clazz.getComponentType() : clazz;
        if (bl) {
            this.putEncodeableArray(null, clazz2, object);
        } else {
            this.pX.getEncodeableSerializer().putEncodeable(clazz, (IEncodeable)object, this);
        }
    }

    @Override
    public void putObject(String string, Object object) throws EncodingException {
        if (object == null) {
            throw new EncodingException("Cannot encode null value");
        }
        Class<?> clazz = object.getClass();
        this.putObject(null, clazz, object);
    }

    @Override
    public void putQualifiedName(String string, QualifiedName qualifiedName) throws EncodingException {
        try {
            if (qualifiedName == null) {
                this.qh.putShort((short)0);
                this.putString(null, null);
                return;
            }
            this.qh.putShort((short)qualifiedName.getNamespaceIndex());
            this.putString(null, qualifiedName.getName());
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putQualifiedNameArray(String string, Collection<QualifiedName> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (QualifiedName qualifiedName : collection) {
                this.putQualifiedName(null, qualifiedName);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putQualifiedNameArray(String string, QualifiedName[] qualifiedNameArray) throws EncodingException {
        try {
            if (qualifiedNameArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(qualifiedNameArray.length);
            this.qh.putInt(qualifiedNameArray.length);
            for (QualifiedName qualifiedName : qualifiedNameArray) {
                this.putQualifiedName(null, qualifiedName);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putSByte(String string, byte by) throws EncodingException {
        try {
            this.qh.put(by);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putSByte(String string, Byte by) throws EncodingException {
        try {
            if (by == null) {
                this.d(by);
                this.putSByte(null, 0);
            } else {
                this.qh.put(by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putSByte(String string, int n2) throws EncodingException {
        try {
            this.qh.put((byte)n2);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putSByteArray(String string, Byte[] byteArray) throws EncodingException {
        try {
            if (byteArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(byteArray.length);
            this.qh.putInt(byteArray.length);
            for (Byte by : byteArray) {
                this.putSByte((String)null, by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putSByteArray(String string, Collection<Byte> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Byte by : collection) {
                this.putSByte((String)null, by);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putScalar(String string, int n2, Object object) throws EncodingException {
        switch (n2) {
            case 1: {
                this.putBoolean(null, (Boolean)object);
                break;
            }
            case 2: {
                this.putSByte((String)null, (Byte)object);
                break;
            }
            case 3: {
                this.putByte(null, (UnsignedByte)object);
                break;
            }
            case 4: {
                this.putInt16((String)null, (Short)object);
                break;
            }
            case 5: {
                this.putUInt16(null, (UnsignedShort)object);
                break;
            }
            case 6: {
                this.putInt32((String)null, (Integer)object);
                break;
            }
            case 7: {
                this.putUInt32(null, (UnsignedInteger)object);
                break;
            }
            case 8: {
                this.putInt64((String)null, (Long)object);
                break;
            }
            case 9: {
                this.putUInt64(null, (UnsignedLong)object);
                break;
            }
            case 10: {
                this.putFloat((String)null, (Float)object);
                break;
            }
            case 11: {
                this.putDouble((String)null, (Double)object);
                break;
            }
            case 12: {
                this.putString(null, (String)object);
                break;
            }
            case 13: {
                this.putDateTime(null, (DateTime)object);
                break;
            }
            case 14: {
                this.putGuid(null, (UUID)object);
                break;
            }
            case 15: {
                this.putByteString(null, (ByteString)object);
                break;
            }
            case 16: {
                this.putXmlElement(null, (XmlElement)object);
                break;
            }
            case 17: {
                this.putNodeId(null, (NodeId)object);
                break;
            }
            case 18: {
                this.putExpandedNodeId(null, (ExpandedNodeId)object);
                break;
            }
            case 19: {
                this.putStatusCode(null, (StatusCode)object);
                break;
            }
            case 20: {
                this.putQualifiedName(null, (QualifiedName)object);
                break;
            }
            case 21: {
                this.putLocalizedText(null, (LocalizedText)object);
                break;
            }
            case 22: {
                if (object instanceof Structure) {
                    this.putExtensionObject(null, new ExtensionObject((Structure)object));
                    break;
                }
                this.putExtensionObject(null, (ExtensionObject)object);
                break;
            }
            case 23: {
                this.putDataValue(null, (DataValue)object);
                break;
            }
            case 24: {
                this.putVariant(null, (Variant)object);
                break;
            }
            case 25: {
                this.putDiagnosticInfo(null, (DiagnosticInfo)object);
                break;
            }
            default: {
                throw new EncodingException("cannot encode builtin type " + n2);
            }
        }
    }

    @Override
    public void putStatusCode(String string, StatusCode statusCode) throws EncodingException {
        try {
            if (statusCode == null) {
                this.d(statusCode);
                this.qh.putInt(StatusCode.GOOD.getValueAsIntBits());
            } else {
                this.qh.putInt(statusCode.getValueAsIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putStatusCodeArray(String string, Collection<StatusCode> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (StatusCode statusCode : collection) {
                this.putStatusCode(null, statusCode);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putStatusCodeArray(String string, StatusCode[] statusCodeArray) throws EncodingException {
        try {
            if (statusCodeArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(statusCodeArray.length);
            this.qh.putInt(statusCodeArray.length);
            for (StatusCode statusCode : statusCodeArray) {
                this.putStatusCode(null, statusCode);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putString(String string, String string2) throws EncodingException {
        try {
            if (string2 == null) {
                this.d(string2);
                this.qh.putInt(-1);
            } else {
                this.g(string2.length());
                byte[] byArray = string2.getBytes(UTF8);
                this.qh.putInt(byArray.length);
                this.qh.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putStringArray(String string, Collection<String> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (String string2 : collection) {
                this.putString(null, string2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putStringArray(String string, String[] stringArray) throws EncodingException {
        try {
            if (stringArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(stringArray.length);
            this.qh.putInt(stringArray.length);
            for (String string2 : stringArray) {
                this.putString(null, string2);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putStructure(String string, Structure structure) throws EncodingException {
        if (structure == null) {
            this.d(structure);
            this.putNodeId(null, NodeId.ZERO);
            this.putSByte(null, 0);
            this.putInt32((String)null, -1);
            return;
        }
        try {
            this.putNodeId(null, this.pX.getNamespaceTable().toNodeId(structure.getBinaryEncodeId()));
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get BinaryEncodeId for given Structure", serviceResultException);
        }
        this.putSByte(null, 1);
        int n2 = this.pX.getMaxByteStringLength();
        if (n2 == 0) {
            n2 = this.pX.getMaxMessageSize();
        }
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        LimitedByteArrayOutputStream limitedByteArrayOutputStream = LimitedByteArrayOutputStream.withSizeLimit(n2);
        BinaryEncoder binaryEncoder = new BinaryEncoder(limitedByteArrayOutputStream);
        binaryEncoder.setEncoderContext(this.getEncoderContext());
        binaryEncoder.putEncodeable(null, structure);
        this.a(null, limitedByteArrayOutputStream.toByteArray());
    }

    @Override
    public void putStructureArray(String string, Collection<Structure> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Structure structure : collection) {
                this.putStructure(null, structure);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putStructureArray(String string, Structure[] structureArray) throws EncodingException {
        try {
            if (structureArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(structureArray.length);
            this.qh.putInt(structureArray.length);
            for (Structure structure : structureArray) {
                this.putStructure(null, structure);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt16(String string, UnsignedShort unsignedShort) throws EncodingException {
        try {
            if (unsignedShort == null) {
                this.d(unsignedShort);
                this.qh.putShort((short)0);
            } else {
                this.qh.putShort(unsignedShort.toShortBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt16Array(String string, Collection<UnsignedShort> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (UnsignedShort unsignedShort : collection) {
                this.putUInt16(null, unsignedShort);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt16Array(String string, UnsignedShort[] unsignedShortArray) throws EncodingException {
        try {
            if (unsignedShortArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(unsignedShortArray.length);
            this.qh.putInt(unsignedShortArray.length);
            for (UnsignedShort unsignedShort : unsignedShortArray) {
                this.putUInt16(null, unsignedShort);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt32(String string, UnsignedInteger unsignedInteger) throws EncodingException {
        try {
            if (unsignedInteger == null) {
                this.d(unsignedInteger);
                this.qh.putInt(0);
            } else {
                this.qh.putInt(unsignedInteger.toIntBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt32Array(String string, Collection<UnsignedInteger> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (UnsignedInteger unsignedInteger : collection) {
                this.putUInt32(null, unsignedInteger);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt32Array(String string, UnsignedInteger[] unsignedIntegerArray) throws EncodingException {
        try {
            if (unsignedIntegerArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(unsignedIntegerArray.length);
            this.qh.putInt(unsignedIntegerArray.length);
            for (UnsignedInteger unsignedInteger : unsignedIntegerArray) {
                this.putUInt32(null, unsignedInteger);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt64(String string, UnsignedLong unsignedLong) throws EncodingException {
        try {
            if (unsignedLong == null) {
                this.d(unsignedLong);
                this.qh.putLong(0L);
            } else {
                this.qh.putLong(unsignedLong.toLongBits());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt64Array(String string, Collection<UnsignedLong> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (UnsignedLong unsignedLong : collection) {
                this.putUInt64(null, unsignedLong);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putUInt64Array(String string, UnsignedLong[] unsignedLongArray) throws EncodingException {
        try {
            if (unsignedLongArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(unsignedLongArray.length);
            this.qh.putInt(unsignedLongArray.length);
            for (UnsignedLong unsignedLong : unsignedLongArray) {
                this.putUInt64(null, unsignedLong);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putVariant(String string, Variant variant) throws EncodingException {
        boolean bl;
        int n2;
        if (variant == null) {
            this.d(variant);
            this.putSByte(null, 0);
            return;
        }
        ExtensionObject[] extensionObjectArray = variant.getValue();
        if (extensionObjectArray == null) {
            this.putSByte(null, 0);
            return;
        }
        Class<?> clazz = variant.getCompositeClass();
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            n2 = 22;
            bl = true;
        } else {
            bl = false;
            if (Structure.class.isAssignableFrom(clazz)) {
                n2 = 22;
            } else if (BuiltinsMap.ID_MAP.containsKey(clazz)) {
                n2 = BuiltinsMap.ID_MAP.get(clazz);
            } else {
                throw new EncodingException("Non-suitable composite class for Variant: " + clazz);
            }
        }
        if (!variant.isArray()) {
            this.putSByte(null, n2);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal)extensionObjectArray);
            }
            this.putScalar(null, n2, extensionObjectArray);
            return;
        }
        int n3 = variant.getDimension();
        if (n3 == 1) {
            this.putSByte(null, n2 | 0x80);
            if (bl) {
                extensionObjectArray = BinaryEncoder.a((BigDecimal[])extensionObjectArray);
            }
            this.putArray(null, n2, extensionObjectArray);
            return;
        }
        int[] nArray = variant.getArrayDimensions();
        int n4 = MultiDimensionArrayUtils.getLength(nArray);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(variant.getValue(), variant.getArrayDimensions());
        try {
            this.putSByte(null, n2 | 0xC0);
            this.qh.putInt(n4);
            while (arrayIterator.hasNext()) {
                Object object = arrayIterator.next();
                if (bl) {
                    object = BinaryEncoder.a((BigDecimal)object);
                }
                this.putScalar(null, n2, object);
            }
            this.putInt32Array((String)null, nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EncodingException("The dimensions of inner array elements of a multi-dimension variable must be equal in length", arrayIndexOutOfBoundsException);
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putVariantArray(String string, Collection<Variant> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (Variant variant : collection) {
                this.putVariant(null, variant);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putVariantArray(String string, Variant[] variantArray) throws EncodingException {
        try {
            if (variantArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(variantArray.length);
            this.qh.putInt(variantArray.length);
            for (Variant variant : variantArray) {
                this.putVariant(null, variant);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putXmlElement(String string, XmlElement xmlElement) throws EncodingException {
        try {
            if (xmlElement == null) {
                this.qh.putInt(-1);
            } else {
                this.a(string, xmlElement.getData());
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putXmlElementArray(String string, Collection<XmlElement> collection) throws EncodingException {
        try {
            if (collection == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(collection.size());
            this.qh.putInt(collection.size());
            for (XmlElement xmlElement : collection) {
                this.putXmlElement(null, xmlElement);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    @Override
    public void putXmlElementArray(String string, XmlElement[] xmlElementArray) throws EncodingException {
        try {
            if (xmlElementArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(xmlElementArray.length);
            this.qh.putInt(xmlElementArray.length);
            for (XmlElement xmlElement : xmlElementArray) {
                this.putXmlElement(null, xmlElement);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    public void setEncoderContext(EncoderContext encoderContext) {
        this.pX = encoderContext;
    }

    public void setEncoderMode(EncoderMode encoderMode) {
        this.qi = encoderMode;
    }

    public void setWriteable(IBinaryWriteable iBinaryWriteable) {
        if (iBinaryWriteable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Writeable must be in Little-Ending byte order");
        }
        this.qh = iBinaryWriteable;
    }

    private void h(int n2) throws EncodingException {
        int n3 = this.pX.getMaxArrayLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxArrayLength " + n3 + " < " + n2);
            logger.warn("assertArrayLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void f(int n2) throws EncodingException {
        int n3 = this.pX.getMaxByteStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxByteStringLength " + n3 + " < " + n2);
            logger.warn("assertByteStringLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void d(Object object) throws EncodingException {
        if (object != null) {
            return;
        }
        if (this.qi == EncoderMode.Strict) {
            throw new EncodingException("Cannot encode null value");
        }
    }

    private void g(int n2) throws EncodingException {
        int n3 = this.pX.getMaxStringLength();
        if (n3 > 0 && n2 > n3) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
            logger.warn("assertStringLength: failed", (Throwable)encodingException);
            throw encodingException;
        }
    }

    private void a(String string, byte[] byArray) throws EncodingException {
        try {
            if (byArray == null) {
                this.qh.putInt(-1);
            } else {
                this.f(byArray.length);
                this.qh.putInt(byArray.length);
                this.qh.put(byArray);
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    private void a(String string, BigDecimal bigDecimal) throws EncodingException {
        ExtensionObject extensionObject = BinaryEncoder.a(bigDecimal);
        this.putExtensionObject(string, extensionObject);
    }

    private void a(String string, OptionSetDataType<?, ?> optionSetDataType, Class<? extends OptionSetDataType<?, ?>> clazz) throws EncodingException {
        if (optionSetDataType == null) {
            if (ByteOptionSetDataType.class.isAssignableFrom(clazz)) {
                this.putByte(string, null);
                return;
            }
            if (UInt16OptionSetDataType.class.isAssignableFrom(clazz)) {
                this.putUInt16(string, null);
                return;
            }
            if (UInt32OptionSetDataType.class.isAssignableFrom(clazz)) {
                this.putUInt32(string, null);
                return;
            }
            if (UInt64OptionSetDataType.class.isAssignableFrom(clazz)) {
                this.putUInt64(string, null);
                return;
            }
            throw new EncodingException("Unknown OptionSetDataType class: " + clazz);
        }
        this.put(string, optionSetDataType.getAsBuiltInType());
    }

    void a(String string, Structure[] structureArray) throws EncodingException {
        try {
            if (structureArray == null) {
                this.qh.putInt(-1);
                return;
            }
            this.h(structureArray.length);
            this.qh.putInt(structureArray.length);
            for (Structure structure : structureArray) {
                this.putExtensionObject(null, new ExtensionObject(structure));
            }
        }
        catch (IOException iOException) {
            throw BinaryEncoder.b(iOException);
        }
    }

    static {
        pV = new ExpandedNodeId(NamespaceTable.OPCUA_NAMESPACE, Identifiers.Decimal.getValue());
        BinaryEncoder.a(Boolean.class, new a<Boolean>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Boolean bl, Class<? extends Boolean> clazz) throws EncodingException {
                binaryEncoder.putBoolean(string, bl);
            }
        });
        BinaryEncoder.a(Byte.class, new a<Byte>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Byte by, Class<? extends Byte> clazz) throws EncodingException {
                binaryEncoder.putSByte(string, by);
            }
        });
        BinaryEncoder.a(UnsignedByte.class, new a<UnsignedByte>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, UnsignedByte unsignedByte, Class<? extends UnsignedByte> clazz) throws EncodingException {
                binaryEncoder.putByte(string, unsignedByte);
            }
        });
        BinaryEncoder.a(Short.class, new a<Short>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Short s2, Class<? extends Short> clazz) throws EncodingException {
                binaryEncoder.putInt16(string, s2);
            }
        });
        BinaryEncoder.a(UnsignedShort.class, new a<UnsignedShort>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, UnsignedShort unsignedShort, Class<? extends UnsignedShort> clazz) throws EncodingException {
                binaryEncoder.putUInt16(string, unsignedShort);
            }
        });
        BinaryEncoder.a(Integer.class, new a<Integer>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Integer n2, Class<? extends Integer> clazz) throws EncodingException {
                binaryEncoder.putInt32(string, n2);
            }
        });
        BinaryEncoder.a(UnsignedInteger.class, new a<UnsignedInteger>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, UnsignedInteger unsignedInteger, Class<? extends UnsignedInteger> clazz) throws EncodingException {
                binaryEncoder.putUInt32(string, unsignedInteger);
            }
        });
        BinaryEncoder.a(Long.class, new a<Long>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Long l2, Class<? extends Long> clazz) throws EncodingException {
                binaryEncoder.putInt64(string, l2);
            }
        });
        BinaryEncoder.a(UnsignedLong.class, new a<UnsignedLong>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, UnsignedLong unsignedLong, Class<? extends UnsignedLong> clazz) throws EncodingException {
                binaryEncoder.putUInt64(string, unsignedLong);
            }
        });
        BinaryEncoder.a(Float.class, new a<Float>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Float f2, Class<? extends Float> clazz) throws EncodingException {
                binaryEncoder.putFloat(string, f2);
            }
        });
        BinaryEncoder.a(Double.class, new a<Double>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Double d2, Class<? extends Double> clazz) throws EncodingException {
                binaryEncoder.putDouble(string, d2);
            }
        });
        BinaryEncoder.a(String.class, new a<String>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, String string2, Class<? extends String> clazz) throws EncodingException {
                binaryEncoder.putString(string, string2);
            }
        });
        BinaryEncoder.a(UUID.class, new a<UUID>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, UUID uUID, Class<? extends UUID> clazz) throws EncodingException {
                binaryEncoder.putGuid(string, uUID);
            }
        });
        BinaryEncoder.a(ByteString.class, new a<ByteString>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, ByteString byteString, Class<? extends ByteString> clazz) throws EncodingException {
                binaryEncoder.putByteString(string, byteString);
            }
        });
        BinaryEncoder.a(XmlElement.class, new a<XmlElement>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, XmlElement xmlElement, Class<? extends XmlElement> clazz) throws EncodingException {
                binaryEncoder.putXmlElement(string, xmlElement);
            }
        });
        BinaryEncoder.a(NodeId.class, new a<NodeId>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, NodeId nodeId, Class<? extends NodeId> clazz) throws EncodingException {
                binaryEncoder.putNodeId(string, nodeId);
            }
        });
        BinaryEncoder.a(ExpandedNodeId.class, new a<ExpandedNodeId>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, ExpandedNodeId expandedNodeId, Class<? extends ExpandedNodeId> clazz) throws EncodingException {
                binaryEncoder.putExpandedNodeId(string, expandedNodeId);
            }
        });
        BinaryEncoder.a(StatusCode.class, new a<StatusCode>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, StatusCode statusCode, Class<? extends StatusCode> clazz) throws EncodingException {
                binaryEncoder.putStatusCode(string, statusCode);
            }
        });
        BinaryEncoder.a(QualifiedName.class, new a<QualifiedName>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, QualifiedName qualifiedName, Class<? extends QualifiedName> clazz) throws EncodingException {
                binaryEncoder.putQualifiedName(string, qualifiedName);
            }
        });
        BinaryEncoder.a(LocalizedText.class, new a<LocalizedText>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, LocalizedText localizedText, Class<? extends LocalizedText> clazz) throws EncodingException {
                binaryEncoder.putLocalizedText(string, localizedText);
            }
        });
        pY = new a<DateTime>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, DateTime dateTime, Class<? extends DateTime> clazz) throws EncodingException {
                binaryEncoder.putDateTime(string, dateTime);
            }
        };
        pZ = new a<ExtensionObject>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, ExtensionObject extensionObject, Class<? extends ExtensionObject> clazz) throws EncodingException {
                binaryEncoder.putExtensionObject(string, extensionObject);
            }
        };
        qa = new a<Structure>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Structure structure, Class<? extends Structure> clazz) throws EncodingException {
                binaryEncoder.putEncodeable(string, clazz, structure);
            }
        };
        qb = new a<DataValue>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, DataValue dataValue, Class<? extends DataValue> clazz) throws EncodingException {
                binaryEncoder.putDataValue(string, dataValue);
            }
        };
        qc = new a<Variant>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Variant variant, Class<? extends Variant> clazz) throws EncodingException {
                binaryEncoder.putVariant(string, variant);
            }
        };
        qd = new a<DiagnosticInfo>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, DiagnosticInfo diagnosticInfo, Class<? extends DiagnosticInfo> clazz) throws EncodingException {
                binaryEncoder.putDiagnosticInfo(string, diagnosticInfo);
            }
        };
        qe = new a<Enumeration>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Enumeration enumeration, Class<? extends Enumeration> clazz) throws EncodingException {
                binaryEncoder.putEnumeration(string, enumeration);
            }
        };
        qf = new a<BigDecimal>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, BigDecimal bigDecimal, Class<? extends BigDecimal> clazz) throws EncodingException {
                binaryEncoder.a(string, bigDecimal);
            }
        };
        qg = new a<OptionSetDataType<?, ?>>(){

            public void b(BinaryEncoder binaryEncoder, String string, OptionSetDataType<?, ?> optionSetDataType, Class<? extends OptionSetDataType<?, ?>> clazz) throws EncodingException {
                binaryEncoder.a(string, optionSetDataType, clazz);
            }

            @Override
            public /* synthetic */ void a(BinaryEncoder binaryEncoder, String string, Object object, Class clazz) throws EncodingException {
                this.b(binaryEncoder, string, (OptionSetDataType)object, clazz);
            }
        };
        BinaryEncoder.a(Object.class, new a<Object>(){

            @Override
            public void a(BinaryEncoder binaryEncoder, String string, Object object, Class<? extends Object> clazz) throws EncodingException {
                if (object instanceof Variant) {
                    logger.warn("Object.class encoder was given a Variant directly, instead should given the value within Variant");
                    qc.a(binaryEncoder, string, (Variant)object, Variant.class);
                } else {
                    qc.a(binaryEncoder, string, new Variant(object), Variant.class);
                }
            }
        });
    }

    private static interface a<T> {
        public void a(BinaryEncoder var1, String var2, T var3, Class<? extends T> var4) throws EncodingException;
    }
}

