/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=668")
public class WriteValue
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.WriteValue_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.WriteValue_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.WriteValue_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.WriteValue;
    public static final StructureSpecification SPECIFICATION;
    private NodeId nodeId;
    private UnsignedInteger attributeId;
    private String indexRange;
    private DataValue value;

    public WriteValue() {
    }

    public WriteValue(NodeId nodeId, UnsignedInteger unsignedInteger, String string, DataValue dataValue) {
        this.nodeId = nodeId;
        this.attributeId = unsignedInteger;
        this.indexRange = string;
        this.value = dataValue;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.attributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public void setIndexRange(String string) {
        this.indexRange = string;
    }

    public DataValue getValue() {
        return this.value;
    }

    public void setValue(DataValue dataValue) {
        this.value = dataValue;
    }

    @Override
    public WriteValue clone() {
        WriteValue writeValue = (WriteValue)super.clone();
        writeValue.nodeId = StructureUtils.clone(this.nodeId);
        writeValue.attributeId = StructureUtils.clone(this.attributeId);
        writeValue.indexRange = StructureUtils.clone(this.indexRange);
        writeValue.value = StructureUtils.clone(this.value);
        return writeValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WriteValue writeValue = (WriteValue)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), writeValue.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), writeValue.getAttributeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIndexRange(), writeValue.getIndexRange())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValue(), writeValue.getValue());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getAttributeId(), this.getIndexRange(), this.getValue());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            this.setNodeId((NodeId)object);
            return;
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            this.setValue((DataValue)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = WriteValue.builder();
        builder.setNodeId(this.getNodeId());
        builder.setAttributeId(this.getAttributeId());
        builder.setIndexRange(this.getIndexRange());
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId.getSpecification());
        builder.addField(Fields.AttributeId.getSpecification());
        builder.addField(Fields.IndexRange.getSpecification());
        builder.addField(Fields.Value.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("WriteValue");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.WriteValueSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return WriteValue.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId nodeId;
        private UnsignedInteger attributeId;
        private String indexRange;
        private DataValue value;

        protected Builder() {
        }

        public Builder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.attributeId = unsignedInteger;
            return this;
        }

        public Builder setIndexRange(String string) {
            this.indexRange = string;
            return this;
        }

        public Builder setValue(DataValue dataValue) {
            this.value = dataValue;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
                this.setNodeId((NodeId)object);
                return this;
            }
            if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            if (Fields.Value.getSpecification().equals(fieldSpecification)) {
                this.setValue((DataValue)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public WriteValue build() {
            return new WriteValue(this.nodeId, this.attributeId, this.indexRange, this.value);
        }
    }

    public static enum Fields {
        NodeId("NodeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        AttributeId("AttributeId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        IndexRange("IndexRange", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=291")), -1),
        Value("Value", DataValue.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=23")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

