/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.WriteResponse;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=671")
public class WriteRequest
extends AbstractStructure
implements ServiceRequest<WriteResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.WriteRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.WriteRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.WriteRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.WriteRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private WriteValue[] nodesToWrite;

    public WriteRequest() {
    }

    public WriteRequest(RequestHeader requestHeader, WriteValue[] writeValueArray) {
        this.requestHeader = requestHeader;
        this.nodesToWrite = writeValueArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public WriteValue[] getNodesToWrite() {
        return this.nodesToWrite;
    }

    public void setNodesToWrite(WriteValue[] writeValueArray) {
        this.nodesToWrite = writeValueArray;
    }

    @Override
    public WriteRequest clone() {
        WriteRequest writeRequest = (WriteRequest)super.clone();
        writeRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        writeRequest.nodesToWrite = StructureUtils.clone(this.nodesToWrite);
        return writeRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WriteRequest writeRequest = (WriteRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), writeRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToWrite(), writeRequest.getNodesToWrite());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getNodesToWrite());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.NodesToWrite.getSpecification().equals(fieldSpecification)) {
            return this.getNodesToWrite();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.NodesToWrite.getSpecification().equals(fieldSpecification)) {
            this.setNodesToWrite((WriteValue[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = WriteRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setNodesToWrite(this.getNodesToWrite());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.NodesToWrite.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("WriteRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.WriteRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return WriteRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private WriteValue[] nodesToWrite;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setNodesToWrite(WriteValue[] writeValueArray) {
            this.nodesToWrite = writeValueArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.NodesToWrite.getSpecification().equals(fieldSpecification)) {
                this.setNodesToWrite((WriteValue[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public WriteRequest build() {
            return new WriteRequest(this.requestHeader, this.nodesToWrite);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        NodesToWrite("NodesToWrite", WriteValue[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=668")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

