/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=511")
public class ViewDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ViewDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ViewDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ViewDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ViewDescription;
    public static final StructureSpecification SPECIFICATION;
    private NodeId viewId;
    private DateTime timestamp;
    private UnsignedInteger viewVersion;

    public ViewDescription() {
    }

    public ViewDescription(NodeId nodeId, DateTime dateTime, UnsignedInteger unsignedInteger) {
        this.viewId = nodeId;
        this.timestamp = dateTime;
        this.viewVersion = unsignedInteger;
    }

    public NodeId getViewId() {
        return this.viewId;
    }

    public void setViewId(NodeId nodeId) {
        this.viewId = nodeId;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(DateTime dateTime) {
        this.timestamp = dateTime;
    }

    public UnsignedInteger getViewVersion() {
        return this.viewVersion;
    }

    public void setViewVersion(UnsignedInteger unsignedInteger) {
        this.viewVersion = unsignedInteger;
    }

    @Override
    public ViewDescription clone() {
        ViewDescription viewDescription = (ViewDescription)super.clone();
        viewDescription.viewId = StructureUtils.clone(this.viewId);
        viewDescription.timestamp = StructureUtils.clone(this.timestamp);
        viewDescription.viewVersion = StructureUtils.clone(this.viewVersion);
        return viewDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewDescription viewDescription = (ViewDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getViewId(), viewDescription.getViewId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTimestamp(), viewDescription.getTimestamp())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getViewVersion(), viewDescription.getViewVersion());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getViewId(), this.getTimestamp(), this.getViewVersion());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ViewId.getSpecification().equals(fieldSpecification)) {
            return this.getViewId();
        }
        if (Fields.Timestamp.getSpecification().equals(fieldSpecification)) {
            return this.getTimestamp();
        }
        if (Fields.ViewVersion.getSpecification().equals(fieldSpecification)) {
            return this.getViewVersion();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ViewId.getSpecification().equals(fieldSpecification)) {
            this.setViewId((NodeId)object);
            return;
        }
        if (Fields.Timestamp.getSpecification().equals(fieldSpecification)) {
            this.setTimestamp((DateTime)object);
            return;
        }
        if (Fields.ViewVersion.getSpecification().equals(fieldSpecification)) {
            this.setViewVersion((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ViewDescription.builder();
        builder.setViewId(this.getViewId());
        builder.setTimestamp(this.getTimestamp());
        builder.setViewVersion(this.getViewVersion());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ViewId.getSpecification());
        builder.addField(Fields.Timestamp.getSpecification());
        builder.addField(Fields.ViewVersion.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ViewDescription");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ViewDescriptionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ViewDescription.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId viewId;
        private DateTime timestamp;
        private UnsignedInteger viewVersion;

        protected Builder() {
        }

        public Builder setViewId(NodeId nodeId) {
            this.viewId = nodeId;
            return this;
        }

        public Builder setTimestamp(DateTime dateTime) {
            this.timestamp = dateTime;
            return this;
        }

        public Builder setViewVersion(UnsignedInteger unsignedInteger) {
            this.viewVersion = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ViewId.getSpecification().equals(fieldSpecification)) {
                this.setViewId((NodeId)object);
                return this;
            }
            if (Fields.Timestamp.getSpecification().equals(fieldSpecification)) {
                this.setTimestamp((DateTime)object);
                return this;
            }
            if (Fields.ViewVersion.getSpecification().equals(fieldSpecification)) {
                this.setViewVersion((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ViewDescription build() {
            return new ViewDescription(this.viewId, this.timestamp, this.viewVersion);
        }
    }

    public static enum Fields {
        ViewId("ViewId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        Timestamp("Timestamp", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        ViewVersion("ViewVersion", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

