/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=373")
public class ViewAttributes
extends NodeAttributes {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ViewAttributes_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ViewAttributes_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ViewAttributes_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ViewAttributes;
    public static final StructureSpecification SPECIFICATION;
    private Boolean containsNoLoops;
    private UnsignedByte eventNotifier;

    public ViewAttributes() {
    }

    public ViewAttributes(Boolean bl, UnsignedByte unsignedByte) {
        this.containsNoLoops = bl;
        this.eventNotifier = unsignedByte;
    }

    public ViewAttributes(UnsignedInteger unsignedInteger, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, Boolean bl, UnsignedByte unsignedByte) {
        super(unsignedInteger, localizedText, localizedText2, unsignedInteger2, unsignedInteger3);
        this.containsNoLoops = bl;
        this.eventNotifier = unsignedByte;
    }

    public Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    public void setContainsNoLoops(Boolean bl) {
        this.containsNoLoops = bl;
    }

    public UnsignedByte getEventNotifier() {
        return this.eventNotifier;
    }

    public void setEventNotifier(UnsignedByte unsignedByte) {
        this.eventNotifier = unsignedByte;
    }

    @Override
    public ViewAttributes clone() {
        ViewAttributes viewAttributes = (ViewAttributes)super.clone();
        viewAttributes.containsNoLoops = StructureUtils.clone(this.containsNoLoops);
        viewAttributes.eventNotifier = StructureUtils.clone(this.eventNotifier);
        return viewAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ViewAttributes viewAttributes = (ViewAttributes)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedAttributes(), viewAttributes.getSpecifiedAttributes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), viewAttributes.getDisplayName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), viewAttributes.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getWriteMask(), viewAttributes.getWriteMask())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserWriteMask(), viewAttributes.getUserWriteMask())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getContainsNoLoops(), viewAttributes.getContainsNoLoops())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEventNotifier(), viewAttributes.getEventNotifier());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask(), this.getContainsNoLoops(), this.getEventNotifier());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
            return this.getSpecifiedAttributes();
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
            return this.getWriteMask();
        }
        if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
            return this.getUserWriteMask();
        }
        if (Fields.ContainsNoLoops.getSpecification().equals(fieldSpecification)) {
            return this.getContainsNoLoops();
        }
        if (Fields.EventNotifier.getSpecification().equals(fieldSpecification)) {
            return this.getEventNotifier();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
            this.setSpecifiedAttributes((UnsignedInteger)object);
            return;
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
            this.setWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
            this.setUserWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.ContainsNoLoops.getSpecification().equals(fieldSpecification)) {
            this.setContainsNoLoops((Boolean)object);
            return;
        }
        if (Fields.EventNotifier.getSpecification().equals(fieldSpecification)) {
            this.setEventNotifier((UnsignedByte)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ViewAttributes.builder();
        builder.setSpecifiedAttributes(this.getSpecifiedAttributes());
        builder.setDisplayName(this.getDisplayName());
        builder.setDescription(this.getDescription());
        builder.setWriteMask(this.getWriteMask());
        builder.setUserWriteMask(this.getUserWriteMask());
        builder.setContainsNoLoops(this.getContainsNoLoops());
        builder.setEventNotifier(this.getEventNotifier());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.SpecifiedAttributes.getSpecification());
        builder.addField(Fields.DisplayName.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.addField(Fields.WriteMask.getSpecification());
        builder.addField(Fields.UserWriteMask.getSpecification());
        builder.addField(Fields.ContainsNoLoops.getSpecification());
        builder.addField(Fields.EventNotifier.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ViewAttributes");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ViewAttributesSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ViewAttributes.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends NodeAttributes.Builder {
        private UnsignedInteger specifiedAttributes;
        private LocalizedText displayName;
        private LocalizedText description;
        private UnsignedInteger writeMask;
        private UnsignedInteger userWriteMask;
        private Boolean containsNoLoops;
        private UnsignedByte eventNotifier;

        protected Builder() {
        }

        @Override
        public Builder setSpecifiedAttributes(UnsignedInteger unsignedInteger) {
            this.specifiedAttributes = unsignedInteger;
            return this;
        }

        @Override
        public Builder setDisplayName(LocalizedText localizedText) {
            this.displayName = localizedText;
            return this;
        }

        @Override
        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        @Override
        public Builder setWriteMask(UnsignedInteger unsignedInteger) {
            this.writeMask = unsignedInteger;
            return this;
        }

        @Override
        public Builder setUserWriteMask(UnsignedInteger unsignedInteger) {
            this.userWriteMask = unsignedInteger;
            return this;
        }

        public Builder setContainsNoLoops(Boolean bl) {
            this.containsNoLoops = bl;
            return this;
        }

        public Builder setEventNotifier(UnsignedByte unsignedByte) {
            this.eventNotifier = unsignedByte;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
                this.setSpecifiedAttributes((UnsignedInteger)object);
                return this;
            }
            if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
                this.setWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
                this.setUserWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.ContainsNoLoops.getSpecification().equals(fieldSpecification)) {
                this.setContainsNoLoops((Boolean)object);
                return this;
            }
            if (Fields.EventNotifier.getSpecification().equals(fieldSpecification)) {
                this.setEventNotifier((UnsignedByte)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ViewAttributes build() {
            return new ViewAttributes(this.specifiedAttributes, this.displayName, this.description, this.writeMask, this.userWriteMask, this.containsNoLoops, this.eventNotifier);
        }
    }

    public static enum Fields {
        SpecifiedAttributes("SpecifiedAttributes", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        DisplayName("DisplayName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        WriteMask("WriteMask", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        UserWriteMask("UserWriteMask", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        ContainsNoLoops("ContainsNoLoops", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        EventNotifier("EventNotifier", UnsignedByte.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=3")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

