/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=322")
public class UserNameIdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.UserNameIdentityToken_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.UserNameIdentityToken_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.UserNameIdentityToken_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.UserNameIdentityToken;
    public static final StructureSpecification SPECIFICATION;
    private String userName;
    private ByteString password;
    private String encryptionAlgorithm;

    public UserNameIdentityToken() {
    }

    public UserNameIdentityToken(String string, ByteString byteString, String string2) {
        this.userName = string;
        this.password = byteString;
        this.encryptionAlgorithm = string2;
    }

    public UserNameIdentityToken(String string, String string2, ByteString byteString, String string3) {
        super(string);
        this.userName = string2;
        this.password = byteString;
        this.encryptionAlgorithm = string3;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public ByteString getPassword() {
        return this.password;
    }

    public void setPassword(ByteString byteString) {
        this.password = byteString;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    @Override
    public UserNameIdentityToken clone() {
        UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)super.clone();
        userNameIdentityToken.userName = StructureUtils.clone(this.userName);
        userNameIdentityToken.password = StructureUtils.clone(this.password);
        userNameIdentityToken.encryptionAlgorithm = StructureUtils.clone(this.encryptionAlgorithm);
        return userNameIdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), userNameIdentityToken.getPolicyId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserName(), userNameIdentityToken.getUserName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getPassword(), userNameIdentityToken.getPassword())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEncryptionAlgorithm(), userNameIdentityToken.getEncryptionAlgorithm());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId(), this.getUserName(), this.getPassword(), this.getEncryptionAlgorithm());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
            return this.getUserName();
        }
        if (Fields.Password.getSpecification().equals(fieldSpecification)) {
            return this.getPassword();
        }
        if (Fields.EncryptionAlgorithm.getSpecification().equals(fieldSpecification)) {
            return this.getEncryptionAlgorithm();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
            this.setUserName((String)object);
            return;
        }
        if (Fields.Password.getSpecification().equals(fieldSpecification)) {
            this.setPassword((ByteString)object);
            return;
        }
        if (Fields.EncryptionAlgorithm.getSpecification().equals(fieldSpecification)) {
            this.setEncryptionAlgorithm((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = UserNameIdentityToken.builder();
        builder.setPolicyId(this.getPolicyId());
        builder.setUserName(this.getUserName());
        builder.setPassword(this.getPassword());
        builder.setEncryptionAlgorithm(this.getEncryptionAlgorithm());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId.getSpecification());
        builder.addField(Fields.UserName.getSpecification());
        builder.addField(Fields.Password.getSpecification());
        builder.addField(Fields.EncryptionAlgorithm.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("UserNameIdentityToken");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.UserNameIdentityTokenSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return UserNameIdentityToken.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String policyId;
        private String userName;
        private ByteString password;
        private String encryptionAlgorithm;

        protected Builder() {
        }

        @Override
        public Builder setPolicyId(String string) {
            this.policyId = string;
            return this;
        }

        public Builder setUserName(String string) {
            this.userName = string;
            return this;
        }

        public Builder setPassword(ByteString byteString) {
            this.password = byteString;
            return this;
        }

        public Builder setEncryptionAlgorithm(String string) {
            this.encryptionAlgorithm = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
                this.setUserName((String)object);
                return this;
            }
            if (Fields.Password.getSpecification().equals(fieldSpecification)) {
                this.setPassword((ByteString)object);
                return this;
            }
            if (Fields.EncryptionAlgorithm.getSpecification().equals(fieldSpecification)) {
                this.setEncryptionAlgorithm((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public UserNameIdentityToken build() {
            return new UserNameIdentityToken(this.policyId, this.userName, this.password, this.encryptionAlgorithm);
        }
    }

    public static enum Fields {
        PolicyId("PolicyId", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        UserName("UserName", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        Password("Password", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1),
        EncryptionAlgorithm("EncryptionAlgorithm", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

