/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.UnregisterNodesResponse;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=564")
public class UnregisterNodesRequest
extends AbstractStructure
implements ServiceRequest<UnregisterNodesResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.UnregisterNodesRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.UnregisterNodesRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.UnregisterNodesRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.UnregisterNodesRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private NodeId[] nodesToUnregister;

    public UnregisterNodesRequest() {
    }

    public UnregisterNodesRequest(RequestHeader requestHeader, NodeId[] nodeIdArray) {
        this.requestHeader = requestHeader;
        this.nodesToUnregister = nodeIdArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public NodeId[] getNodesToUnregister() {
        return this.nodesToUnregister;
    }

    public void setNodesToUnregister(NodeId[] nodeIdArray) {
        this.nodesToUnregister = nodeIdArray;
    }

    @Override
    public UnregisterNodesRequest clone() {
        UnregisterNodesRequest unregisterNodesRequest = (UnregisterNodesRequest)super.clone();
        unregisterNodesRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        unregisterNodesRequest.nodesToUnregister = StructureUtils.clone(this.nodesToUnregister);
        return unregisterNodesRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnregisterNodesRequest unregisterNodesRequest = (UnregisterNodesRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), unregisterNodesRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToUnregister(), unregisterNodesRequest.getNodesToUnregister());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getNodesToUnregister());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.NodesToUnregister.getSpecification().equals(fieldSpecification)) {
            return this.getNodesToUnregister();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.NodesToUnregister.getSpecification().equals(fieldSpecification)) {
            this.setNodesToUnregister((NodeId[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = UnregisterNodesRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setNodesToUnregister(this.getNodesToUnregister());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.NodesToUnregister.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("UnregisterNodesRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.UnregisterNodesRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return UnregisterNodesRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private NodeId[] nodesToUnregister;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setNodesToUnregister(NodeId[] nodeIdArray) {
            this.nodesToUnregister = nodeIdArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.NodesToUnregister.getSpecification().equals(fieldSpecification)) {
                this.setNodesToUnregister((NodeId[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public UnregisterNodesRequest build() {
            return new UnregisterNodesRequest(this.requestHeader, this.nodesToUnregister);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        NodesToUnregister("NodesToUnregister", NodeId[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

