/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12554")
public class TrustListDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.TrustListDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.TrustListDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.TrustListDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.TrustListDataType;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger specifiedLists;
    private ByteString[] trustedCertificates;
    private ByteString[] trustedCrls;
    private ByteString[] issuerCertificates;
    private ByteString[] issuerCrls;

    public TrustListDataType() {
    }

    public TrustListDataType(UnsignedInteger unsignedInteger, ByteString[] byteStringArray, ByteString[] byteStringArray2, ByteString[] byteStringArray3, ByteString[] byteStringArray4) {
        this.specifiedLists = unsignedInteger;
        this.trustedCertificates = byteStringArray;
        this.trustedCrls = byteStringArray2;
        this.issuerCertificates = byteStringArray3;
        this.issuerCrls = byteStringArray4;
    }

    public UnsignedInteger getSpecifiedLists() {
        return this.specifiedLists;
    }

    public void setSpecifiedLists(UnsignedInteger unsignedInteger) {
        this.specifiedLists = unsignedInteger;
    }

    public ByteString[] getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public void setTrustedCertificates(ByteString[] byteStringArray) {
        this.trustedCertificates = byteStringArray;
    }

    public ByteString[] getTrustedCrls() {
        return this.trustedCrls;
    }

    public void setTrustedCrls(ByteString[] byteStringArray) {
        this.trustedCrls = byteStringArray;
    }

    public ByteString[] getIssuerCertificates() {
        return this.issuerCertificates;
    }

    public void setIssuerCertificates(ByteString[] byteStringArray) {
        this.issuerCertificates = byteStringArray;
    }

    public ByteString[] getIssuerCrls() {
        return this.issuerCrls;
    }

    public void setIssuerCrls(ByteString[] byteStringArray) {
        this.issuerCrls = byteStringArray;
    }

    @Override
    public TrustListDataType clone() {
        TrustListDataType trustListDataType = (TrustListDataType)super.clone();
        trustListDataType.specifiedLists = StructureUtils.clone(this.specifiedLists);
        trustListDataType.trustedCertificates = StructureUtils.clone(this.trustedCertificates);
        trustListDataType.trustedCrls = StructureUtils.clone(this.trustedCrls);
        trustListDataType.issuerCertificates = StructureUtils.clone(this.issuerCertificates);
        trustListDataType.issuerCrls = StructureUtils.clone(this.issuerCrls);
        return trustListDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TrustListDataType trustListDataType = (TrustListDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedLists(), trustListDataType.getSpecifiedLists())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTrustedCertificates(), trustListDataType.getTrustedCertificates())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTrustedCrls(), trustListDataType.getTrustedCrls())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIssuerCertificates(), trustListDataType.getIssuerCertificates())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIssuerCrls(), trustListDataType.getIssuerCrls());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getSpecifiedLists(), this.getTrustedCertificates(), this.getTrustedCrls(), this.getIssuerCertificates(), this.getIssuerCrls());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SpecifiedLists.getSpecification().equals(fieldSpecification)) {
            return this.getSpecifiedLists();
        }
        if (Fields.TrustedCertificates.getSpecification().equals(fieldSpecification)) {
            return this.getTrustedCertificates();
        }
        if (Fields.TrustedCrls.getSpecification().equals(fieldSpecification)) {
            return this.getTrustedCrls();
        }
        if (Fields.IssuerCertificates.getSpecification().equals(fieldSpecification)) {
            return this.getIssuerCertificates();
        }
        if (Fields.IssuerCrls.getSpecification().equals(fieldSpecification)) {
            return this.getIssuerCrls();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SpecifiedLists.getSpecification().equals(fieldSpecification)) {
            this.setSpecifiedLists((UnsignedInteger)object);
            return;
        }
        if (Fields.TrustedCertificates.getSpecification().equals(fieldSpecification)) {
            this.setTrustedCertificates((ByteString[])object);
            return;
        }
        if (Fields.TrustedCrls.getSpecification().equals(fieldSpecification)) {
            this.setTrustedCrls((ByteString[])object);
            return;
        }
        if (Fields.IssuerCertificates.getSpecification().equals(fieldSpecification)) {
            this.setIssuerCertificates((ByteString[])object);
            return;
        }
        if (Fields.IssuerCrls.getSpecification().equals(fieldSpecification)) {
            this.setIssuerCrls((ByteString[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = TrustListDataType.builder();
        builder.setSpecifiedLists(this.getSpecifiedLists());
        builder.setTrustedCertificates(this.getTrustedCertificates());
        builder.setTrustedCrls(this.getTrustedCrls());
        builder.setIssuerCertificates(this.getIssuerCertificates());
        builder.setIssuerCrls(this.getIssuerCrls());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.SpecifiedLists.getSpecification());
        builder.addField(Fields.TrustedCertificates.getSpecification());
        builder.addField(Fields.TrustedCrls.getSpecification());
        builder.addField(Fields.IssuerCertificates.getSpecification());
        builder.addField(Fields.IssuerCrls.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("TrustListDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.TrustListDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return TrustListDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger specifiedLists;
        private ByteString[] trustedCertificates;
        private ByteString[] trustedCrls;
        private ByteString[] issuerCertificates;
        private ByteString[] issuerCrls;

        protected Builder() {
        }

        public Builder setSpecifiedLists(UnsignedInteger unsignedInteger) {
            this.specifiedLists = unsignedInteger;
            return this;
        }

        public Builder setTrustedCertificates(ByteString[] byteStringArray) {
            this.trustedCertificates = byteStringArray;
            return this;
        }

        public Builder setTrustedCrls(ByteString[] byteStringArray) {
            this.trustedCrls = byteStringArray;
            return this;
        }

        public Builder setIssuerCertificates(ByteString[] byteStringArray) {
            this.issuerCertificates = byteStringArray;
            return this;
        }

        public Builder setIssuerCrls(ByteString[] byteStringArray) {
            this.issuerCrls = byteStringArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SpecifiedLists.getSpecification().equals(fieldSpecification)) {
                this.setSpecifiedLists((UnsignedInteger)object);
                return this;
            }
            if (Fields.TrustedCertificates.getSpecification().equals(fieldSpecification)) {
                this.setTrustedCertificates((ByteString[])object);
                return this;
            }
            if (Fields.TrustedCrls.getSpecification().equals(fieldSpecification)) {
                this.setTrustedCrls((ByteString[])object);
                return this;
            }
            if (Fields.IssuerCertificates.getSpecification().equals(fieldSpecification)) {
                this.setIssuerCertificates((ByteString[])object);
                return this;
            }
            if (Fields.IssuerCrls.getSpecification().equals(fieldSpecification)) {
                this.setIssuerCrls((ByteString[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public TrustListDataType build() {
            return new TrustListDataType(this.specifiedLists, this.trustedCertificates, this.trustedCrls, this.issuerCertificates, this.issuerCrls);
        }
    }

    public static enum Fields {
        SpecifiedLists("SpecifiedLists", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        TrustedCertificates("TrustedCertificates", ByteString[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), 1),
        TrustedCrls("TrustedCrls", ByteString[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), 1),
        IssuerCertificates("IssuerCertificates", ByteString[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), 1),
        IssuerCrls("IssuerCrls", ByteString[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

