/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.BrowsePath;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.TranslateBrowsePathsToNodeIdsResponse;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=552")
public class TranslateBrowsePathsToNodeIdsRequest
extends AbstractStructure
implements ServiceRequest<TranslateBrowsePathsToNodeIdsResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.TranslateBrowsePathsToNodeIdsRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.TranslateBrowsePathsToNodeIdsRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.TranslateBrowsePathsToNodeIdsRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.TranslateBrowsePathsToNodeIdsRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private BrowsePath[] browsePaths;

    public TranslateBrowsePathsToNodeIdsRequest() {
    }

    public TranslateBrowsePathsToNodeIdsRequest(RequestHeader requestHeader, BrowsePath[] browsePathArray) {
        this.requestHeader = requestHeader;
        this.browsePaths = browsePathArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public BrowsePath[] getBrowsePaths() {
        return this.browsePaths;
    }

    public void setBrowsePaths(BrowsePath[] browsePathArray) {
        this.browsePaths = browsePathArray;
    }

    @Override
    public TranslateBrowsePathsToNodeIdsRequest clone() {
        TranslateBrowsePathsToNodeIdsRequest translateBrowsePathsToNodeIdsRequest = (TranslateBrowsePathsToNodeIdsRequest)super.clone();
        translateBrowsePathsToNodeIdsRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        translateBrowsePathsToNodeIdsRequest.browsePaths = StructureUtils.clone(this.browsePaths);
        return translateBrowsePathsToNodeIdsRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TranslateBrowsePathsToNodeIdsRequest translateBrowsePathsToNodeIdsRequest = (TranslateBrowsePathsToNodeIdsRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), translateBrowsePathsToNodeIdsRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getBrowsePaths(), translateBrowsePathsToNodeIdsRequest.getBrowsePaths());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getBrowsePaths());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.BrowsePaths.getSpecification().equals(fieldSpecification)) {
            return this.getBrowsePaths();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.BrowsePaths.getSpecification().equals(fieldSpecification)) {
            this.setBrowsePaths((BrowsePath[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = TranslateBrowsePathsToNodeIdsRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setBrowsePaths(this.getBrowsePaths());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.BrowsePaths.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("TranslateBrowsePathsToNodeIdsRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.TranslateBrowsePathsToNodeIdsRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return TranslateBrowsePathsToNodeIdsRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private BrowsePath[] browsePaths;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setBrowsePaths(BrowsePath[] browsePathArray) {
            this.browsePaths = browsePathArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.BrowsePaths.getSpecification().equals(fieldSpecification)) {
                this.setBrowsePaths((BrowsePath[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public TranslateBrowsePathsToNodeIdsRequest build() {
            return new TranslateBrowsePathsToNodeIdsRequest(this.requestHeader, this.browsePaths);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        BrowsePaths("BrowsePaths", BrowsePath[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=543")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

