/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.TransferResult;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=842")
public class TransferSubscriptionsResponse
extends AbstractStructure
implements ServiceResponse {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.TransferSubscriptionsResponse_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.TransferSubscriptionsResponse_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.TransferSubscriptionsResponse_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.TransferSubscriptionsResponse;
    public static final StructureSpecification SPECIFICATION;
    private ResponseHeader responseHeader;
    private TransferResult[] results;
    private DiagnosticInfo[] diagnosticInfos;

    public TransferSubscriptionsResponse() {
    }

    public TransferSubscriptionsResponse(ResponseHeader responseHeader, TransferResult[] transferResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.responseHeader = responseHeader;
        this.results = transferResultArray;
        this.diagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public TransferResult[] getResults() {
        return this.results;
    }

    public void setResults(TransferResult[] transferResultArray) {
        this.results = transferResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.diagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public TransferSubscriptionsResponse clone() {
        TransferSubscriptionsResponse transferSubscriptionsResponse = (TransferSubscriptionsResponse)super.clone();
        transferSubscriptionsResponse.responseHeader = StructureUtils.clone(this.responseHeader);
        transferSubscriptionsResponse.results = StructureUtils.clone(this.results);
        transferSubscriptionsResponse.diagnosticInfos = StructureUtils.clone(this.diagnosticInfos);
        return transferSubscriptionsResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferSubscriptionsResponse transferSubscriptionsResponse = (TransferSubscriptionsResponse)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResponseHeader(), transferSubscriptionsResponse.getResponseHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getResults(), transferSubscriptionsResponse.getResults())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiagnosticInfos(), transferSubscriptionsResponse.getDiagnosticInfos());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getResponseHeader(), this.getResults(), this.getDiagnosticInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            return this.getResponseHeader();
        }
        if (Fields.Results.getSpecification().equals(fieldSpecification)) {
            return this.getResults();
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getDiagnosticInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            this.setResponseHeader((ResponseHeader)object);
            return;
        }
        if (Fields.Results.getSpecification().equals(fieldSpecification)) {
            this.setResults((TransferResult[])object);
            return;
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = TransferSubscriptionsResponse.builder();
        builder.setResponseHeader(this.getResponseHeader());
        builder.setResults(this.getResults());
        builder.setDiagnosticInfos(this.getDiagnosticInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResponseHeader.getSpecification());
        builder.addField(Fields.Results.getSpecification());
        builder.addField(Fields.DiagnosticInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("TransferSubscriptionsResponse");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.TransferSubscriptionsResponseSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return TransferSubscriptionsResponse.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ResponseHeader responseHeader;
        private TransferResult[] results;
        private DiagnosticInfo[] diagnosticInfos;

        protected Builder() {
        }

        public Builder setResponseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return this;
        }

        public Builder setResults(TransferResult[] transferResultArray) {
            this.results = transferResultArray;
            return this;
        }

        public Builder setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.diagnosticInfos = diagnosticInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
                this.setResponseHeader((ResponseHeader)object);
                return this;
            }
            if (Fields.Results.getSpecification().equals(fieldSpecification)) {
                this.setResults((TransferResult[])object);
                return this;
            }
            if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public TransferSubscriptionsResponse build() {
            return new TransferSubscriptionsResponse(this.responseHeader, this.results, this.diagnosticInfos);
        }
    }

    public static enum Fields {
        ResponseHeader("ResponseHeader", ResponseHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=392")), -1),
        Results("Results", TransferResult[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=836")), 1),
        DiagnosticInfos("DiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

