/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=839")
public class TransferSubscriptionsRequest
extends AbstractStructure
implements ServiceRequest<TransferSubscriptionsResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.TransferSubscriptionsRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.TransferSubscriptionsRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.TransferSubscriptionsRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.TransferSubscriptionsRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private UnsignedInteger[] subscriptionIds;
    private Boolean sendInitialValues;

    public TransferSubscriptionsRequest() {
    }

    public TransferSubscriptionsRequest(RequestHeader requestHeader, UnsignedInteger[] unsignedIntegerArray, Boolean bl) {
        this.requestHeader = requestHeader;
        this.subscriptionIds = unsignedIntegerArray;
        this.sendInitialValues = bl;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public UnsignedInteger[] getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public void setSubscriptionIds(UnsignedInteger[] unsignedIntegerArray) {
        this.subscriptionIds = unsignedIntegerArray;
    }

    public Boolean getSendInitialValues() {
        return this.sendInitialValues;
    }

    public void setSendInitialValues(Boolean bl) {
        this.sendInitialValues = bl;
    }

    @Override
    public TransferSubscriptionsRequest clone() {
        TransferSubscriptionsRequest transferSubscriptionsRequest = (TransferSubscriptionsRequest)super.clone();
        transferSubscriptionsRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        transferSubscriptionsRequest.subscriptionIds = StructureUtils.clone(this.subscriptionIds);
        transferSubscriptionsRequest.sendInitialValues = StructureUtils.clone(this.sendInitialValues);
        return transferSubscriptionsRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferSubscriptionsRequest transferSubscriptionsRequest = (TransferSubscriptionsRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), transferSubscriptionsRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSubscriptionIds(), transferSubscriptionsRequest.getSubscriptionIds())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSendInitialValues(), transferSubscriptionsRequest.getSendInitialValues());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getSubscriptionIds(), this.getSendInitialValues());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.SubscriptionIds.getSpecification().equals(fieldSpecification)) {
            return this.getSubscriptionIds();
        }
        if (Fields.SendInitialValues.getSpecification().equals(fieldSpecification)) {
            return this.getSendInitialValues();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.SubscriptionIds.getSpecification().equals(fieldSpecification)) {
            this.setSubscriptionIds((UnsignedInteger[])object);
            return;
        }
        if (Fields.SendInitialValues.getSpecification().equals(fieldSpecification)) {
            this.setSendInitialValues((Boolean)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = TransferSubscriptionsRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setSubscriptionIds(this.getSubscriptionIds());
        builder.setSendInitialValues(this.getSendInitialValues());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.SubscriptionIds.getSpecification());
        builder.addField(Fields.SendInitialValues.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("TransferSubscriptionsRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.TransferSubscriptionsRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return TransferSubscriptionsRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private UnsignedInteger[] subscriptionIds;
        private Boolean sendInitialValues;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setSubscriptionIds(UnsignedInteger[] unsignedIntegerArray) {
            this.subscriptionIds = unsignedIntegerArray;
            return this;
        }

        public Builder setSendInitialValues(Boolean bl) {
            this.sendInitialValues = bl;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.SubscriptionIds.getSpecification().equals(fieldSpecification)) {
                this.setSubscriptionIds((UnsignedInteger[])object);
                return this;
            }
            if (Fields.SendInitialValues.getSpecification().equals(fieldSpecification)) {
                this.setSendInitialValues((Boolean)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public TransferSubscriptionsRequest build() {
            return new TransferSubscriptionsRequest(this.requestHeader, this.subscriptionIds, this.sendInitialValues);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        SubscriptionIds("SubscriptionIds", UnsignedInteger[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), 1),
        SendInitialValues("SendInitialValues", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

