/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=836")
public class TransferResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.TransferResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.TransferResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.TransferResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.TransferResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private UnsignedInteger[] availableSequenceNumbers;

    public TransferResult() {
    }

    public TransferResult(StatusCode statusCode, UnsignedInteger[] unsignedIntegerArray) {
        this.statusCode = statusCode;
        this.availableSequenceNumbers = unsignedIntegerArray;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        return this.availableSequenceNumbers;
    }

    public void setAvailableSequenceNumbers(UnsignedInteger[] unsignedIntegerArray) {
        this.availableSequenceNumbers = unsignedIntegerArray;
    }

    @Override
    public TransferResult clone() {
        TransferResult transferResult = (TransferResult)super.clone();
        transferResult.statusCode = StructureUtils.clone(this.statusCode);
        transferResult.availableSequenceNumbers = StructureUtils.clone(this.availableSequenceNumbers);
        return transferResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferResult transferResult = (TransferResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), transferResult.getStatusCode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAvailableSequenceNumbers(), transferResult.getAvailableSequenceNumbers());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getAvailableSequenceNumbers());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.AvailableSequenceNumbers.getSpecification().equals(fieldSpecification)) {
            return this.getAvailableSequenceNumbers();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.AvailableSequenceNumbers.getSpecification().equals(fieldSpecification)) {
            this.setAvailableSequenceNumbers((UnsignedInteger[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = TransferResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setAvailableSequenceNumbers(this.getAvailableSequenceNumbers());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.AvailableSequenceNumbers.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("TransferResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.TransferResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return TransferResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private UnsignedInteger[] availableSequenceNumbers;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setAvailableSequenceNumbers(UnsignedInteger[] unsignedIntegerArray) {
            this.availableSequenceNumbers = unsignedIntegerArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.AvailableSequenceNumbers.getSpecification().equals(fieldSpecification)) {
                this.setAvailableSequenceNumbers((UnsignedInteger[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public TransferResult build() {
            return new TransferResult(this.statusCode, this.availableSequenceNumbers);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        AvailableSequenceNumbers("AvailableSequenceNumbers", UnsignedInteger[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=289")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

