/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.Vector;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18808")
public class ThreeDVector
extends Vector {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ThreeDVector_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ThreeDVector_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ThreeDVector_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ThreeDVector;
    public static final StructureSpecification SPECIFICATION;
    private Double x;
    private Double y;
    private Double z;

    public ThreeDVector() {
    }

    public ThreeDVector(Double d2, Double d3, Double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double d2) {
        this.x = d2;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double d2) {
        this.y = d2;
    }

    public Double getZ() {
        return this.z;
    }

    public void setZ(Double d2) {
        this.z = d2;
    }

    @Override
    public ThreeDVector clone() {
        ThreeDVector threeDVector = (ThreeDVector)super.clone();
        threeDVector.x = StructureUtils.clone(this.x);
        threeDVector.y = StructureUtils.clone(this.y);
        threeDVector.z = StructureUtils.clone(this.z);
        return threeDVector;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ThreeDVector threeDVector = (ThreeDVector)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getX(), threeDVector.getX())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getY(), threeDVector.getY())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getZ(), threeDVector.getZ());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getX(), this.getY(), this.getZ());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.X.getSpecification().equals(fieldSpecification)) {
            return this.getX();
        }
        if (Fields.Y.getSpecification().equals(fieldSpecification)) {
            return this.getY();
        }
        if (Fields.Z.getSpecification().equals(fieldSpecification)) {
            return this.getZ();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.X.getSpecification().equals(fieldSpecification)) {
            this.setX((Double)object);
            return;
        }
        if (Fields.Y.getSpecification().equals(fieldSpecification)) {
            this.setY((Double)object);
            return;
        }
        if (Fields.Z.getSpecification().equals(fieldSpecification)) {
            this.setZ((Double)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ThreeDVector.builder();
        builder.setX(this.getX());
        builder.setY(this.getY());
        builder.setZ(this.getZ());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.X.getSpecification());
        builder.addField(Fields.Y.getSpecification());
        builder.addField(Fields.Z.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ThreeDVector");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ThreeDVectorSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ThreeDVector.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends Vector.Builder {
        private Double x;
        private Double y;
        private Double z;

        protected Builder() {
        }

        public Builder setX(Double d2) {
            this.x = d2;
            return this;
        }

        public Builder setY(Double d2) {
            this.y = d2;
            return this;
        }

        public Builder setZ(Double d2) {
            this.z = d2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.X.getSpecification().equals(fieldSpecification)) {
                this.setX((Double)object);
                return this;
            }
            if (Fields.Y.getSpecification().equals(fieldSpecification)) {
                this.setY((Double)object);
                return this;
            }
            if (Fields.Z.getSpecification().equals(fieldSpecification)) {
                this.setZ((Double)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ThreeDVector build() {
            return new ThreeDVector(this.x, this.y, this.z);
        }
    }

    public static enum Fields {
        X("X", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1),
        Y("Y", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1),
        Z("Z", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

