/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.Orientation;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18812")
public class ThreeDOrientation
extends Orientation {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ThreeDOrientation_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ThreeDOrientation_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ThreeDOrientation_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ThreeDOrientation;
    public static final StructureSpecification SPECIFICATION;
    private Double a;
    private Double b;
    private Double c;

    public ThreeDOrientation() {
    }

    public ThreeDOrientation(Double d2, Double d3, Double d4) {
        this.a = d2;
        this.b = d3;
        this.c = d4;
    }

    public Double getA() {
        return this.a;
    }

    public void setA(Double d2) {
        this.a = d2;
    }

    public Double getB() {
        return this.b;
    }

    public void setB(Double d2) {
        this.b = d2;
    }

    public Double getC() {
        return this.c;
    }

    public void setC(Double d2) {
        this.c = d2;
    }

    @Override
    public ThreeDOrientation clone() {
        ThreeDOrientation threeDOrientation = (ThreeDOrientation)super.clone();
        threeDOrientation.a = StructureUtils.clone(this.a);
        threeDOrientation.b = StructureUtils.clone(this.b);
        threeDOrientation.c = StructureUtils.clone(this.c);
        return threeDOrientation;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ThreeDOrientation threeDOrientation = (ThreeDOrientation)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getA(), threeDOrientation.getA())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getB(), threeDOrientation.getB())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getC(), threeDOrientation.getC());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getA(), this.getB(), this.getC());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.A.getSpecification().equals(fieldSpecification)) {
            return this.getA();
        }
        if (Fields.B.getSpecification().equals(fieldSpecification)) {
            return this.getB();
        }
        if (Fields.C.getSpecification().equals(fieldSpecification)) {
            return this.getC();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.A.getSpecification().equals(fieldSpecification)) {
            this.setA((Double)object);
            return;
        }
        if (Fields.B.getSpecification().equals(fieldSpecification)) {
            this.setB((Double)object);
            return;
        }
        if (Fields.C.getSpecification().equals(fieldSpecification)) {
            this.setC((Double)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ThreeDOrientation.builder();
        builder.setA(this.getA());
        builder.setB(this.getB());
        builder.setC(this.getC());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.A.getSpecification());
        builder.addField(Fields.B.getSpecification());
        builder.addField(Fields.C.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ThreeDOrientation");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ThreeDOrientationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ThreeDOrientation.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends Orientation.Builder {
        private Double a;
        private Double b;
        private Double c;

        protected Builder() {
        }

        public Builder setA(Double d2) {
            this.a = d2;
            return this;
        }

        public Builder setB(Double d2) {
            this.b = d2;
            return this;
        }

        public Builder setC(Double d2) {
            this.c = d2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.A.getSpecification().equals(fieldSpecification)) {
                this.setA((Double)object);
                return this;
            }
            if (Fields.B.getSpecification().equals(fieldSpecification)) {
                this.setB((Double)object);
                return this;
            }
            if (Fields.C.getSpecification().equals(fieldSpecification)) {
                this.setC((Double)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ThreeDOrientation build() {
            return new ThreeDOrientation(this.a, this.b, this.c);
        }
    }

    public static enum Fields {
        A("A", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1),
        B("B", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1),
        C("C", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

