/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeDescription;
import com.prosysopc.ua.stack.core.StructureDefinition;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15487")
public class StructureDescription
extends DataTypeDescription {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.StructureDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.StructureDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.StructureDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.StructureDescription;
    public static final StructureSpecification SPECIFICATION;
    private StructureDefinition structureDefinition;

    public StructureDescription() {
    }

    public StructureDescription(StructureDefinition structureDefinition) {
        this.structureDefinition = structureDefinition;
    }

    public StructureDescription(NodeId nodeId, QualifiedName qualifiedName, StructureDefinition structureDefinition) {
        super(nodeId, qualifiedName);
        this.structureDefinition = structureDefinition;
    }

    public StructureDefinition getStructureDefinition() {
        return this.structureDefinition;
    }

    public void setStructureDefinition(StructureDefinition structureDefinition) {
        this.structureDefinition = structureDefinition;
    }

    @Override
    public StructureDescription clone() {
        StructureDescription structureDescription = (StructureDescription)super.clone();
        structureDescription.structureDefinition = StructureUtils.clone(this.structureDefinition);
        return structureDescription;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StructureDescription structureDescription = (StructureDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getDataTypeId(), structureDescription.getDataTypeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), structureDescription.getName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getStructureDefinition(), structureDescription.getStructureDefinition());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getDataTypeId(), this.getName(), this.getStructureDefinition());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DataTypeId.getSpecification().equals(fieldSpecification)) {
            return this.getDataTypeId();
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.StructureDefinition.getSpecification().equals(fieldSpecification)) {
            return this.getStructureDefinition();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DataTypeId.getSpecification().equals(fieldSpecification)) {
            this.setDataTypeId((NodeId)object);
            return;
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            this.setName((QualifiedName)object);
            return;
        }
        if (Fields.StructureDefinition.getSpecification().equals(fieldSpecification)) {
            this.setStructureDefinition((StructureDefinition)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = StructureDescription.builder();
        builder.setDataTypeId(this.getDataTypeId());
        builder.setName(this.getName());
        builder.setStructureDefinition(this.getStructureDefinition());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.DataTypeId.getSpecification());
        builder.addField(Fields.Name.getSpecification());
        builder.addField(Fields.StructureDefinition.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("StructureDescription");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.StructureDescriptionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return StructureDescription.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeDescription.Builder {
        private NodeId dataTypeId;
        private QualifiedName name;
        private StructureDefinition structureDefinition;

        protected Builder() {
        }

        @Override
        public Builder setDataTypeId(NodeId nodeId) {
            this.dataTypeId = nodeId;
            return this;
        }

        @Override
        public Builder setName(QualifiedName qualifiedName) {
            this.name = qualifiedName;
            return this;
        }

        public Builder setStructureDefinition(StructureDefinition structureDefinition) {
            this.structureDefinition = structureDefinition;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DataTypeId.getSpecification().equals(fieldSpecification)) {
                this.setDataTypeId((NodeId)object);
                return this;
            }
            if (Fields.Name.getSpecification().equals(fieldSpecification)) {
                this.setName((QualifiedName)object);
                return this;
            }
            if (Fields.StructureDefinition.getSpecification().equals(fieldSpecification)) {
                this.setStructureDefinition((StructureDefinition)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public StructureDescription build() {
            return new StructureDescription(this.dataTypeId, this.name, this.structureDefinition);
        }
    }

    public static enum Fields {
        DataTypeId("DataTypeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        Name("Name", QualifiedName.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20")), -1),
        StructureDefinition("StructureDefinition", StructureDefinition.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=99")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

