/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.core.StructureType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=99")
public class StructureDefinition
extends DataTypeDefinition {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.StructureDefinition_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.StructureDefinition_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.StructureDefinition_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.StructureDefinition;
    public static final StructureSpecification SPECIFICATION;
    private NodeId defaultEncodingId;
    private NodeId baseDataType;
    private StructureType structureType;
    private StructureField[] fields;

    public StructureDefinition() {
    }

    public StructureDefinition(NodeId nodeId, NodeId nodeId2, StructureType structureType, StructureField[] structureFieldArray) {
        this.defaultEncodingId = nodeId;
        this.baseDataType = nodeId2;
        this.structureType = structureType;
        this.fields = structureFieldArray;
    }

    public NodeId getDefaultEncodingId() {
        return this.defaultEncodingId;
    }

    public void setDefaultEncodingId(NodeId nodeId) {
        this.defaultEncodingId = nodeId;
    }

    public NodeId getBaseDataType() {
        return this.baseDataType;
    }

    public void setBaseDataType(NodeId nodeId) {
        this.baseDataType = nodeId;
    }

    public StructureType getStructureType() {
        return this.structureType;
    }

    public void setStructureType(StructureType structureType) {
        this.structureType = structureType;
    }

    public StructureField[] getFields() {
        return this.fields;
    }

    public void setFields(StructureField[] structureFieldArray) {
        this.fields = structureFieldArray;
    }

    @Override
    public StructureDefinition clone() {
        StructureDefinition structureDefinition = (StructureDefinition)super.clone();
        structureDefinition.defaultEncodingId = StructureUtils.clone(this.defaultEncodingId);
        structureDefinition.baseDataType = StructureUtils.clone(this.baseDataType);
        structureDefinition.structureType = StructureUtils.clone(this.structureType);
        structureDefinition.fields = StructureUtils.clone(this.fields);
        return structureDefinition;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StructureDefinition structureDefinition = (StructureDefinition)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getDefaultEncodingId(), structureDefinition.getDefaultEncodingId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBaseDataType(), structureDefinition.getBaseDataType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStructureType(), structureDefinition.getStructureType())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFields(), structureDefinition.getFields());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getDefaultEncodingId(), this.getBaseDataType(), this.getStructureType(), this.getFields());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DefaultEncodingId.getSpecification().equals(fieldSpecification)) {
            return this.getDefaultEncodingId();
        }
        if (Fields.BaseDataType.getSpecification().equals(fieldSpecification)) {
            return this.getBaseDataType();
        }
        if (Fields.StructureType.getSpecification().equals(fieldSpecification)) {
            return this.getStructureType();
        }
        if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
            return this.getFields();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DefaultEncodingId.getSpecification().equals(fieldSpecification)) {
            this.setDefaultEncodingId((NodeId)object);
            return;
        }
        if (Fields.BaseDataType.getSpecification().equals(fieldSpecification)) {
            this.setBaseDataType((NodeId)object);
            return;
        }
        if (Fields.StructureType.getSpecification().equals(fieldSpecification)) {
            this.setStructureType((StructureType)object);
            return;
        }
        if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
            this.setFields((StructureField[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = StructureDefinition.builder();
        builder.setDefaultEncodingId(this.getDefaultEncodingId());
        builder.setBaseDataType(this.getBaseDataType());
        builder.setStructureType(this.getStructureType());
        builder.setFields(this.getFields());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.DefaultEncodingId.getSpecification());
        builder.addField(Fields.BaseDataType.getSpecification());
        builder.addField(Fields.StructureType.getSpecification());
        builder.addField(Fields.Fields.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("StructureDefinition");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.StructureDefinitionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return StructureDefinition.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeDefinition.Builder {
        private NodeId defaultEncodingId;
        private NodeId baseDataType;
        private StructureType structureType;
        private StructureField[] fields;

        protected Builder() {
        }

        public Builder setDefaultEncodingId(NodeId nodeId) {
            this.defaultEncodingId = nodeId;
            return this;
        }

        public Builder setBaseDataType(NodeId nodeId) {
            this.baseDataType = nodeId;
            return this;
        }

        public Builder setStructureType(StructureType structureType) {
            this.structureType = structureType;
            return this;
        }

        public Builder setFields(StructureField[] structureFieldArray) {
            this.fields = structureFieldArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DefaultEncodingId.getSpecification().equals(fieldSpecification)) {
                this.setDefaultEncodingId((NodeId)object);
                return this;
            }
            if (Fields.BaseDataType.getSpecification().equals(fieldSpecification)) {
                this.setBaseDataType((NodeId)object);
                return this;
            }
            if (Fields.StructureType.getSpecification().equals(fieldSpecification)) {
                this.setStructureType((StructureType)object);
                return this;
            }
            if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
                this.setFields((StructureField[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public StructureDefinition build() {
            return new StructureDefinition(this.defaultEncodingId, this.baseDataType, this.structureType, this.fields);
        }
    }

    public static enum Fields {
        DefaultEncodingId("DefaultEncodingId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        BaseDataType("BaseDataType", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        StructureType("StructureType", StructureType.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=98")), -1),
        Fields("Fields", StructureField[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=101")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

