/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=456")
public class SignatureData
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.SignatureData_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.SignatureData_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.SignatureData_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.SignatureData;
    public static final StructureSpecification SPECIFICATION;
    private String algorithm;
    private ByteString signature;

    public SignatureData() {
    }

    public SignatureData(String string, ByteString byteString) {
        this.algorithm = string;
        this.signature = byteString;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public ByteString getSignature() {
        return this.signature;
    }

    public void setSignature(ByteString byteString) {
        this.signature = byteString;
    }

    @Override
    public SignatureData clone() {
        SignatureData signatureData = (SignatureData)super.clone();
        signatureData.algorithm = StructureUtils.clone(this.algorithm);
        signatureData.signature = StructureUtils.clone(this.signature);
        return signatureData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SignatureData signatureData = (SignatureData)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getAlgorithm(), signatureData.getAlgorithm())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSignature(), signatureData.getSignature());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getAlgorithm(), this.getSignature());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Algorithm.getSpecification().equals(fieldSpecification)) {
            return this.getAlgorithm();
        }
        if (Fields.Signature.getSpecification().equals(fieldSpecification)) {
            return this.getSignature();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Algorithm.getSpecification().equals(fieldSpecification)) {
            this.setAlgorithm((String)object);
            return;
        }
        if (Fields.Signature.getSpecification().equals(fieldSpecification)) {
            this.setSignature((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = SignatureData.builder();
        builder.setAlgorithm(this.getAlgorithm());
        builder.setSignature(this.getSignature());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Algorithm.getSpecification());
        builder.addField(Fields.Signature.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("SignatureData");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.SignatureDataSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return SignatureData.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String algorithm;
        private ByteString signature;

        protected Builder() {
        }

        public Builder setAlgorithm(String string) {
            this.algorithm = string;
            return this;
        }

        public Builder setSignature(ByteString byteString) {
            this.signature = byteString;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Algorithm.getSpecification().equals(fieldSpecification)) {
                this.setAlgorithm((String)object);
                return this;
            }
            if (Fields.Signature.getSpecification().equals(fieldSpecification)) {
                this.setSignature((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public SignatureData build() {
            return new SignatureData(this.algorithm, this.signature);
        }
    }

    public static enum Fields {
        Algorithm("Algorithm", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        Signature("Signature", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

