/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=862")
public class ServerStatusDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ServerStatusDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ServerStatusDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ServerStatusDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ServerStatusDataType;
    public static final StructureSpecification SPECIFICATION;
    private DateTime startTime;
    private DateTime currentTime;
    private ServerState state;
    private BuildInfo buildInfo;
    private UnsignedInteger secondsTillShutdown;
    private LocalizedText shutdownReason;

    public ServerStatusDataType() {
    }

    public ServerStatusDataType(DateTime dateTime, DateTime dateTime2, ServerState serverState, BuildInfo buildInfo, UnsignedInteger unsignedInteger, LocalizedText localizedText) {
        this.startTime = dateTime;
        this.currentTime = dateTime2;
        this.state = serverState;
        this.buildInfo = buildInfo;
        this.secondsTillShutdown = unsignedInteger;
        this.shutdownReason = localizedText;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.startTime = dateTime;
    }

    public DateTime getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(DateTime dateTime) {
        this.currentTime = dateTime;
    }

    public ServerState getState() {
        return this.state;
    }

    public void setState(ServerState serverState) {
        this.state = serverState;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public UnsignedInteger getSecondsTillShutdown() {
        return this.secondsTillShutdown;
    }

    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
        this.secondsTillShutdown = unsignedInteger;
    }

    public LocalizedText getShutdownReason() {
        return this.shutdownReason;
    }

    public void setShutdownReason(LocalizedText localizedText) {
        this.shutdownReason = localizedText;
    }

    @Override
    public ServerStatusDataType clone() {
        ServerStatusDataType serverStatusDataType = (ServerStatusDataType)super.clone();
        serverStatusDataType.startTime = StructureUtils.clone(this.startTime);
        serverStatusDataType.currentTime = StructureUtils.clone(this.currentTime);
        serverStatusDataType.state = StructureUtils.clone(this.state);
        serverStatusDataType.buildInfo = StructureUtils.clone(this.buildInfo);
        serverStatusDataType.secondsTillShutdown = StructureUtils.clone(this.secondsTillShutdown);
        serverStatusDataType.shutdownReason = StructureUtils.clone(this.shutdownReason);
        return serverStatusDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServerStatusDataType serverStatusDataType = (ServerStatusDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), serverStatusDataType.getStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getCurrentTime(), serverStatusDataType.getCurrentTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getState(), serverStatusDataType.getState())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBuildInfo(), serverStatusDataType.getBuildInfo())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecondsTillShutdown(), serverStatusDataType.getSecondsTillShutdown())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getShutdownReason(), serverStatusDataType.getShutdownReason());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStartTime(), this.getCurrentTime(), this.getState(), this.getBuildInfo(), this.getSecondsTillShutdown(), this.getShutdownReason());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            return this.getStartTime();
        }
        if (Fields.CurrentTime.getSpecification().equals(fieldSpecification)) {
            return this.getCurrentTime();
        }
        if (Fields.State.getSpecification().equals(fieldSpecification)) {
            return this.getState();
        }
        if (Fields.BuildInfo.getSpecification().equals(fieldSpecification)) {
            return this.getBuildInfo();
        }
        if (Fields.SecondsTillShutdown.getSpecification().equals(fieldSpecification)) {
            return this.getSecondsTillShutdown();
        }
        if (Fields.ShutdownReason.getSpecification().equals(fieldSpecification)) {
            return this.getShutdownReason();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            this.setStartTime((DateTime)object);
            return;
        }
        if (Fields.CurrentTime.getSpecification().equals(fieldSpecification)) {
            this.setCurrentTime((DateTime)object);
            return;
        }
        if (Fields.State.getSpecification().equals(fieldSpecification)) {
            this.setState((ServerState)object);
            return;
        }
        if (Fields.BuildInfo.getSpecification().equals(fieldSpecification)) {
            this.setBuildInfo((BuildInfo)object);
            return;
        }
        if (Fields.SecondsTillShutdown.getSpecification().equals(fieldSpecification)) {
            this.setSecondsTillShutdown((UnsignedInteger)object);
            return;
        }
        if (Fields.ShutdownReason.getSpecification().equals(fieldSpecification)) {
            this.setShutdownReason((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ServerStatusDataType.builder();
        builder.setStartTime(this.getStartTime());
        builder.setCurrentTime(this.getCurrentTime());
        builder.setState(this.getState());
        builder.setBuildInfo(this.getBuildInfo());
        builder.setSecondsTillShutdown(this.getSecondsTillShutdown());
        builder.setShutdownReason(this.getShutdownReason());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StartTime.getSpecification());
        builder.addField(Fields.CurrentTime.getSpecification());
        builder.addField(Fields.State.getSpecification());
        builder.addField(Fields.BuildInfo.getSpecification());
        builder.addField(Fields.SecondsTillShutdown.getSpecification());
        builder.addField(Fields.ShutdownReason.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ServerStatusDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ServerStatusDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ServerStatusDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private DateTime startTime;
        private DateTime currentTime;
        private ServerState state;
        private BuildInfo buildInfo;
        private UnsignedInteger secondsTillShutdown;
        private LocalizedText shutdownReason;

        protected Builder() {
        }

        public Builder setStartTime(DateTime dateTime) {
            this.startTime = dateTime;
            return this;
        }

        public Builder setCurrentTime(DateTime dateTime) {
            this.currentTime = dateTime;
            return this;
        }

        public Builder setState(ServerState serverState) {
            this.state = serverState;
            return this;
        }

        public Builder setBuildInfo(BuildInfo buildInfo) {
            this.buildInfo = buildInfo;
            return this;
        }

        public Builder setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
            this.secondsTillShutdown = unsignedInteger;
            return this;
        }

        public Builder setShutdownReason(LocalizedText localizedText) {
            this.shutdownReason = localizedText;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
                this.setStartTime((DateTime)object);
                return this;
            }
            if (Fields.CurrentTime.getSpecification().equals(fieldSpecification)) {
                this.setCurrentTime((DateTime)object);
                return this;
            }
            if (Fields.State.getSpecification().equals(fieldSpecification)) {
                this.setState((ServerState)object);
                return this;
            }
            if (Fields.BuildInfo.getSpecification().equals(fieldSpecification)) {
                this.setBuildInfo((BuildInfo)object);
                return this;
            }
            if (Fields.SecondsTillShutdown.getSpecification().equals(fieldSpecification)) {
                this.setSecondsTillShutdown((UnsignedInteger)object);
                return this;
            }
            if (Fields.ShutdownReason.getSpecification().equals(fieldSpecification)) {
                this.setShutdownReason((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ServerStatusDataType build() {
            return new ServerStatusDataType(this.startTime, this.currentTime, this.state, this.buildInfo, this.secondsTillShutdown, this.shutdownReason);
        }
    }

    public static enum Fields {
        StartTime("StartTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        CurrentTime("CurrentTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        State("State", ServerState.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=852")), -1),
        BuildInfo("BuildInfo", BuildInfo.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=338")), -1),
        SecondsTillShutdown("SecondsTillShutdown", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        ShutdownReason("ShutdownReason", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

