/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=852")
public enum ServerState implements Enumeration
{
    Running(0),
    Failed(1),
    NoConfiguration(2),
    Suspended(3),
    Shutdown(4),
    Test(5),
    CommunicationFault(6),
    Unknown(7);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<ServerState> NONE;
    public static final EnumSet<ServerState> ALL;
    private static final Map<Integer, ServerState> map;
    private final int value;

    private ServerState(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static ServerState valueOf(int n2) {
        return map.get(n2);
    }

    public static ServerState valueOf(Integer n2) {
        return n2 == null ? null : ServerState.valueOf((int)n2);
    }

    public static ServerState valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : ServerState.valueOf(unsignedInteger.intValue());
    }

    public static ServerState[] valueOf(int[] nArray) {
        ServerState[] serverStateArray = new ServerState[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            serverStateArray[i2] = ServerState.valueOf(nArray[i2]);
        }
        return serverStateArray;
    }

    public static ServerState[] valueOf(Integer[] integerArray) {
        ServerState[] serverStateArray = new ServerState[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            serverStateArray[i2] = ServerState.valueOf(integerArray[i2]);
        }
        return serverStateArray;
    }

    public static ServerState[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        ServerState[] serverStateArray = new ServerState[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            serverStateArray[i2] = ServerState.valueOf(unsignedIntegerArray[i2]);
        }
        return serverStateArray;
    }

    public static UnsignedInteger getMask(ServerState ... serverStateArray) {
        int n2 = 0;
        for (ServerState serverState : serverStateArray) {
            n2 |= serverState.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<ServerState> collection) {
        int n2 = 0;
        for (ServerState serverState : collection) {
            n2 |= serverState.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<ServerState> getSet(UnsignedInteger unsignedInteger) {
        return ServerState.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<ServerState> getSet(int n2) {
        ArrayList<ServerState> arrayList = new ArrayList<ServerState>();
        for (ServerState serverState : ServerState.values()) {
            if ((n2 & serverState.value) != serverState.value) continue;
            arrayList.add(serverState);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ServerState.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(ServerState.class);
        ALL = EnumSet.allOf(ServerState.class);
        ServerState[] serverStateArray = EnumerationSpecification.builder();
        serverStateArray.setName("ServerState");
        serverStateArray.setTypeId(UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=852")));
        serverStateArray.addMapping(0, "Running");
        serverStateArray.addMapping(1, "Failed");
        serverStateArray.addMapping(2, "NoConfiguration");
        serverStateArray.addMapping(3, "Suspended");
        serverStateArray.addMapping(4, "Shutdown");
        serverStateArray.addMapping(5, "Test");
        serverStateArray.addMapping(6, "CommunicationFault");
        serverStateArray.addMapping(7, "Unknown");
        serverStateArray.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return ServerState.builder();
            }
        });
        SPECIFICATION = serverStateArray.build();
        map = new HashMap<Integer, ServerState>();
        for (ServerState serverState : ServerState.values()) {
            map.put(serverState.value, serverState);
        }
    }

    public static class Builder
    implements Enumeration.Builder {
        private ServerState value;

        private Builder() {
        }

        @Override
        public ServerState build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = ServerState.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum ServerState int value: " + n2);
            }
            return this;
        }
    }
}

